/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNItem;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNEditModeReader {
    private static final Map COMMANDS_MAP = new SVNHashMap();
    private SVNConnection myConnection;
    private ISVNEditor myEditor;
    private SVNDeltaReader myDeltaReader;
    private String myFilePath;
    private boolean myDone;
    private boolean myAborted;
    private boolean myForReplay;
    private Map myTokens;

    public SVNEditModeReader(SVNConnection connection, ISVNEditor editor, boolean forReplay) {
        this.myConnection = connection;
        this.myEditor = editor;
        this.myDeltaReader = new SVNDeltaReader();
        this.myDone = false;
        this.myAborted = false;
        this.myForReplay = forReplay;
        this.myTokens = new SVNHashMap();
    }

    public boolean isAborted() {
        return this.myAborted;
    }

    private void storeToken(String token, boolean isFile) {
        this.myTokens.put(token, isFile);
    }

    private void lookupToken(String token, boolean isFile) throws SVNException {
        Boolean tokenType = (Boolean)this.myTokens.get(token);
        if (tokenType == null || tokenType != Boolean.valueOf(isFile)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Invalid file or dir token during edit");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
    }

    private void removeToken(String token) {
        this.myTokens.remove(token);
    }

    private void processCommand(String commandName, List params) throws SVNException {
        if ("target-rev".equals(commandName)) {
            this.myEditor.targetRevision(SVNReader.getLong(params, 0));
        } else if ("open-root".equals(commandName)) {
            this.myEditor.openRoot(SVNReader.getLong(params, 0));
            String token = SVNReader.getString(params, 1);
            this.storeToken(token, false);
        } else if ("delete-entry".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 2), false);
            String path = SVNPathUtil.canonicalizePath(SVNReader.getString(params, 0));
            this.myEditor.deleteEntry(path, SVNReader.getLong(params, 1));
        } else if ("add-dir".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 1), false);
            String path = SVNPathUtil.canonicalizePath(SVNReader.getString(params, 0));
            String copyFromPath = SVNReader.getString(params, 3);
            if (copyFromPath != null) {
                copyFromPath = SVNPathUtil.canonicalizePath(copyFromPath);
            }
            this.myEditor.addDir(path, copyFromPath, SVNReader.getLong(params, 4));
            this.storeToken(SVNReader.getString(params, 2), false);
        } else if ("open-dir".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 1), false);
            String path = SVNPathUtil.canonicalizePath(SVNReader.getString(params, 0));
            this.myEditor.openDir(path, SVNReader.getLong(params, 3));
            this.storeToken(SVNReader.getString(params, 2), false);
        } else if ("change-dir-prop".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 0), false);
            byte[] bytes = SVNReader.getBytes(params, 2);
            String propertyName = SVNReader.getString(params, 1);
            this.myEditor.changeDirProperty(propertyName, SVNPropertyValue.create(propertyName, bytes));
        } else if ("close-dir".equals(commandName)) {
            String token = SVNReader.getString(params, 0);
            this.lookupToken(token, false);
            this.myEditor.closeDir();
            this.removeToken(token);
        } else if ("add-file".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 1), false);
            String path = SVNPathUtil.canonicalizePath(SVNReader.getString(params, 0));
            String copyFromPath = SVNReader.getString(params, 3);
            if (copyFromPath != null) {
                copyFromPath = SVNPathUtil.canonicalizePath(copyFromPath);
            }
            this.storeToken(SVNReader.getString(params, 2), true);
            this.myEditor.addFile(path, copyFromPath, SVNReader.getLong(params, 4));
            this.myFilePath = path;
        } else if ("open-file".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 1), false);
            String path = SVNPathUtil.canonicalizePath(SVNReader.getString(params, 0));
            this.storeToken(SVNReader.getString(params, 2), true);
            this.myEditor.openFile(SVNReader.getString(params, 0), SVNReader.getLong(params, 3));
            this.myFilePath = path;
        } else if ("change-file-prop".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 0), true);
            byte[] bytes = SVNReader.getBytes(params, 2);
            String propertyName = SVNReader.getString(params, 1);
            this.myEditor.changeFileProperty(this.myFilePath, propertyName, SVNPropertyValue.create(propertyName, bytes));
        } else if ("close-file".equals(commandName)) {
            String token = SVNReader.getString(params, 0);
            this.lookupToken(token, true);
            this.myEditor.closeFile(this.myFilePath, SVNReader.getString(params, 1));
            this.removeToken(token);
        } else if ("apply-textdelta".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 0), true);
            this.myEditor.applyTextDelta(this.myFilePath, SVNReader.getString(params, 1));
        } else if ("textdelta-chunk".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 0), true);
            byte[] chunk = SVNReader.getBytes(params, 1);
            this.myDeltaReader.nextWindow(chunk, 0, chunk.length, this.myFilePath, this.myEditor);
        } else if ("textdelta-end".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 0), true);
            this.myDeltaReader.reset(this.myFilePath, this.myEditor);
            this.myEditor.textDeltaEnd(this.myFilePath);
        } else if ("close-edit".equals(commandName)) {
            this.myEditor.closeEdit();
            this.myDone = true;
            this.myAborted = false;
            this.myConnection.write("(w())", new Object[]{"success"});
        } else if ("abort-edit".equals(commandName)) {
            this.myEditor.abortEdit();
            this.myDone = true;
            this.myAborted = true;
            this.myConnection.write("(w())", new Object[]{"success"});
        } else if ("failure".equals(commandName)) {
            this.myEditor.abortEdit();
            this.myDone = true;
            this.myAborted = true;
            ArrayList<SVNItem> items = new ArrayList<SVNItem>();
            Iterator lists = params.iterator();
            while (lists.hasNext()) {
                List list = (List)lists.next();
                SVNItem item = new SVNItem();
                item.setKind(2);
                item.setItems(list);
                items.add(item);
            }
            SVNReader.handleFailureStatus(items);
        } else if ("absent-dir".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 1), false);
            this.myEditor.absentDir(SVNReader.getString(params, 0));
        } else if ("absent-file".equals(commandName)) {
            this.lookupToken(SVNReader.getString(params, 1), false);
            this.myEditor.absentFile(SVNReader.getString(params, 0));
        } else if ("finish-replay".equals(commandName)) {
            if (!this.myForReplay) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.RA_SVN_UNKNOWN_CMD, "Command 'finish-replay' invalid outside of replays");
                SVNErrorManager.error(error, SVNLogType.NETWORK);
            }
            this.myDone = true;
            this.myAborted = false;
        }
    }

    public void driveEditor() throws SVNException {
        while (!this.myDone) {
            SVNErrorMessage error = null;
            List items = this.readTuple("wl", false);
            String commandName = SVNReader.getString(items, 0);
            String template = (String)COMMANDS_MAP.get(commandName);
            if (template == null) {
                SVNErrorMessage child = SVNErrorMessage.create(SVNErrorCode.RA_SVN_UNKNOWN_CMD, "Unknown command ''{0}''", commandName);
                error = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CMD_ERR);
                error.setChildErrorMessage(child);
            }
            if (template != null && items.get(1) instanceof Collection) {
                List parameters = SVNReader.parseTuple(template, (Collection)items.get(1), null);
                try {
                    this.processCommand(commandName, parameters);
                }
                catch (SVNException e) {
                    error = e.getErrorMessage();
                }
            }
            if (error == null) continue;
            if (error.getErrorCode() == SVNErrorCode.RA_SVN_CMD_ERR) {
                this.myAborted = true;
                if (!this.myDone) {
                    try {
                        this.myEditor.abortEdit();
                    }
                    catch (SVNException e) {
                        // empty catch block
                    }
                }
                this.myConnection.writeError(error.getChildErrorMessage());
                break;
            }
            SVNErrorManager.error(error, SVNLogType.NETWORK);
        }
        while (!this.myDone) {
            List items = this.readTuple("wl", false);
            String command = SVNReader.getString(items, 0);
            this.myDone = "abort-edit".equals(command) || "success".equals(command);
        }
    }

    private List readTuple(String template, boolean readMalformedData) throws SVNException {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        return this.myConnection.readTuple(template, readMalformedData);
    }

    static {
        COMMANDS_MAP.put("target-rev", "r");
        COMMANDS_MAP.put("open-root", "(?r)s");
        COMMANDS_MAP.put("delete-entry", "s(?r)s");
        COMMANDS_MAP.put("add-dir", "sss(?sr)");
        COMMANDS_MAP.put("open-dir", "sss(?r)");
        COMMANDS_MAP.put("change-dir-prop", "ss(?b)");
        COMMANDS_MAP.put("close-dir", "s");
        COMMANDS_MAP.put("add-file", "sss(?sr)");
        COMMANDS_MAP.put("open-file", "sss(?r)");
        COMMANDS_MAP.put("apply-textdelta", "s(?s)");
        COMMANDS_MAP.put("textdelta-chunk", "sb");
        COMMANDS_MAP.put("textdelta-end", "s");
        COMMANDS_MAP.put("change-file-prop", "ss(?b)");
        COMMANDS_MAP.put("close-file", "s(?b)");
        COMMANDS_MAP.put("close-edit", "()");
        COMMANDS_MAP.put("abort-edit", "()");
        COMMANDS_MAP.put("finish-replay", "()");
        COMMANDS_MAP.put("absent-dir", "ss");
        COMMANDS_MAP.put("absent-file", "ss");
        COMMANDS_MAP.put("failure", "l");
    }
}

