/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.ItemDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.openide.util.NbBundle;

public class TableItemDisplayPresenter
extends ItemDisplayPresenter {
    private static final int BORDER_LINE_WIDTH = 1;
    private static final int CELL_INSETS = 2;
    private static final int DOUBLE_CELL_INSETS = 4;
    private static final Stroke BORDER_STROKE = new BasicStroke(1.0f, 2, 1, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static JLabel fontLabel = new JLabel();
    private JPanel tablePanel = new JPanel(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            TableItemDisplayPresenter.this.paintTable(g);
        }
    };
    private boolean hasModel;
    private boolean modelIsUserCode;
    private boolean drawBorders = true;
    private String title;
    private String[] columnNames;
    private String[][] values;
    private Font titleFont;
    private Font headersFont;
    private Font valuesFont;

    public TableItemDisplayPresenter() {
        this.tablePanel.setOpaque(false);
        this.tablePanel.setPreferredSize(new Dimension(200, 40));
        this.setContentComponent(this.tablePanel);
        this.titleFont = fontLabel.getFont();
        this.headersFont = fontLabel.getFont().deriveFont(1);
        this.valuesFont = fontLabel.getFont();
    }

    private int printModelIsUserCode(Graphics g, int currY) {
        int newY = this.printTitle(g, currY);
        String msg = NbBundle.getMessage(TableItemDisplayPresenter.class, (String)"DISP_table_is_user_code");
        g.drawString(msg, 2, newY += ScreenSupport.getFontHeight((Graphics)g, (Font)this.getValuesFont()));
        return newY;
    }

    private int printTitle(Graphics g, int currY) {
        int newY = currY;
        if (this.title != null) {
            g.setFont(this.getTitleFont());
            g.drawString(this.title, 2, newY += ScreenSupport.getFontHeight((Graphics)g, (Font)this.getTitleFont()));
        }
        return newY;
    }

    private int printNoModel(Graphics g, int currY) {
        int newY = this.printTitle(g, currY);
        String msg = NbBundle.getMessage(TableItemDisplayPresenter.class, (String)"DISP_no_table_model_specified");
        g.drawString(msg, 2, newY += ScreenSupport.getFontHeight((Graphics)g, (Font)this.getValuesFont()));
        return newY;
    }

    private int printEmptyModel(Graphics g, int currY) {
        int newY = currY + ScreenSupport.getFontHeight((Graphics)g, (Font)this.getValuesFont());
        String msg = NbBundle.getMessage(TableItemDisplayPresenter.class, (String)"DISP_no_table_model_specified");
        g.drawString(msg, 2, newY);
        return newY;
    }

    private Font getTitleFont() {
        return this.titleFont;
    }

    private Font getHeadersFont() {
        return this.headersFont;
    }

    private Font getValuesFont() {
        return this.valuesFont;
    }

    private void paintTable(Graphics g) {
        int cummulativeY = 0;
        if (this.modelIsUserCode) {
            cummulativeY = this.printModelIsUserCode(g, cummulativeY);
        } else if (!this.hasModel) {
            cummulativeY = this.printNoModel(g, cummulativeY);
        } else if (this.values == null || this.values.length < 1) {
            cummulativeY = this.printEmptyModel(g, cummulativeY);
        } else {
            int i;
            Graphics2D g2D = (Graphics2D)g;
            Dimension oldSize = this.tablePanel.getSize();
            int width = oldSize.width;
            int height = oldSize.height;
            int firstRowY = 0;
            int[] colWidths = this.getColWidths(g, this.title, this.columnNames, this.values, this.getTitleFont(), this.getHeadersFont(), this.getValuesFont());
            if (this.title != null) {
                g.setFont(this.getTitleFont());
                int titleX = 3;
                g.drawString(this.title, titleX, cummulativeY += ScreenSupport.getFontHeight((Graphics)g, (Font)this.getTitleFont()));
                firstRowY = cummulativeY += 5;
            }
            if (this.columnNames != null) {
                g.setFont(this.getHeadersFont());
                firstRowY = cummulativeY;
                cummulativeY += ScreenSupport.getFontHeight((Graphics)g, (Font)this.getHeadersFont());
                int cummulativeX = 3;
                for (i = 0; i < this.columnNames.length && cummulativeX < width; ++i) {
                    String name = this.columnNames[i];
                    if (name != null) {
                        g.drawString(name, cummulativeX, cummulativeY);
                    }
                    if (colWidths == null) continue;
                    cummulativeX += colWidths[i];
                }
                cummulativeY += 5;
            }
            if (this.values != null && this.values.length > 0) {
                g.setFont(this.getValuesFont());
                for (int i2 = 0; i2 < this.values.length && cummulativeY < height; cummulativeY += 5, ++i2) {
                    String[] row = this.values[i2];
                    cummulativeY += ScreenSupport.getFontHeight((Graphics)g, (Font)this.getValuesFont());
                    int cummulativeX = 3;
                    for (int j = 0; j < row.length && cummulativeX < width; ++j) {
                        String cell = row[j];
                        if (cell != null) {
                            g.drawString(cell, cummulativeX, cummulativeY);
                        }
                        if (colWidths == null) continue;
                        cummulativeX += colWidths[j];
                    }
                }
            }
            if (this.drawBorders) {
                g2D.setStroke(BORDER_STROKE);
                g.drawRect(0, 0, width - 1, height - 1);
                g.drawLine(0, cummulativeY, width, cummulativeY);
                int borderY = 0;
                if (this.columnNames != null) {
                    g.drawLine(0, borderY += ScreenSupport.getFontHeight((Graphics)g, (Font)this.getHeadersFont()) + 4, width, borderY);
                    ++borderY;
                }
                if (this.values != null && this.values.length > 0) {
                    for (i = 0; i < this.values.length && borderY < height; ++borderY, ++i) {
                        g.drawLine(0, borderY += ScreenSupport.getFontHeight((Graphics)g, (Font)this.getValuesFont()) + 4, width, borderY);
                    }
                    int borderX = 0;
                    int rows = this.values[0].length;
                    for (int i3 = 0; i3 < rows && borderX < width; borderX += colWidths[i3], ++i3) {
                        g.drawLine(borderX, firstRowY, borderX, height - 1);
                    }
                }
            }
        }
    }

    public void reload(ScreenDeviceInfo deviceInfo) {
        super.reload(deviceInfo);
        PropertyValue value = this.getComponent().readProperty("title");
        this.title = PropertyValue.Kind.USERCODE.equals((Object)value.getKind()) ? NbBundle.getMessage(TableItemDisplayPresenter.class, (String)"DISP_title_is_user_code") : MidpTypes.getString((PropertyValue)value);
        value = this.getComponent().readProperty("model");
        this.modelIsUserCode = PropertyValue.Kind.USERCODE.equals((Object)value.getKind());
        if (!this.modelIsUserCode) {
            DesignComponent tableModelComponent = value.getComponent();
            boolean bl = this.hasModel = tableModelComponent != null;
            if (this.hasModel) {
                PropertyValue valuesProperty;
                PropertyValue columnsProperty;
                List list;
                value = this.getComponent().readProperty("borders");
                if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
                    this.drawBorders = MidpTypes.getBoolean((PropertyValue)value);
                }
                if ((list = (columnsProperty = tableModelComponent.readProperty("columnNames")).getArray()) != null) {
                    this.columnNames = new String[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        this.columnNames[i] = MidpTypes.getString((PropertyValue)((PropertyValue)list.get(i)));
                    }
                } else {
                    this.columnNames = null;
                }
                if ((list = (valuesProperty = tableModelComponent.readProperty("values")).getArray()) != null) {
                    this.values = new String[list.size()][];
                    for (int i = 0; i < list.size(); ++i) {
                        List<String> row = TableItemDisplayPresenter.gatherStringValues(((PropertyValue)list.get(i)).getArray());
                        this.values[i] = row.toArray(new String[row.size()]);
                    }
                } else {
                    this.values = null;
                }
            }
        } else {
            this.hasModel = false;
        }
        this.setFonts();
        this.tablePanel.setPreferredSize(this.calculatePrefferedSize());
        this.tablePanel.repaint();
    }

    private Dimension calculatePrefferedSize() {
        Dimension oldSize = this.tablePanel.getPreferredSize();
        int height = 0;
        if (this.title != null) {
            height += 4 + this.getTitleFont().getSize() + 1;
        }
        if (this.isMessageNoTable()) {
            height += 4 + this.getValuesFont().getSize();
        } else {
            if (this.columnNames != null) {
                height += 2 + this.getHeadersFont().getSize() + 1;
            }
            if (this.values != null) {
                height += (4 + this.getValuesFont().getSize() + 1) * this.values.length;
            }
        }
        return new Dimension(oldSize.width, height);
    }

    private boolean isMessageNoTable() {
        return this.modelIsUserCode || !this.hasModel || this.values == null || this.values.length < 1;
    }

    private static List<String> gatherStringValues(List<PropertyValue> propertyValues) {
        ArrayList<String> list = new ArrayList<String>(propertyValues.size());
        for (PropertyValue pv : propertyValues) {
            list.add(MidpTypes.getString((PropertyValue)pv));
        }
        return list;
    }

    private int[] getColWidths(Graphics g, String title, String[] headers, String[][] values, Font titleFont, Font headersFont, Font valuesFont) {
        if (values == null || values.length == 0) {
            return null;
        }
        int tableCols = values[0].length;
        int[] colWidths = new int[tableCols];
        for (int i = 0; i < tableCols; ++i) {
            colWidths[i] = this.tablePanel.getSize().width / tableCols;
        }
        return colWidths;
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> descriptors = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        PropertyValue value = this.getComponent().readProperty("model");
        DesignComponent tableModel = null;
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            tableModel = value.getComponent();
        }
        ResourcePropertyEditor tableModelDescriptor = null;
        tableModelDescriptor = tableModel == null ? new ResourcePropertyEditor("model", this.getComponent()) : new ResourcePropertyEditor("values", tableModel);
        descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.tablePanel, (ScreenPropertyEditor)tableModelDescriptor));
        return descriptors;
    }

    private void setFonts() {
        this.titleFont = this.getFont("titleFont");
        this.valuesFont = this.getFont("valuesFont");
        this.headersFont = this.doGetFont("headersFont");
        if (this.headersFont == null) {
            this.headersFont = fontLabel.getFont().deriveFont(1);
        }
    }

    private Font getFont(String property) {
        Font font = this.doGetFont(property);
        if (font == null) {
            return fontLabel.getFont();
        }
        return font;
    }

    private Font doGetFont(String property) {
        DesignComponent fontComponent = this.getComponent().readProperty(property).getComponent();
        if (fontComponent != null) {
            int kindCode = Integer.parseInt(fontComponent.readProperty("fontKind").getPrimitiveValue().toString());
            int faceCode = Integer.parseInt(fontComponent.readProperty("face").getPrimitiveValue().toString());
            int styleCode = Integer.parseInt(fontComponent.readProperty("style").getPrimitiveValue().toString());
            int sizeCode = Integer.parseInt(fontComponent.readProperty("bold").getPrimitiveValue().toString());
            return ScreenSupport.getFont((DesignDocument)this.getComponent().getDocument(), (int)kindCode, (int)faceCode, (int)styleCode, (int)sizeCode);
        }
        return null;
    }
}

