/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenTextAreaPropertyEditor;
import org.netbeans.modules.vmd.midpnb.screen.display.LoginScreenDisplayPresenter;
import org.openide.util.NbBundle;

public class SMSComposerDisplayPresenter
extends DisplayableDisplayPresenter {
    private JComponent view;
    private SMSView smsView;
    private static final String USER_CODE = NbBundle.getMessage(LoginScreenDisplayPresenter.class, (String)"LBL_UserCode");
    private static final String NULL_TEXT = NbBundle.getMessage(LoginScreenDisplayPresenter.class, (String)"LBL_NULL");

    public void reload(ScreenDeviceInfo deviceInfo) {
        super.reload(deviceInfo);
        if (this.smsView != null) {
            this.smsView.updateView();
        }
    }

    public JComponent getView() {
        if (this.view == null) {
            this.view = super.getView();
            this.smsView = new SMSView();
            super.getView().add(this.smsView);
        }
        return this.view;
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> desciptors = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        desciptors.addAll(Arrays.asList(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.smsView.messageLabel, (ScreenPropertyEditor)new ScreenStringPropertyEditor("messageLabel", 0)), new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.smsView.messageTextrArea, (ScreenPropertyEditor)new ScreenTextAreaPropertyEditor("message")), new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.smsView.phoneNumberLabel, (ScreenPropertyEditor)new ScreenStringPropertyEditor("phoneNumberLabel", 0)), new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.smsView.phoneNumberTextField, (ScreenPropertyEditor)new ScreenStringPropertyEditor("phoneNumber", 0))));
        return desciptors;
    }

    private class SMSView
    extends JPanel {
        private JTextArea messageTextrArea;
        private JLabel messageLabel;
        private JScrollPane messageScrollPane;
        private JTextField phoneNumberTextField;
        private JLabel phoneNumberLabel;

        SMSView() {
            this.initComponents();
        }

        private void initComponents() {
            this.phoneNumberLabel = new JLabel();
            this.messageLabel = new JLabel();
            this.phoneNumberTextField = new JTextField();
            this.messageScrollPane = new JScrollPane();
            this.messageTextrArea = new JTextArea();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(50, 20, 0, 0);
            this.add((Component)this.phoneNumberLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 20, 0, 0);
            this.add((Component)this.messageLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(50, 4, 0, 30);
            this.add((Component)this.phoneNumberTextField, gridBagConstraints);
            this.messageTextrArea.setColumns(20);
            this.messageTextrArea.setRows(5);
            this.messageScrollPane.setViewportView(this.messageTextrArea);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)this.messageScrollPane, gridBagConstraints);
            this.updateView();
        }

        void updateView() {
            final DesignComponent component = SMSComposerDisplayPresenter.this.getComponent();
            if (component == null) {
                return;
            }
            component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Integer frgColor;
                    PropertyValue phoneNumberLabelTextPV = component.readProperty("phoneNumberLabel");
                    String phoneNumberLabelText = phoneNumberLabelTextPV.getKind() == PropertyValue.Kind.VALUE ? (String)phoneNumberLabelTextPV.getPrimitiveValue() : (phoneNumberLabelTextPV.getKind() == PropertyValue.Kind.USERCODE ? USER_CODE : NULL_TEXT);
                    SMSView.this.phoneNumberLabel.setText(phoneNumberLabelText);
                    PropertyValue phoneNumberTextFieldPV = component.readProperty("phoneNumber");
                    String phoneNumberText = null;
                    if (phoneNumberTextFieldPV.getKind() == PropertyValue.Kind.VALUE) {
                        SMSView.this.phoneNumberTextField.setEditable(true);
                        phoneNumberText = (String)phoneNumberTextFieldPV.getPrimitiveValue();
                    } else if (phoneNumberTextFieldPV.getKind() == PropertyValue.Kind.USERCODE) {
                        phoneNumberText = USER_CODE;
                        SMSView.this.phoneNumberTextField.setEnabled(false);
                    }
                    SMSView.this.phoneNumberTextField.setText(phoneNumberText);
                    PropertyValue messageLabelStringPV = component.readProperty("messageLabel");
                    String messageLabelString = null;
                    if (messageLabelStringPV.getKind() == PropertyValue.Kind.VALUE) {
                        messageLabelString = (String)messageLabelStringPV.getPrimitiveValue();
                    } else if (messageLabelStringPV.getKind() == PropertyValue.Kind.USERCODE) {
                        messageLabelString = USER_CODE;
                    } else {
                        phoneNumberText = NULL_TEXT;
                    }
                    SMSView.this.messageLabel.setText(messageLabelString);
                    PropertyValue messageTextAreaPV = component.readProperty("message");
                    String messageText = null;
                    if (messageTextAreaPV.getKind() == PropertyValue.Kind.VALUE) {
                        SMSView.this.messageTextrArea.setEnabled(true);
                        messageText = (String)messageTextAreaPV.getPrimitiveValue();
                    } else if (messageTextAreaPV.getKind() == PropertyValue.Kind.USERCODE) {
                        messageText = USER_CODE;
                        SMSView.this.messageTextrArea.setEnabled(false);
                    }
                    SMSView.this.messageTextrArea.setText(messageText);
                    Integer bkgColor = (Integer)component.readProperty("backgroundColor").getPrimitiveValue();
                    if (bkgColor != null) {
                        SMSView.this.setBackground(new Color(bkgColor));
                    }
                    if ((frgColor = (Integer)component.readProperty("foregroungColor").getPrimitiveValue()) != null) {
                        Color color = new Color(frgColor);
                        SMSView.this.setForeground(color);
                        SMSView.this.phoneNumberLabel.setForeground(color);
                        SMSView.this.messageLabel.setForeground(color);
                        SMSView.this.phoneNumberTextField.setForeground(color);
                        SMSView.this.messageTextrArea.setForeground(color);
                    }
                }
            });
        }
    }
}

