/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midpnb.components.commands.SVGMenuSelectCommandCD;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorSVGMenuSelectCommand
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private List<String> tags = new ArrayList<String>();
    private Map<String, DesignComponent> values = new TreeMap<String, DesignComponent>();
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private TypeID typeID;
    private String noneItem;
    private String defaultItem;
    private String mnemonic;

    public static PropertyEditorSVGMenuSelectCommand createInstanceMenuSelect() {
        String mnemonic = NbBundle.getMessage(PropertyEditorSVGMenuSelectCommand.class, (String)"LBL_SEL_COMMAND_STR");
        String noneItem = NbBundle.getMessage(PropertyEditorSVGMenuSelectCommand.class, (String)"LBL_SELECTCOMMAND_NONE");
        String defaultItem = NbBundle.getMessage(PropertyEditorSVGMenuSelectCommand.class, (String)"LBL_SELECTCOMMAND_DEFAULT");
        String userCodeLabel = NbBundle.getMessage(PropertyEditorSVGMenuSelectCommand.class, (String)"LBL_SELECTCOMMAND_UCLABEL");
        return new PropertyEditorSVGMenuSelectCommand(SVGMenuSelectCommandCD.TYPEID, mnemonic, noneItem, defaultItem, userCodeLabel);
    }

    private PropertyEditorSVGMenuSelectCommand(TypeID typeID, String mnemonic, String noneItem, String defaultItem, String userCodeLabel) {
        super(userCodeLabel);
        this.mnemonic = mnemonic;
        this.typeID = typeID;
        this.noneItem = noneItem;
        this.defaultItem = defaultItem;
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.typeID = null;
        if (this.values != null) {
            this.values.clear();
            this.values = null;
        }
        this.tags = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        this.customEditor = new CustomEditor();
        this.radioButton.addActionListener(this.customEditor);
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return this.noneItem;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return this.getDecodeValue(value);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    public void updateState(PropertyValue value) {
        this.customEditor.updateModel();
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.setValue(null);
        } else {
            this.customEditor.setValue(value);
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String text) {
        if (text.length() > 0) {
            if (this.noneItem.equals(text)) {
                super.setValue((Object)NULL_VALUE);
            } else {
                super.setValue((Object)PropertyValue.createComponentReference((DesignComponent)this.getCommandEvenSource(text)));
            }
        }
    }

    public void customEditorOKButtonPressed() {
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public Boolean canEditAsText() {
        return null;
    }

    public String[] getTags() {
        this.tags.clear();
        if (this.isCurrentValueAUserCodeType()) {
            this.tags.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            this.tags.add(this.noneItem);
            this.values.clear();
            this.values.put(this.noneItem, null);
            if (this.component != null && this.component.get() != null) {
                final DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
                document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        Collection components = MidpDocumentSupport.getCategoryComponent((DesignDocument)document, (TypeID)CommandsCategoryCD.TYPEID).getComponents();
                        ArrayList<DesignComponent> commands = new ArrayList<DesignComponent>(components.size());
                        for (DesignComponent command : components) {
                            PropertyValue ordinaryValue = command.readProperty("ordinary");
                            if (!MidpTypes.getBoolean((PropertyValue)ordinaryValue)) continue;
                            commands.add(command);
                        }
                        PropertyEditorSVGMenuSelectCommand.this.tags.add(PropertyEditorSVGMenuSelectCommand.this.defaultItem);
                        PropertyEditorSVGMenuSelectCommand.this.values.put(PropertyEditorSVGMenuSelectCommand.this.defaultItem, PropertyEditorSVGMenuSelectCommand.this.getListSelectCommand(document));
                        for (DesignComponent command : commands) {
                            String displayName = PropertyEditorSVGMenuSelectCommand.this.getComponentDisplayName(command);
                            PropertyEditorSVGMenuSelectCommand.this.tags.add(displayName);
                            PropertyEditorSVGMenuSelectCommand.this.values.put(displayName, command);
                        }
                    }
                });
            }
        }
        return this.tags.toArray(new String[this.tags.size()]);
    }

    private DesignComponent getListSelectCommand(DesignDocument document) {
        return MidpDocumentSupport.getSingletonCommand((DesignDocument)document, (TypeID)this.typeID);
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.mnemonic);
            this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
            this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private String getComponentDisplayName(DesignComponent component) {
        return MidpValueSupport.getHumanReadableString((DesignComponent)component);
    }

    private String getDecodeValue(final PropertyValue value) {
        final String[] decodeValue = new String[1];
        if (this.component != null && this.component.get() != null) {
            final DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
            document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent refComponent;
                    PropertyValue pv;
                    DesignComponent valueComponent = value.getComponent();
                    decodeValue[0] = valueComponent != null ? ((pv = valueComponent.readProperty("command")) != null ? ((refComponent = pv.getComponent()) != null && refComponent.equals(PropertyEditorSVGMenuSelectCommand.this.getListSelectCommand(document)) ? PropertyEditorSVGMenuSelectCommand.this.defaultItem : PropertyEditorSVGMenuSelectCommand.this.getComponentDisplayName(valueComponent)) : PropertyEditorSVGMenuSelectCommand.this.noneItem) : PropertyEditorSVGMenuSelectCommand.this.noneItem;
                }
            });
        }
        return decodeValue[0];
    }

    private DesignComponent getCommandEvenSource(final String name) {
        final DesignComponent[] itemCommandEvenSource = new DesignComponent[1];
        if (this.component != null && this.component.get() != null) {
            final DesignComponent listComponent = (DesignComponent)this.component.get();
            listComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent command = (DesignComponent)PropertyEditorSVGMenuSelectCommand.this.values.get(name);
                    List listESValues = listComponent.readProperty("commands").getArray();
                    for (PropertyValue esValue : listESValues) {
                        DesignComponent existingES = esValue.getComponent();
                        if (!existingES.readProperty("command").getComponent().equals(command)) continue;
                        itemCommandEvenSource[0] = existingES;
                        break;
                    }
                    if (itemCommandEvenSource[0] == null) {
                        itemCommandEvenSource[0] = MidpDocumentSupport.attachCommandToDisplayable((DesignComponent)listComponent, (DesignComponent)command);
                    }
                }
            });
        }
        return itemCommandEvenSource[0];
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JComboBox combobox;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            if (this.combobox != null) {
                this.combobox.removeActionListener(this);
                this.combobox = null;
            }
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.combobox = new JComboBox();
            this.combobox.getAccessibleContext().setAccessibleName(PropertyEditorSVGMenuSelectCommand.this.radioButton.getAccessibleContext().getAccessibleName());
            this.combobox.getAccessibleContext().setAccessibleDescription(PropertyEditorSVGMenuSelectCommand.this.radioButton.getAccessibleContext().getAccessibleDescription());
            this.combobox.setModel(new DefaultComboBoxModel());
            this.combobox.addActionListener(this);
            this.add((Component)this.combobox, "Center");
        }

        public void setValue(final PropertyValue value) {
            if (value == null) {
                this.combobox.setSelectedItem(PropertyEditorSVGMenuSelectCommand.this.noneItem);
                return;
            }
            final PropertyValue[] cmdValue = new PropertyValue[1];
            if (PropertyEditorSVGMenuSelectCommand.this.component != null && PropertyEditorSVGMenuSelectCommand.this.component.get() != null) {
                ((DesignComponent)PropertyEditorSVGMenuSelectCommand.this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        cmdValue[0] = value.getComponent().readProperty("command");
                    }
                });
            }
            if (cmdValue[0] == null) {
                return;
            }
            DesignComponent command = cmdValue[0].getComponent();
            for (String key : PropertyEditorSVGMenuSelectCommand.this.values.keySet()) {
                DesignComponent tmpCommand = (DesignComponent)PropertyEditorSVGMenuSelectCommand.this.values.get(key);
                if (tmpCommand == null || !tmpCommand.equals(command)) continue;
                this.combobox.setSelectedItem(key);
                break;
            }
        }

        public String getText() {
            return (String)this.combobox.getSelectedItem();
        }

        public void updateModel() {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.combobox.getModel();
            model.removeAllElements();
            for (String tag : PropertyEditorSVGMenuSelectCommand.this.tags) {
                model.addElement(tag);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PropertyEditorSVGMenuSelectCommand.this.radioButton.setSelected(true);
        }
    }
}

