/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.safedelete;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.WebXmlRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebXmlSafeDelete
extends WebXmlRefactoring {
    private final SafeDeleteRefactoring safeDelete;
    private final List<String> classes;

    public WebXmlSafeDelete(FileObject webDD, WebApp webModel, SafeDeleteRefactoring safeDelete) {
        super(webDD, webModel);
        this.safeDelete = safeDelete;
        this.classes = RefactoringUtil.getRefactoredClasses((AbstractRefactoring)safeDelete);
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        for (String clazzFqn : this.classes) {
            for (Servlet servlet : this.getServlets(clazzFqn)) {
                refactoringElements.add((AbstractRefactoring)this.safeDelete, (RefactoringElementImplementation)new ServletRemoveElement(this.webModel, this.webDD, servlet));
                for (ServletMapping servletMapping : this.getServletMappings(servlet)) {
                    refactoringElements.add((AbstractRefactoring)this.safeDelete, (RefactoringElementImplementation)new ServletMappingRemoveElement(this.webModel, this.webDD, servletMapping));
                }
            }
            for (Filter filter : this.getFilters(clazzFqn)) {
                refactoringElements.add((AbstractRefactoring)this.safeDelete, (RefactoringElementImplementation)new FilterRemoveElement(this.webModel, this.webDD, filter));
                for (FilterMapping filterMapping : this.getFilterMappings(filter)) {
                    refactoringElements.add((AbstractRefactoring)this.safeDelete, (RefactoringElementImplementation)new FilterMappingRemoveElement(this.webModel, this.webDD, filterMapping));
                }
            }
            for (Listener listener : this.getListeners(clazzFqn)) {
                refactoringElements.add((AbstractRefactoring)this.safeDelete, (RefactoringElementImplementation)new ListenerRemoveElement(this.webModel, this.webDD, listener));
            }
        }
        return null;
    }

    private List<ServletMapping> getServletMappings(Servlet servlet) {
        ArrayList<ServletMapping> result = new ArrayList<ServletMapping>();
        for (ServletMapping mapping : this.webModel.getServletMapping()) {
            if (!mapping.getServletName().equals(servlet.getServletName())) continue;
            result.add(mapping);
        }
        return result;
    }

    private List<FilterMapping> getFilterMappings(Filter filter) {
        ArrayList<FilterMapping> result = new ArrayList<FilterMapping>();
        for (FilterMapping mapping : this.webModel.getFilterMapping()) {
            if (!mapping.getFilterName().equals(filter.getFilterName())) continue;
            result.add(mapping);
        }
        return result;
    }

    private static class ListenerRemoveElement
    extends WebXmlRefactoring.WebRefactoringElement {
        private Listener listener;

        public ListenerRemoveElement(WebApp webApp, FileObject webDD, Listener listener) {
            super(webApp, webDD);
            this.listener = listener;
        }

        @Override
        protected void doChange() {
            this.webApp.removeListener(this.listener);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.listener.getListenerClass()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlSafeDelete.class, (String)"TXT_WebXmlListenerSafeDelete"), args);
        }

        @Override
        protected void undo() {
            this.webApp.addListener(this.listener);
        }

        @Override
        protected String getName() {
            return null;
        }
    }

    private static class FilterMappingRemoveElement
    extends WebXmlRefactoring.WebRefactoringElement {
        private FilterMapping mapping;

        public FilterMappingRemoveElement(WebApp webApp, FileObject webDD, FilterMapping mapping) {
            super(webApp, webDD);
            this.mapping = mapping;
        }

        @Override
        protected void doChange() {
            this.webApp.removeFilterMapping(this.mapping);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.mapping.getFilterName()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlSafeDelete.class, (String)"TXT_WebXmlFilterMappingSafeDelete"), args);
        }

        @Override
        protected void undo() {
            this.webApp.addFilterMapping(this.mapping);
        }

        @Override
        protected String getName() {
            return null;
        }
    }

    private static class FilterRemoveElement
    extends WebXmlRefactoring.WebRefactoringElement {
        private Filter filter;

        public FilterRemoveElement(WebApp webApp, FileObject webDD, Filter filter) {
            super(webApp, webDD);
            this.filter = filter;
        }

        @Override
        protected void doChange() {
            this.webApp.removeFilter(this.filter);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.filter.getFilterClass()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlSafeDelete.class, (String)"TXT_WebXmlFilterSafeDelete"), args);
        }

        @Override
        protected void undo() {
            this.webApp.addFilter(this.filter);
        }

        @Override
        protected String getName() {
            return this.filter.getFilterClass();
        }
    }

    private static class ServletMappingRemoveElement
    extends WebXmlRefactoring.WebRefactoringElement {
        private ServletMapping mapping;

        public ServletMappingRemoveElement(WebApp webApp, FileObject webDD, ServletMapping mapping) {
            super(webApp, webDD);
            this.mapping = mapping;
        }

        @Override
        protected void doChange() {
            this.webApp.removeServletMapping(this.mapping);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.mapping.getServletName()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlSafeDelete.class, (String)"TXT_WebXmlServletMappingSafeDelete"), args);
        }

        @Override
        protected void undo() {
            this.webApp.addServletMapping(this.mapping);
        }

        @Override
        protected String getName() {
            return this.mapping.getServletName();
        }
    }

    private static class ServletRemoveElement
    extends WebXmlRefactoring.WebRefactoringElement {
        private Servlet servlet;

        public ServletRemoveElement(WebApp webApp, FileObject webDD, Servlet servlet) {
            super(webApp, webDD);
            this.servlet = servlet;
        }

        @Override
        protected void doChange() {
            this.webApp.removeServlet(this.servlet);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.servlet.getServletClass()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlSafeDelete.class, (String)"TXT_WebXmlServletSafeDelete"), args);
        }

        @Override
        protected void undo() {
            this.webApp.addServlet(this.servlet);
        }

        @Override
        protected String getName() {
            return this.servlet.getServletClass();
        }
    }
}

