/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.text.MessageFormat;
import java.util.List;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.refactoring.WebXmlRefactoring;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

abstract class BaseWebXmlRename
extends WebXmlRefactoring {
    public BaseWebXmlRename(FileObject webDD, WebApp webModel) {
        super(webDD, webModel);
    }

    protected abstract AbstractRefactoring getRefactoring();

    protected abstract List<RenameItem> getRenameItems();

    @Override
    public final Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        Problem current = null;
        for (RenameItem item : this.getRenameItems()) {
            String newName = item.getNewFqn();
            String oldFqn = item.getOldFqn();
            if (item.getProblem() != null) {
                if (problem == null) {
                    current = problem = item.getProblem();
                    continue;
                }
                current.setNext(item.getProblem());
                current = item.getProblem();
                continue;
            }
            for (Servlet servlet : this.getServlets(oldFqn)) {
                refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new ServletRenameElement(newName, oldFqn, this.webModel, this.webDD, servlet));
            }
            for (Listener listener : this.getListeners(oldFqn)) {
                refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new ListenerRenameElement(newName, oldFqn, this.webModel, this.webDD, listener));
            }
            for (Filter filter : this.getFilters(oldFqn)) {
                refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new FilterRenameElement(newName, oldFqn, this.webModel, this.webDD, filter));
            }
            for (EjbRef ejbRef : this.getEjbRefs(oldFqn, true)) {
                refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new EjbRemoteRefRenameElement(newName, oldFqn, this.webModel, this.webDD, ejbRef));
            }
            for (EjbRef ejbRef : this.getEjbRefs(oldFqn, false)) {
                refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new EjbHomeRefRenameElement(newName, oldFqn, this.webModel, this.webDD, ejbRef));
            }
            for (EjbLocalRef ejbLocalRef : this.getEjbLocalRefs(oldFqn, false)) {
                refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new EjbLocalRefRenameElement(newName, oldFqn, this.webModel, this.webDD, ejbLocalRef));
            }
            for (EjbLocalRef ejbLocalRef : this.getEjbLocalRefs(oldFqn, true)) {
                refactoringElements.add(this.getRefactoring(), (RefactoringElementImplementation)new EjbLocalHomeRefRenameElement(newName, oldFqn, this.webModel, this.webDD, ejbLocalRef));
            }
        }
        return problem;
    }

    private static class EjbLocalHomeRefRenameElement
    extends WebRenameElement {
        private EjbLocalRef ejbLocalRef;

        public EjbLocalHomeRefRenameElement(String newName, String oldName, WebApp webApp, FileObject webDD, EjbLocalRef ejbLocalRef) {
            super(newName, oldName, webApp, webDD);
            this.ejbLocalRef = ejbLocalRef;
        }

        @Override
        protected void doChange() {
            this.ejbLocalRef.setLocalHome(this.newName);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlRefLocalHomeRename"), args);
        }

        @Override
        protected void undo() {
            this.ejbLocalRef.setLocalHome(this.oldName);
        }
    }

    private static class EjbLocalRefRenameElement
    extends WebRenameElement {
        private EjbLocalRef ejbLocalRef;

        public EjbLocalRefRenameElement(String newName, String oldName, WebApp webApp, FileObject webDD, EjbLocalRef ejbLocalRef) {
            super(newName, oldName, webApp, webDD);
            this.ejbLocalRef = ejbLocalRef;
        }

        @Override
        protected void doChange() {
            this.ejbLocalRef.setLocal(this.newName);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlRefLocalRename"), args);
        }

        @Override
        protected void undo() {
            this.ejbLocalRef.setLocal(this.oldName);
        }
    }

    private static class EjbRemoteRefRenameElement
    extends WebRenameElement {
        private EjbRef ejbRef;

        public EjbRemoteRefRenameElement(String newName, String oldName, WebApp webApp, FileObject webDD, EjbRef ejbRef) {
            super(newName, oldName, webApp, webDD);
            this.ejbRef = ejbRef;
        }

        @Override
        protected void doChange() {
            this.ejbRef.setRemote(this.newName);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlRefRemoteRename"), args);
        }

        @Override
        protected void undo() {
            this.ejbRef.setRemote(this.oldName);
        }
    }

    private static class EjbHomeRefRenameElement
    extends WebRenameElement {
        private EjbRef ejbRef;

        public EjbHomeRefRenameElement(String newName, String oldName, WebApp webApp, FileObject webDD, EjbRef ejbRef) {
            super(newName, oldName, webApp, webDD);
            this.ejbRef = ejbRef;
        }

        @Override
        protected void doChange() {
            this.ejbRef.setHome(this.newName);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlRefHomeRename"), args);
        }

        @Override
        protected void undo() {
            this.ejbRef.setHome(this.oldName);
        }
    }

    private static class ListenerRenameElement
    extends WebRenameElement {
        private Listener listener;

        public ListenerRenameElement(String newName, String oldName, WebApp webApp, FileObject webDD, Listener listener) {
            super(newName, oldName, webApp, webDD);
            this.listener = listener;
        }

        @Override
        protected void doChange() {
            this.listener.setListenerClass(this.newName);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlListenerRename"), args);
        }

        @Override
        protected void undo() {
            this.listener.setListenerClass(this.oldName);
        }
    }

    private static class FilterRenameElement
    extends WebRenameElement {
        private Filter filter;

        public FilterRenameElement(String newName, String oldName, WebApp webApp, FileObject webDD, Filter filter) {
            super(newName, oldName, webApp, webDD);
            this.filter = filter;
        }

        @Override
        protected void doChange() {
            this.filter.setFilterClass(this.newName);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlFilterRename"), args);
        }

        @Override
        protected void undo() {
            this.filter.setFilterClass(this.oldName);
        }
    }

    private static class ServletRenameElement
    extends WebRenameElement {
        private Servlet servlet;

        public ServletRenameElement(String newName, String oldName, WebApp webApp, FileObject webDD, Servlet servlet) {
            super(newName, oldName, webApp, webDD);
            this.servlet = servlet;
        }

        @Override
        protected void doChange() {
            this.servlet.setServletClass(this.newName);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.getParentFile().getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(BaseWebXmlRename.class, (String)"TXT_WebXmlServletRename"), args);
        }

        @Override
        protected void undo() {
            this.servlet.setServletClass(this.oldName);
        }
    }

    private static abstract class WebRenameElement
    extends WebXmlRefactoring.WebRefactoringElement {
        protected String oldName;
        protected String newName;

        public WebRenameElement(String newName, String oldName, WebApp webApp, FileObject webDD) {
            super(webApp, webDD);
            this.newName = newName;
            this.oldName = oldName;
        }

        @Override
        protected String getName() {
            return this.oldName;
        }
    }
}

