/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSFileInformation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public abstract class VCSFileNode<I extends VCSFileInformation> {
    private final File file;
    private final File root;
    private String shortPath;
    private VCSCommitOptions commitOption;

    public VCSFileNode(File root, File file) {
        assert (file != null && root != null);
        this.file = file;
        this.root = root;
    }

    public abstract VCSCommitOptions getDefaultCommitOption(boolean var1);

    public abstract I getInformation();

    public VCSCommitOptions getCommitOptions() {
        if (this.commitOption == null) {
            this.commitOption = this.getDefaultCommitOption(true);
        }
        return this.commitOption;
    }

    void setCommitOptions(VCSCommitOptions option) {
        this.commitOption = option;
    }

    public String getName() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof VCSFileNode && this.file.equals(((VCSFileNode)o).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public FileObject getFileObject() {
        return FileUtil.toFileObject((File)this.file);
    }

    public Object[] getLookupObjects() {
        ArrayList<File> list = new ArrayList<File>(2);
        list.add(this.file);
        FileObject fo = this.getFileObject();
        if (fo != null) {
            list.add((File)fo);
        }
        return list.toArray(new Object[list.size()]);
    }

    public String getRelativePath() {
        if (this.shortPath == null) {
            this.shortPath = this.file.getAbsolutePath();
            String rootPath = this.root.getAbsolutePath();
            if (this.shortPath.startsWith(rootPath)) {
                if (this.shortPath.length() == rootPath.length()) {
                    return ".";
                }
                return this.shortPath.substring(rootPath.length() + 1);
            }
            return NbBundle.getMessage(VCSFileNode.class, (String)"LBL_Location_NotInRepository");
        }
        return this.shortPath;
    }
}

