/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SummaryCellRenderer
implements TreeCellRenderer {
    private static final double DARKEN_FACTOR = 0.95;
    private final AbstractSummaryView master;
    private final Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap;
    private final VCSHyperlinkSupport linkerSupport;
    private Color selectionBackgroundColor = new JList().getSelectionBackground();
    private String selectionBackground = SummaryCellRenderer.getColorString(this.selectionBackgroundColor);
    private String selectionForeground = SummaryCellRenderer.getColorString(new JList().getSelectionForeground());
    private final Color normalBackgroundColor = this.darker(UIManager.getColor("List.background"));
    private final String normalForeground = SummaryCellRenderer.getColorString(UIManager.getColor("List.foreground"));
    private final String normalBackground = SummaryCellRenderer.getColorString(this.normalBackgroundColor);
    private final String authorColor;
    private final String dateColor = this.authorColor = SummaryCellRenderer.getColorString(UIManager.getColor("TextPane.inactiveForeground"));
    private final String pathColor = this.authorColor;
    private final String linkColor = SummaryCellRenderer.getColorString(Color.BLUE);
    private RevisionRenderer cr = new RevisionRenderer();
    private EventRenderer rr = new EventRenderer();
    private ActionRenderer ar = new ActionRenderer();
    private DefaultTreeCellRenderer dtcr = new DefaultTreeCellRenderer();
    private int handleWidth = -1;
    private int oneLineHeight;
    private AttributeSet searchHiliteAttrs;
    private final String hiliteMessage;
    private double authorMaxWidth;
    private double dateMaxWidth;
    private double revisionMaxWidth;

    public SummaryCellRenderer(AbstractSummaryView master, final VCSHyperlinkSupport linkerSupport, List<AbstractSummaryView.LogEntry> results, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap) {
        this.master = master;
        this.hiliteMessage = master.getMessage();
        this.kenaiUsersMap = kenaiUsersMap;
        this.linkerSupport = linkerSupport;
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fcs.getFontColors("highlight-search");
        this.computeFieldSizes(results);
        master.getList().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object o = path.getLastPathComponent();
                if (o instanceof AbstractSummaryView.LogEntryNode) {
                    AbstractSummaryView.LogEntry le = (AbstractSummaryView.LogEntry)((AbstractSummaryView.LogEntryNode)o).getUserObject();
                    linkerSupport.remove(ActionHyperlink.class, le.getRevision());
                }
            }
        });
    }

    private void computeFieldSizes(List<AbstractSummaryView.LogEntry> results) {
        ArrayList<AbstractSummaryView.LogEntry> newResults = new ArrayList<AbstractSummaryView.LogEntry>(results.size());
        JTree t = new JTree();
        FontMetrics fm = t.getFontMetrics(t.getFont());
        for (AbstractSummaryView.LogEntry entry : results) {
            newResults.add(entry);
            double w = SwingUtilities.computeStringWidth(fm, entry.getAuthor());
            if (w > this.authorMaxWidth) {
                this.authorMaxWidth = w;
            }
            if ((w = (double)SwingUtilities.computeStringWidth(fm, entry.getDate())) > this.dateMaxWidth) {
                this.dateMaxWidth = w;
            }
            if (!((w = (double)SwingUtilities.computeStringWidth(fm, entry.getRevision())) > this.revisionMaxWidth)) continue;
            this.revisionMaxWidth = w;
        }
    }

    private Color darker(Color c) {
        return new Color(Math.max((int)((double)c.getRed() * 0.95), 0), Math.max((int)((double)c.getGreen() * 0.95), 0), Math.max((int)((double)c.getBlue() * 0.95), 0));
    }

    private static String getColorString(Color c) {
        return "#" + SummaryCellRenderer.getHex(c.getRed()) + SummaryCellRenderer.getHex(c.getGreen()) + SummaryCellRenderer.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreeUI tvui;
        if (this.handleWidth < 0 && (tvui = tree.getUI()) instanceof BasicTreeUI) {
            Icon icon = ((BasicTreeUI)tvui).getCollapsedIcon();
            int n = this.handleWidth = icon != null ? icon.getIconWidth() : 0;
        }
        if (value instanceof AbstractSummaryView.LogEntryNode) {
            return this.cr.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (value instanceof AbstractSummaryView.EventNode) {
            return this.rr.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (value instanceof AbstractSummaryView.ActionNode) {
            return this.ar.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        Component r = this.dtcr.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (r instanceof JLabel) {
            ((JLabel)r).setIcon(null);
        }
        return r;
    }

    private String escapeHTML(String text) {
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block4;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public int getItemWidth(JTree tree) {
        int width = tree.getWidth();
        if (width <= 0) {
            width = this.master.getComponent().getWidth();
        }
        return width -= this.handleWidth;
    }

    public static class IssueHyperlink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle[] bounds;
        private final int[] offsetstart;
        private final int[] offsetend;
        private final int[] spanstart;
        private final int[] spanend;
        private final String text;
        private final VCSHyperlinkProvider hp;
        private final File root;
        private final int length;

        private IssueHyperlink(VCSHyperlinkProvider hp, File root, String text, int[] spans, int[] offsets) {
            assert (spans.length == offsets.length);
            this.length = spans.length / 2;
            this.offsetstart = new int[this.length];
            this.offsetend = new int[this.length];
            this.spanstart = new int[this.length];
            this.spanend = new int[this.length];
            this.hp = hp;
            this.root = root;
            this.text = text;
            int i = 0;
            while (i < spans.length) {
                int linkeridx = i / 2;
                this.spanstart[linkeridx] = spans[i];
                this.offsetstart[linkeridx] = offsets[i++];
                this.spanend[linkeridx] = spans[i];
                this.offsetend[linkeridx] = offsets[i++];
                if (this.spanend[linkeridx] >= this.spanstart[linkeridx]) continue;
                AbstractSummaryView.LOG.log(Level.WARNING, "Hyperlink provider {0} returns wrong spans [{1},{2}]", new Object[]{hp.getClass().getName(), this.spanstart, this.spanend});
            }
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle[this.length];
            for (int i = 0; i < this.length; ++i) {
                try {
                    Rectangle mtv = tui.modelToView(textPane, this.offsetstart[i], Position.Bias.Forward);
                    if (mtv == null) {
                        return;
                    }
                    Rectangle startr = mtv.getBounds();
                    mtv = tui.modelToView(textPane, this.offsetend[i], Position.Bias.Backward);
                    if (mtv == null) {
                        return;
                    }
                    Rectangle endr = mtv.getBounds();
                    this.bounds[i] = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
                    continue;
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            for (int i = 0; i < this.spanstart.length; ++i) {
                if (this.bounds == null || this.bounds[i] == null || !this.bounds[i].contains(p)) continue;
                component.setCursor(Cursor.getPredefinedCursor(12));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            for (int i = 0; i < this.spanstart.length; ++i) {
                if (this.bounds == null || this.bounds[i] == null || !this.bounds[i].contains(p)) continue;
                this.hp.onClick(this.root, this.text, this.spanstart[i], this.spanend[i]);
                return true;
            }
            return false;
        }
    }

    public class AuthorHyperlink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final int startoffset;
        private final int endoffset;
        private final VCSKenaiAccessor.KenaiUser kenaiUser;
        private final String author;
        private int handleWidth;

        public AuthorHyperlink(VCSKenaiAccessor.KenaiUser kenaiUser, String author, int startoffset, int endoffset) {
            this.kenaiUser = kenaiUser;
            this.author = author;
            this.startoffset = startoffset;
            this.endoffset = endoffset;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle();
            try {
                Rectangle startr = tui.modelToView(textPane, this.startoffset, Position.Bias.Forward).getBounds();
                Rectangle endr = tui.modelToView(textPane, this.endoffset, Position.Bias.Backward).getBounds();
                if (this.kenaiUser.getIcon() != null) {
                    endr.x += this.kenaiUser.getIcon().getIconWidth();
                }
                this.bounds = new Rectangle(tpBounds.x + startr.x - this.handleWidth, startr.y, endr.x - startr.x, startr.height);
            }
            catch (BadLocationException ex) {
                AbstractSummaryView.LOG.log(Level.OFF, null, ex);
            }
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                this.kenaiUser.startChat();
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(NbBundle.getMessage(VCSHyperlinkSupport.class, (String)"LBL_StartChat", (Object)this.author));
                return true;
            }
            return false;
        }
    }

    private class ExpandMsgHyperlink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final int startoffset;
        private final AbstractSummaryView.LogEntry entry;
        private final String revision;

        public ExpandMsgHyperlink(AbstractSummaryView.LogEntry entry, int startoffset, String revision) {
            this.startoffset = startoffset;
            this.revision = revision;
            this.entry = entry;
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText("Expand Commit Message");
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                this.entry.messageExpanded = true;
                SummaryCellRenderer.this.linkerSupport.remove(this, this.revision);
                Utils.setWaitCursor(true);
                try {
                    SummaryCellRenderer.this.master.fireNodeChanged(this.revision);
                }
                finally {
                    Utils.setWaitCursor(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle();
            try {
                Rectangle mtv = tui.modelToView(textPane, this.startoffset, Position.Bias.Forward);
                if (mtv == null) {
                    return;
                }
                Rectangle startr = mtv.getBounds();
                mtv = tui.modelToView(textPane, this.startoffset + 3, Position.Bias.Backward);
                if (mtv == null) {
                    return;
                }
                Rectangle endr = mtv.getBounds();
                this.bounds = new Rectangle(tpBounds.x + startr.x - SummaryCellRenderer.this.handleWidth, startr.y, endr.x - startr.x, startr.height);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private class ActionHyperlink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle[] bounds;
        private final int[] offsets;
        private final Action[] actions;

        public ActionHyperlink(Action[] actions, int[] offsets) {
            assert (offsets.length / 2 == actions.length);
            this.offsets = offsets;
            this.actions = actions;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle[this.actions.length];
            int aidx = 0;
            for (int i = 0; i < this.bounds.length; ++i) {
                try {
                    Rectangle mtv = tui.modelToView(textPane, this.offsets[aidx++], Position.Bias.Forward);
                    if (mtv == null) {
                        return;
                    }
                    Rectangle startr = mtv.getBounds();
                    if ((mtv = tui.modelToView(textPane, this.offsets[aidx++], Position.Bias.Backward)) == null) {
                        return;
                    }
                    Rectangle endr = mtv.getBounds();
                    this.bounds[i] = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
                    continue;
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            for (int i = 0; i < this.bounds.length; ++i) {
                if (this.bounds == null || this.bounds[i] == null || !this.bounds[i].contains(p)) continue;
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText((String)this.actions[i].getValue("Name"));
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean mouseClicked(Point p) {
            for (int i = 0; i < this.bounds.length; ++i) {
                if (this.bounds == null || this.bounds[i] == null || !this.bounds[i].contains(p)) continue;
                Utils.setWaitCursor(true);
                try {
                    this.actions[i].actionPerformed(new ActionEvent(this.actions[i], 0, ""));
                }
                finally {
                    Utils.setWaitCursor(false);
                }
                return true;
            }
            return false;
        }
    }

    private class ActionRenderer
    implements TreeCellRenderer {
        private String revision;
        private JTextPane textPane = new Pane();

        public ActionRenderer() {
            this.textPane.setBorder(new MatteBorder(3, 0, 0, 0, Color.WHITE));
            this.textPane.setContentType("text/html");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            AbstractSummaryView.LogEntry entry = (AbstractSummaryView.LogEntry)((AbstractSummaryView.LogEntryNode)((AbstractSummaryView.ActionNode)value).getParent()).getUserObject();
            this.textPane.setBackground(tree.getBackground());
            this.revision = entry.getRevision();
            Action[] actions = entry.getActions();
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body><table><tr>");
            for (Action action : actions) {
                sb.append("<td id=\"");
                sb.append(action.getValue("Name"));
                sb.append("\" color=\"");
                sb.append(SummaryCellRenderer.this.linkColor);
                sb.append("\">");
                sb.append(action.getValue("Name"));
                sb.append("</td>");
                sb.append("<td>&nbsp;&nbsp;</td>");
            }
            sb.append("</tr></table></body></html>");
            this.textPane.setText(sb.toString());
            ActionHyperlink l = SummaryCellRenderer.this.linkerSupport.getLinker(ActionHyperlink.class, this.revision);
            if (l == null) {
                int[] offsets = new int[actions.length * 2];
                int idx = 0;
                HTMLDocument document = (HTMLDocument)this.textPane.getDocument();
                for (Action action : actions) {
                    Element e = document.getElement((String)action.getValue("Name"));
                    if (e == null) continue;
                    offsets[idx++] = e.getStartOffset();
                    offsets[idx++] = e.getEndOffset();
                }
                l = new ActionHyperlink(actions, offsets);
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, this.revision);
            }
            this.textPane.setPreferredSize(new Dimension(this.textPane.getPreferredSize().width, SummaryCellRenderer.this.oneLineHeight));
            return this.textPane;
        }

        private class Pane
        extends JTextPane {
            private Pane() {
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                SummaryCellRenderer.this.linkerSupport.computeBounds(ActionRenderer.this.textPane, ActionRenderer.this.revision);
            }
        }
    }

    private class EventRenderer
    extends DefaultTreeCellRenderer {
        private EventRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            AbstractSummaryView.LogEntry.Event revisionEvent = (AbstractSummaryView.LogEntry.Event)((AbstractSummaryView.EventNode)value).getUserObject();
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            String color = SummaryCellRenderer.this.master.getActionColors().get(revisionEvent.getAction());
            if (color != null) {
                sb.append("<font color=\"");
                sb.append(selected ? SummaryCellRenderer.this.selectionForeground : color);
                sb.append("\">");
                sb.append(String.valueOf(revisionEvent.getAction()));
                sb.append("</font>");
            } else {
                sb.append(String.valueOf(revisionEvent.getAction()));
            }
            sb.append("\t");
            String path = revisionEvent.getPath();
            int idx = path.lastIndexOf("/");
            if (idx < 0) {
                sb.append(path);
            } else {
                sb.append("<font color=\"");
                sb.append(selected ? SummaryCellRenderer.this.selectionForeground : SummaryCellRenderer.this.pathColor);
                sb.append("\">");
                sb.append(path.substring(0, idx));
                sb.append("</font>");
                sb.append(path.substring(idx, path.length()));
            }
            sb.append("</body></html>");
            Component renderer = super.getTreeCellRendererComponent(tree, sb.toString(), selected, expanded, leaf, row, hasFocus);
            if (renderer instanceof JLabel) {
                JLabel l = (JLabel)renderer;
                l.setToolTipText(sb.toString());
                l.setIcon(null);
            }
            return renderer;
        }
    }

    private class RevisionRenderer
    implements TreeCellRenderer {
        private String revision;
        private JTextPane textPane = new Pane();
        private Collection<VCSHyperlinkProvider> hpInstances;

        public RevisionRenderer() {
            this.textPane.setBorder(new MatteBorder(3, 0, 0, 0, Color.WHITE));
            this.textPane.setContentType("text/html");
            SummaryCellRenderer.this.oneLineHeight = this.textPane.getPreferredSize().height + 3;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            int width;
            IssueHyperlink l;
            AuthorHyperlink l2;
            Color backgroundColor;
            String background;
            String foreground;
            AbstractSummaryView.LogEntry entry = (AbstractSummaryView.LogEntry)((AbstractSummaryView.LogEntryNode)value).getUserObject();
            if (selected) {
                foreground = SummaryCellRenderer.this.selectionForeground;
                background = SummaryCellRenderer.this.selectionBackground;
                backgroundColor = SummaryCellRenderer.this.selectionBackgroundColor;
            } else {
                foreground = SummaryCellRenderer.this.normalForeground;
                background = SummaryCellRenderer.this.normalBackground;
                backgroundColor = SummaryCellRenderer.this.normalBackgroundColor;
            }
            this.textPane.setBackground(backgroundColor);
            this.revision = entry.getRevision();
            String author = entry.getAuthor() != null ? entry.getAuthor() : "";
            String date = entry.getDate();
            String messageValue = SummaryCellRenderer.this.escapeHTML(entry.getMessage());
            int i = 0;
            int nlc = -1;
            while (i != -1) {
                i = messageValue.indexOf(10, i + 1);
                ++nlc;
            }
            messageValue = nlc == 0 || entry.messageExpanded ? messageValue.replace("\n", "<br>") : messageValue.substring(0, messageValue.indexOf("\n"));
            int[] issuespans = null;
            VCSHyperlinkProvider hyperlinkProvider = null;
            String issuesMsgValue = null;
            for (VCSHyperlinkProvider hp : this.getHyperlinkProviders()) {
                issuespans = hp.getSpans(entry.getMessage());
                if (issuespans == null) continue;
                if (issuespans.length % 2 != 0) {
                    AbstractSummaryView.LOG.log(Level.WARNING, "Hyperlink provider {0} returns wrong spans", hp.getClass().getName());
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                int pos = 0;
                if (issuespans.length <= 0) continue;
                issuesMsgValue = messageValue;
                hyperlinkProvider = hp;
                boolean linked = true;
                i = 0;
                while (i < issuespans.length) {
                    int issueidx = i / 2;
                    int start = issuespans[i++];
                    int end = issuespans[i++];
                    if (pos >= messageValue.length() || start >= messageValue.length()) {
                        linked = false;
                        break;
                    }
                    sb.append(messageValue.substring(pos, start));
                    sb.append("<font color=\"");
                    sb.append(selected ? SummaryCellRenderer.this.selectionForeground : SummaryCellRenderer.this.linkColor);
                    sb.append("\" id=\"issue");
                    sb.append(issueidx);
                    sb.append("\">");
                    if (start >= messageValue.length() || end > messageValue.length()) {
                        linked = false;
                        break;
                    }
                    sb.append(messageValue.substring(start, end));
                    sb.append("</font>");
                    pos = end;
                }
                if (!linked) continue;
                sb.append(messageValue.substring(pos));
                messageValue = sb.toString();
            }
            if (nlc > 0 && !entry.messageExpanded) {
                StringBuilder sb = new StringBuilder();
                sb.append(messageValue);
                sb.append(" <font color=\"");
                sb.append(selected ? SummaryCellRenderer.this.selectionForeground : SummaryCellRenderer.this.linkColor);
                sb.append("\" id=\"expandmsg\">...</font>");
                messageValue = sb.toString();
            }
            VCSKenaiAccessor.KenaiUser kenaiUser = this.getKenaiUser(author);
            this.textPane.setText(this.formatValue(background, foreground, selected, kenaiUser, author, messageValue, date));
            HTMLDocument document = (HTMLDocument)this.textPane.getDocument();
            this.hiliteSearch(document, selected);
            Element e = document.getElement("author");
            if (e != null && kenaiUser != null && (l2 = SummaryCellRenderer.this.linkerSupport.getLinker(AuthorHyperlink.class, this.revision)) == null) {
                l2 = new AuthorHyperlink(kenaiUser, author, e.getStartOffset(), e.getEndOffset());
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l2, this.revision);
            }
            if ((e = document.getElement("expandmsg")) != null && (l3 = SummaryCellRenderer.this.linkerSupport.getLinker(ExpandMsgHyperlink.class, this.revision)) == null) {
                ExpandMsgHyperlink l3 = new ExpandMsgHyperlink(entry, e.getStartOffset(), this.revision);
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l3, this.revision);
            }
            if (issuespans != null && issuespans.length % 2 == 0 && (l = SummaryCellRenderer.this.linkerSupport.getLinker(IssueHyperlink.class, this.revision)) == null) {
                i = 0;
                int[] offsets = new int[issuespans.length];
                while ((e = document.getElement("issue" + i / 2)) != null) {
                    offsets[i++] = e.getStartOffset();
                    offsets[i++] = e.getEndOffset();
                }
                l = new IssueHyperlink(hyperlinkProvider, SummaryCellRenderer.this.master.getRoot(), issuesMsgValue, issuespans, offsets);
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, this.revision);
            }
            if ((width = SummaryCellRenderer.this.getItemWidth(tree)) > 0) {
                int ph;
                if (nlc > 0) {
                    int lines = entry.messageExpanded ? nlc + 1 : 1;
                    ph = SummaryCellRenderer.this.oneLineHeight * lines;
                } else {
                    ph = SummaryCellRenderer.this.oneLineHeight;
                }
                this.textPane.setPreferredSize(new Dimension(width, ph));
            }
            return this.textPane;
        }

        public String formatValue(String background, String foreground, boolean selected, VCSKenaiAccessor.KenaiUser kenaiUser, String author, String messageValue, String date) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body><table width=\"100%\" height=\"100%\" border=\"0\"><tr>");
            sb.append("<td bgcolor=\"");
            sb.append("<td bgcolor=\"");
            sb.append(background);
            sb.append("\" valign=\"top\" width=\"");
            sb.append(SummaryCellRenderer.this.revisionMaxWidth);
            sb.append("\" border=\"0\"><font color=\"");
            sb.append(foreground);
            sb.append("\">");
            sb.append(this.revision);
            sb.append("</font></td><td bgcolor=\"");
            sb.append(background);
            sb.append("\" valign=\"top\" width=\"");
            sb.append(SummaryCellRenderer.this.authorMaxWidth);
            sb.append("\" border=\"0\" ><center><font color=\"");
            sb.append(selected ? SummaryCellRenderer.this.selectionForeground : (kenaiUser != null ? "#0000FF" : SummaryCellRenderer.this.authorColor));
            sb.append("\" id=\"author\">(");
            sb.append(author);
            sb.append(")</font></center></td><td bgcolor=\"");
            sb.append(background);
            sb.append("\" valign=\"top\" border=\"0\"><font color=\"");
            sb.append(foreground);
            sb.append("\">");
            sb.append(messageValue);
            sb.append("</font></td><td bgcolor=\"");
            sb.append(background);
            sb.append("\" valign=\"top\" width=\"");
            sb.append(SummaryCellRenderer.this.dateMaxWidth);
            sb.append("\" border=\"0\"><font color=\"");
            sb.append(selected ? SummaryCellRenderer.this.selectionForeground : SummaryCellRenderer.this.dateColor);
            sb.append("\">");
            sb.append(date);
            sb.append("</font></td></tr></table></body></html>");
            return sb.toString();
        }

        public VCSKenaiAccessor.KenaiUser getKenaiUser(String author) {
            VCSKenaiAccessor.KenaiUser kenaiUser = null;
            if (SummaryCellRenderer.this.kenaiUsersMap != null && author != null && !author.equals("")) {
                kenaiUser = (VCSKenaiAccessor.KenaiUser)SummaryCellRenderer.this.kenaiUsersMap.get(author);
            }
            return kenaiUser;
        }

        public void hiliteSearch(HTMLDocument document, boolean selected) {
            if (SummaryCellRenderer.this.hiliteMessage != null && !selected) {
                String message = null;
                try {
                    message = document.getText(0, document.getLength());
                }
                catch (BadLocationException ex) {
                    AbstractSummaryView.LOG.log(Level.OFF, null, ex);
                    return;
                }
                int idx = message.indexOf(SummaryCellRenderer.this.hiliteMessage);
                if (idx != -1) {
                    document.setCharacterAttributes(idx, SummaryCellRenderer.this.hiliteMessage.length(), SummaryCellRenderer.this.searchHiliteAttrs, true);
                }
            }
        }

        public Collection<VCSHyperlinkProvider> getHyperlinkProviders() {
            if (this.hpInstances == null) {
                Lookup.Result hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
                this.hpInstances = hpResult.allInstances();
            }
            return this.hpInstances;
        }

        private class Pane
        extends JTextPane {
            private Pane() {
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                SummaryCellRenderer.this.linkerSupport.computeBounds(RevisionRenderer.this.textPane, RevisionRenderer.this.revision);
            }
        }
    }
}

