/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.CheckNodeModel;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.DnDNodeModel;
import org.netbeans.spi.viewmodel.DnDNodeModelFilter;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.ReorderableTreeModel;
import org.netbeans.spi.viewmodel.ReorderableTreeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;

public class ViewModelListener
extends DebuggerManagerAdapter {
    private static final Class[] TREE_MODELS = new Class[]{TreeModel.class, ReorderableTreeModel.class};
    private static final Class[] TREE_MODEL_FILTERS = new Class[]{TreeModelFilter.class, ReorderableTreeModelFilter.class};
    private static final Class[] NODE_MODELS = new Class[]{NodeModel.class, CheckNodeModel.class, DnDNodeModel.class, ExtendedNodeModel.class};
    private static final Class[] NODE_MODEL_FILTERS = new Class[]{NodeModelFilter.class, CheckNodeModelFilter.class, DnDNodeModelFilter.class, ExtendedNodeModelFilter.class};
    private String viewType;
    private JComponent view;
    private JComponent buttonsPane;
    private List models = new ArrayList(11);
    private List hyperModels;
    private List<? extends SessionProvider> sessionProviders;
    private Session currentSession;
    private List[] treeModels = new List[TREE_MODELS.length];
    private List[] treeModelFilters = new List[TREE_MODEL_FILTERS.length];
    private List treeExpansionModels;
    private List treeExpansionModelFilters;
    private List[] nodeModels = new List[NODE_MODELS.length];
    private List[] nodeModelFilters = new List[NODE_MODEL_FILTERS.length];
    private List tableModels;
    private List tableModelFilters;
    private List nodeActionsProviders;
    private List nodeActionsProviderFilters;
    private List columnModels;
    private List mm;
    private List asynchModelFilters;
    private List<AbstractButton> buttons;
    private JTabbedPane tabbedPane;
    private Image viewIcon;
    private ObjectVariable variable;
    private SessionProvider providerToDisplay;
    private List<ViewModelListener> subListeners = new ArrayList<ViewModelListener>();
    private ToolTipSupport toolTipSupport;
    private String propertiesHelpID = null;

    ViewModelListener(String viewType, JComponent view, JComponent buttonsPane, String propertiesHelpID, Image viewIcon, ObjectVariable variable) {
        this.viewType = viewType;
        this.view = view;
        this.buttonsPane = buttonsPane;
        this.propertiesHelpID = propertiesHelpID;
        this.viewIcon = viewIcon;
        this.variable = variable;
        this.setUp();
    }

    void setUp() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.updateModel();
    }

    void setToolTipSupport(ToolTipSupport toolTipSupport) {
        this.toolTipSupport = toolTipSupport;
    }

    synchronized void destroy() {
        JComponent tree;
        boolean haveModels;
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        boolean haveTreeModels = false;
        for (List tms : this.treeModels) {
            if (tms.size() <= 0) continue;
            haveTreeModels = true;
            break;
        }
        boolean haveNodeModels = false;
        for (List nms : this.nodeModels) {
            if (nms.size() <= 0) continue;
            haveNodeModels = true;
            break;
        }
        boolean bl = haveModels = haveTreeModels || haveNodeModels || this.tableModels != null && this.tableModels.size() > 0;
        if (haveModels && this.view.getComponentCount() > 0 && !((tree = (JComponent)this.view.getComponent(0)) instanceof JTabbedPane)) {
            Models.setModelsToView((JComponent)tree, null);
        }
        this.models.clear();
        this.treeModels = new List[TREE_MODELS.length];
        this.treeModelFilters = new List[TREE_MODEL_FILTERS.length];
        this.treeExpansionModels = null;
        this.treeExpansionModelFilters = null;
        this.nodeModels = new List[NODE_MODELS.length];
        this.nodeModelFilters = new List[NODE_MODEL_FILTERS.length];
        this.tableModels = null;
        this.tableModelFilters = null;
        this.nodeActionsProviders = null;
        this.nodeActionsProviderFilters = null;
        this.columnModels = null;
        this.mm = null;
        this.asynchModelFilters = null;
        this.sessionProviders = null;
        this.currentSession = null;
        this.providerToDisplay = null;
        this.buttonsPane.removeAll();
        this.buttons = null;
        this.view.removeAll();
        for (ViewModelListener l : this.subListeners) {
            l.destroy();
        }
        this.subListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getNewValue() != null) {
            ViewModelListener viewModelListener = this;
            synchronized (viewModelListener) {
                this.providerToDisplay = null;
            }
        }
        this.updateModel();
    }

    private static void getMultiModels(ContextProvider cp, String viewPath, List[] models, Class[] classTypes) {
        for (int i = 0; i < classTypes.length; ++i) {
            models[i] = cp.lookup(viewPath, classTypes[i]);
        }
    }

    private synchronized void updateModel() {
        String viewPath;
        DebuggerManager cp;
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        this.sessionProviders = e == null ? dm.lookup(this.viewType, SessionProvider.class) : DebuggerManager.join((ContextProvider)e, (ContextProvider)dm).lookup(this.viewType, SessionProvider.class);
        if (!this.sessionProviders.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (e == null && this.providerToDisplay == null && this.sessionProviders.size() > 0) {
            this.providerToDisplay = this.sessionProviders.get(0);
        }
        if (this.providerToDisplay != null) {
            e = null;
            cp = dm;
            viewPath = this.viewType + "/" + this.providerToDisplay.getTypeID();
        } else {
            cp = e != null ? DebuggerManager.join((ContextProvider)e, (ContextProvider)dm) : dm;
            viewPath = this.viewType;
        }
        this.currentSession = dm.getCurrentSession();
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, this.treeModels, TREE_MODELS);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, this.treeModelFilters, TREE_MODEL_FILTERS);
        this.treeExpansionModels = cp.lookup(viewPath, TreeExpansionModel.class);
        this.treeExpansionModelFilters = cp.lookup(this.viewType, TreeExpansionModelFilter.class);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, this.nodeModels, NODE_MODELS);
        ViewModelListener.getMultiModels((ContextProvider)cp, viewPath, this.nodeModelFilters, NODE_MODEL_FILTERS);
        this.tableModels = cp.lookup(viewPath, TableModel.class);
        this.tableModelFilters = cp.lookup(viewPath, TableModelFilter.class);
        this.nodeActionsProviders = cp.lookup(viewPath, NodeActionsProvider.class);
        this.nodeActionsProviderFilters = cp.lookup(viewPath, NodeActionsProviderFilter.class);
        this.columnModels = cp.lookup(viewPath, ColumnModel.class);
        this.mm = cp.lookup(viewPath, Model.class);
        this.asynchModelFilters = cp.lookup(viewPath, AsynchronousModelFilter.class);
        String searchPath = viewPath;
        while (this.asynchModelFilters.isEmpty() && searchPath != null) {
            int i = searchPath.lastIndexOf(47);
            searchPath = i > 0 ? searchPath.substring(0, i) : null;
            this.asynchModelFilters = cp.lookup(searchPath, AsynchronousModelFilter.class);
        }
        this.hyperModels = null;
        List bList = cp.lookup(viewPath, AbstractButton.class);
        this.buttons = new ArrayList<AbstractButton>();
        ArrayList<AbstractButton> tempList = new ArrayList<AbstractButton>();
        for (AbstractButton b : bList) {
            if (b instanceof JToggleButton) {
                this.buttons.add(b);
                continue;
            }
            tempList.add(b);
        }
        this.buttons.addAll(tempList);
        this.tabbedPane = (JTabbedPane)cp.lookupFirst(viewPath, JTabbedPane.class);
        this.refreshModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List joinLists(List[] modelLists) {
        ArrayList models = new ArrayList();
        List[] arr$ = modelLists;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            List l;
            List list = l = arr$[i$];
            synchronized (list) {
                for (Object o : l) {
                    if (models.contains(o)) continue;
                    models.add(o);
                }
                continue;
            }
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshModel() {
        this.models.clear();
        if (this.treeModels == null) {
            return;
        }
        Object object = this.treeModels;
        synchronized (this.treeModels) {
            this.models.add(ViewModelListener.joinLists(this.treeModels));
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            object = this.treeModelFilters;
            synchronized (this.treeModelFilters) {
                this.models.add(ViewModelListener.joinLists(this.treeModelFilters));
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                object = this.treeExpansionModels;
                synchronized (object) {
                    this.models.add(new ArrayList(this.treeExpansionModels));
                }
                object = this.nodeModels;
                synchronized (this.nodeModels) {
                    this.models.add(ViewModelListener.joinLists(this.nodeModels));
                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                    object = this.nodeModelFilters;
                    synchronized (this.nodeModelFilters) {
                        boolean haveModels;
                        JPanel buttonsSubPane;
                        this.models.add(ViewModelListener.joinLists(this.nodeModelFilters));
                        // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                        object = this.tableModels;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.tableModels));
                        }
                        object = this.tableModelFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.tableModelFilters));
                        }
                        object = this.nodeActionsProviders;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.nodeActionsProviders));
                        }
                        object = this.nodeActionsProviderFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.nodeActionsProviderFilters));
                        }
                        object = this.columnModels;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.columnModels));
                        }
                        object = this.mm;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.mm));
                        }
                        object = this.treeExpansionModelFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.treeExpansionModelFilters));
                        }
                        object = this.asynchModelFilters;
                        synchronized (object) {
                            this.models.add(new ArrayList(this.asynchModelFilters));
                        }
                        List<AbstractButton> list = this.buttons;
                        synchronized (list) {
                            this.buttonsPane.removeAll();
                            if (this.buttons.size() == 0) {
                                this.buttonsPane.setVisible(false);
                                buttonsSubPane = null;
                            } else {
                                this.buttonsPane.setVisible(true);
                                int i = 0;
                                if (this.tabbedPane != null) {
                                    buttonsSubPane = new JPanel();
                                    buttonsSubPane.setLayout(new GridBagLayout());
                                    GridBagConstraints c = new GridBagConstraints(0, i, 1, 1, 0.0, 1.0, 11, 3, new Insets(5, 0, 5, 0), 0, 0);
                                    this.buttonsPane.add((Component)buttonsSubPane, c);
                                    ++i;
                                } else {
                                    buttonsSubPane = null;
                                    for (AbstractButton b : this.buttons) {
                                        GridBagConstraints c = new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
                                        this.buttonsPane.add((Component)b, c);
                                        ++i;
                                    }
                                }
                            }
                        }
                        boolean haveTreeModels = false;
                        for (List tms : this.treeModels) {
                            if (tms.size() <= 0) continue;
                            haveTreeModels = true;
                            break;
                        }
                        boolean haveNodeModels = false;
                        for (List nms : this.nodeModels) {
                            if (nms.size() <= 0) continue;
                            haveNodeModels = true;
                            break;
                        }
                        boolean bl = haveModels = haveTreeModels || haveNodeModels || this.tableModels.size() > 0 || this.hyperModels != null;
                        final Models.CompoundModel newModel = this.hyperModels != null ? Models.createCompoundModel((List)this.hyperModels, (String)this.propertiesHelpID) : (haveModels ? Models.createCompoundModel((List)this.models, (String)this.propertiesHelpID) : null);
                        if (newModel != null) {
                            newModel.nodeExpanded((Object)this.variable);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ViewModelListener.this.view.getComponentCount() > 0) {
                                    if (ViewModelListener.this.tabbedPane == null && ViewModelListener.this.view.getComponent(0) instanceof JTabbedPane) {
                                        ViewModelListener.this.view.removeAll();
                                    } else if (ViewModelListener.this.tabbedPane != null) {
                                        ViewModelListener.this.view.removeAll();
                                    }
                                }
                                if (ViewModelListener.this.view.getComponentCount() == 0) {
                                    if (haveModels) {
                                        ViewModelListener.this.view.add(Models.createView((Models.CompoundModel)newModel));
                                        ViewModelListener.this.view.revalidate();
                                        ViewModelListener.this.view.repaint();
                                    } else if (ViewModelListener.this.tabbedPane != null) {
                                        int n = ViewModelListener.this.tabbedPane.getTabCount();
                                        for (int i = 0; i < n; ++i) {
                                            Component c = ViewModelListener.this.tabbedPane.getComponentAt(i);
                                            if (c instanceof JPanel) {
                                                c = (Component)((JPanel)c).getClientProperty(JLabel.class.getName());
                                            }
                                            if (!(c instanceof JLabel)) continue;
                                            String id = ((JLabel)c).getText();
                                            if (ViewModelListener.this.providerToDisplay != null) {
                                                id = ViewModelListener.this.providerToDisplay.getTypeID() + "/" + id;
                                            }
                                            JPanel contentComponent = new JPanel(new BorderLayout());
                                            ViewModelListener.this.subListeners.add(new ViewModelListener(ViewModelListener.this.viewType + "/" + id, contentComponent, buttonsSubPane, ViewModelListener.this.propertiesHelpID, ViewModelListener.this.viewIcon, ViewModelListener.this.variable));
                                            ViewModelListener.this.tabbedPane.setComponentAt(i, contentComponent);
                                            contentComponent.putClientProperty(JLabel.class.getName(), c);
                                        }
                                        ViewModelListener.this.view.add(ViewModelListener.this.tabbedPane);
                                        ViewModelListener.this.view.revalidate();
                                        ViewModelListener.this.view.repaint();
                                    }
                                } else if (ViewModelListener.this.tabbedPane == null) {
                                    if (!haveModels) {
                                        ViewModelListener.this.view.removeAll();
                                        ViewModelListener.this.view.revalidate();
                                        ViewModelListener.this.view.repaint();
                                        if (ViewModelListener.this.toolTipSupport != null) {
                                            ViewModelListener.this.toolTipSupport.setToolTipVisible(false);
                                        }
                                    } else {
                                        JComponent tree = (JComponent)ViewModelListener.this.view.getComponent(0);
                                        Models.setModelsToView((JComponent)tree, (Models.CompoundModel)newModel);
                                    }
                                }
                            }
                        });
                        return;
                    }
                }
            }
        }
    }
}

