/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.util.WeakListeners;

public class StepIntoActionProvider
extends ActionsProviderSupport {
    Listener listener = new Listener();

    public StepIntoActionProvider() {
        MainProjectManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)MainProjectManager.getDefault()));
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)this.listener, (Object)DebuggerManager.getDebuggerManager()));
        this.setEnabled(ActionsManager.ACTION_STEP_INTO, this.shouldBeEnabled());
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_STEP_INTO);
    }

    public void doAction(Object action) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        StepIntoActionProvider.this.invokeAction();
                    }
                });
            }
            catch (InterruptedException iex) {
            }
            catch (InvocationTargetException itex) {
                ErrorManager.getDefault().notify((Throwable)itex);
            }
        } else {
            this.invokeAction();
        }
    }

    public void postAction(Object action, Runnable actionPerformedNotifier) {
        this.invokeAction();
        actionPerformedNotifier.run();
    }

    private void invokeAction() {
        Project p = MainProjectManager.getDefault().getMainProject();
        ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (Arrays.asList(actionProvider.getSupportedActions()).contains("debug.stepinto") && actionProvider.isActionEnabled("debug.stepinto", p.getLookup())) {
            actionProvider.invokeAction("debug.stepinto", p.getLookup());
        } else {
            Toolkit.getDefaultToolkit().beep();
            this.setEnabled(ActionsManager.ACTION_STEP_INTO, false);
        }
    }

    private boolean shouldBeEnabled() {
        int i;
        Project p = MainProjectManager.getDefault().getMainProject();
        if (p == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] sa = actionProvider.getSupportedActions();
        int k = sa.length;
        for (i = 0; i < k && !"debug.stepinto".equals(sa[i]); ++i) {
        }
        if (i == k) {
            return false;
        }
        if (DebuggerManager.getDebuggerManager().getDebuggerEngines().length > 0) {
            return false;
        }
        return actionProvider.isActionEnabled("debug.stepinto", p.getLookup());
    }

    private class Listener
    implements PropertyChangeListener,
    DebuggerManagerListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() instanceof MainProjectManager) {
                this.doSetEnabled();
            }
        }

        public void sessionRemoved(Session session) {
        }

        public void breakpointAdded(Breakpoint breakpoint) {
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        public void initWatches() {
        }

        public void sessionAdded(Session session) {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void engineAdded(DebuggerEngine engine) {
            this.doSetEnabled();
        }

        public void engineRemoved(DebuggerEngine engine) {
            this.doSetEnabled();
        }

        private void doSetEnabled() {
            StepIntoActionProvider.this.setEnabled(ActionsManager.ACTION_STEP_INTO, StepIntoActionProvider.this.shouldBeEnabled());
        }
    }
}

