/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;

public class SourceLevelQuery {
    private static final Logger LOGGER = Logger.getLogger(SourceLevelQuery.class.getName());
    private static final Pattern SOURCE_LEVEL = Pattern.compile("\\d+\\.\\d+");
    private static final Lookup.Result<? extends SourceLevelQueryImplementation> implementations = Lookup.getDefault().lookupResult(SourceLevelQueryImplementation.class);
    private static final Lookup.Result<? extends SourceLevelQueryImplementation2> implementations2 = Lookup.getDefault().lookupResult(SourceLevelQueryImplementation2.class);
    private static final Result EMPTY_RESULT = new Result();

    private SourceLevelQuery() {
    }

    public static String getSourceLevel(FileObject javaFile) {
        for (Object sqi : implementations2.allInstances()) {
            String s;
            SourceLevelQueryImplementation2.Result result = sqi.getSourceLevel(javaFile);
            if (result == null || (s = result.getSourceLevel()) == null) continue;
            if (!SOURCE_LEVEL.matcher(s).matches()) {
                LOGGER.log(Level.WARNING, "#83994: Ignoring bogus source level {0} for {1} from {2}", new Object[]{s, javaFile, sqi});
                continue;
            }
            LOGGER.log(Level.FINE, "Found source level {0} for {1} from {2}", new Object[]{s, javaFile, sqi});
            return s;
        }
        for (Object sqi : implementations.allInstances()) {
            String s = sqi.getSourceLevel(javaFile);
            if (s == null) continue;
            if (!SOURCE_LEVEL.matcher(s).matches()) {
                LOGGER.log(Level.WARNING, "#83994: Ignoring bogus source level {0} for {1} from {2}", new Object[]{s, javaFile, sqi});
                continue;
            }
            LOGGER.log(Level.FINE, "Found source level {0} for {1} from {2}", new Object[]{s, javaFile, sqi});
            return s;
        }
        LOGGER.log(Level.FINE, "No source level found for {0}", javaFile);
        return null;
    }

    @NonNull
    public static Result getSourceLevel2(@NonNull FileObject javaFile) {
        for (Object sqi : implementations2.allInstances()) {
            SourceLevelQueryImplementation2.Result result = sqi.getSourceLevel(javaFile);
            if (result == null) continue;
            LOGGER.log(Level.FINE, "Found source level {0} for {1} from {2}", new Object[]{result, javaFile, sqi});
            return new Result(result);
        }
        LOGGER.log(Level.FINE, "No source level found for {0}", javaFile);
        for (Object sqi : implementations.allInstances()) {
            String s = sqi.getSourceLevel(javaFile);
            if (s == null) continue;
            if (!SOURCE_LEVEL.matcher(s).matches()) {
                LOGGER.log(Level.WARNING, "#83994: Ignoring bogus source level {0} for {1} from {2}", new Object[]{s, javaFile, sqi});
                continue;
            }
            LOGGER.log(Level.FINE, "Found source level {0} for {1} from {2}", new Object[]{s, javaFile, sqi});
            return new Result(s);
        }
        return EMPTY_RESULT;
    }

    public static final class Result {
        private final Union2<SourceLevelQueryImplementation2.Result, String> delegate;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private ChangeListener spiListener;

        private Result(@NonNull SourceLevelQueryImplementation2.Result delegate) {
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            this.delegate = Union2.createFirst((Object)delegate);
        }

        private Result(@NonNull String sourceLevel) {
            Parameters.notNull((CharSequence)"sourceLevel", (Object)sourceLevel);
            this.delegate = Union2.createSecond((Object)sourceLevel);
        }

        private Result() {
            this.delegate = null;
        }

        @CheckForNull
        public String getSourceLevel() {
            return this.delegate == null ? null : (this.delegate.hasFirst() ? ((SourceLevelQueryImplementation2.Result)this.delegate.first()).getSourceLevel() : (String)this.delegate.second());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            SourceLevelQueryImplementation2.Result _delegate = this.getDelegate();
            if (_delegate == null) {
                throw new UnsupportedOperationException("Listening is not supported");
            }
            this.cs.addChangeListener(listener);
            Result result = this;
            synchronized (result) {
                if (this.spiListener == null) {
                    this.spiListener = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            Result.this.cs.fireChange();
                        }
                    };
                    _delegate.addChangeListener(WeakListeners.change((ChangeListener)this.spiListener, (Object)_delegate));
                }
            }
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            SourceLevelQueryImplementation2.Result _delegate = this.getDelegate();
            if (_delegate == null) {
                throw new UnsupportedOperationException("Listening is not supported");
            }
            this.cs.removeChangeListener(listener);
        }

        public boolean supportsChanges() {
            return this.getDelegate() != null;
        }

        private SourceLevelQueryImplementation2.Result getDelegate() {
            return this.delegate != null && this.delegate.hasFirst() ? (SourceLevelQueryImplementation2.Result)this.delegate.first() : null;
        }
    }
}

