/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.MakeProjectFileProviderFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.CharSequences;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public class Folder
implements FileChangeListener,
ChangeListener {
    public static final String DEFAULT_FOLDER_NAME = "f";
    public static final String DEFAULT_FOLDER_DISPLAY_NAME = Folder.getString("NewFolderName");
    public static final String DEFAULT_TEST_FOLDER_DISPLAY_NAME = Folder.getString("NewTestFolderName");
    private final MakeConfigurationDescriptor configurationDescriptor;
    private volatile boolean listenerAttached;
    private final String name;
    private String displayName;
    private final Folder parent;
    private final ArrayList<Object> items;
    private final ReentrantReadWriteLock itemsLock = new ReentrantReadWriteLock();
    private HashMap<String, HashMap<Configuration, DeletedConfiguration>> deletedItems;
    private final Set<ChangeListener> changeListenerList = new WeakSet(1);
    private final boolean projectFiles;
    private String id = null;
    private String root;
    private static final Logger log = Logger.getLogger("makeproject.folder");
    private static boolean checkedLogging = Folder.checkLogging();
    private final Kind kind;

    public Folder(MakeConfigurationDescriptor configurationDescriptor, Folder parent, String name, String displayName, boolean projectFiles, Kind kind) {
        this.configurationDescriptor = configurationDescriptor;
        this.parent = parent;
        this.name = name;
        this.displayName = displayName;
        this.projectFiles = projectFiles;
        if (kind == null) {
            kind = parent.isDiskFolder() ? Kind.SOURCE_DISK_FOLDER : Kind.SOURCE_LOGICAL_FOLDER;
        }
        this.kind = kind;
        this.items = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack() {
        this.itemsLock.writeLock().lock();
        try {
            this.items.trimToSize();
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    public void refreshDiskFolder(boolean setModified) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "----------refreshDiskFolder {0}", this.getPath());
        }
        String rootPath = this.getRootPath();
        FileObject folderFile = this.getThisFolder();
        if (folderFile == null || !folderFile.isValid() || !folderFile.isFolder() || !VisibilityQuery.getDefault().isVisible(folderFile) || this.getConfigurationDescriptor().getFolderVisibilityQuery().isVisible(folderFile)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------removing folder {0} in {1}", new Object[]{this.getPath(), this.getParent().getPath()});
            }
            this.getParent().removeFolder(this, setModified);
            return;
        }
        for (Item item : this.getItemsAsArray()) {
            FileObject fo = item.getFileObject();
            if (fo == null) {
                log.log(Level.INFO, "Null file object for {0}", item.getAbsolutePath());
                continue;
            }
            if (fo.isValid() && fo.isData() && VisibilityQuery.getDefault().isVisible(fo) && CndFileVisibilityQuery.getDefault().isVisible(fo)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------removing item {0} in {1}", new Object[]{item.getPath(), this.getPath()});
            }
            this.removeItem(item, setModified);
        }
        FileObject[] files = folderFile.getChildren();
        if (files == null) {
            return;
        }
        ArrayList<FileObject> fileList = new ArrayList<FileObject>();
        ArrayList<CharSequence> otherFileList = new ArrayList<CharSequence>();
        for (int i = 0; i < files.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(files[i])) continue;
            if (files[i].isFolder()) {
                if (this.getConfigurationDescriptor().getFolderVisibilityQuery().isVisible(files[i])) {
                    continue;
                }
            } else if (!CndFileVisibilityQuery.getDefault().isVisible(files[i])) {
                otherFileList.add(CharSequences.create((CharSequence)files[i].getNameExt()));
                continue;
            }
            fileList.add(files[i]);
        }
        if (otherFileList.size() > 0) {
            otherFileList.trimToSize();
        }
        MakeProjectFileProviderFactory.updateSearchBase(this.configurationDescriptor.getProject(), this, otherFileList);
        for (FileObject file : fileList) {
            if (file.isFolder()) {
                block22: {
                    try {
                        String canPath = RemoteFileUtil.getCanonicalPath((FileObject)file);
                        String absPath = RemoteFileUtil.getAbsolutePath((FileObject)file);
                        if (!absPath.equals(canPath) && absPath.startsWith(canPath)) {
                            log.log(Level.INFO, "Ignore recursive link {0} in folder {1}", new Object[]{absPath, folderFile.getPath()});
                        }
                        break block22;
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, ex.getMessage(), ex);
                    }
                    continue;
                }
                if (this.findFolderByName(file.getNameExt()) != null) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "------------adding folder {0} in {1}", new Object[]{file.getPath(), this.getPath()});
                }
                this.getConfigurationDescriptor().addFilesFromDir(this, file, true, setModified, null);
                continue;
            }
            String path = rootPath + '/' + file.getNameExt();
            if (path.startsWith("./")) {
                path = path.substring(2);
            }
            if (this.findItemByPath(path) != null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------adding item {0} in {1}", new Object[]{file.getPath(), this.getPath()});
            }
            this.addItem(Item.createInFileSystem(this.configurationDescriptor.getBaseDirFileSystem(), path), true, setModified);
        }
        List<Folder> subFolders = this.getFolders();
        for (Folder f : subFolders) {
            f.refreshDiskFolder(setModified);
        }
    }

    public void attachListeners() {
        File folderFile;
        if (this.configurationDescriptor == null) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("null configurationDescriptor for " + this.name));
            return;
        }
        String rootPath = this.getRootPath();
        if (this.listenerAttached) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("listeners already attached to " + rootPath));
            return;
        }
        FileSystem fileSystem = this.configurationDescriptor.getBaseDirFileSystem();
        String absRootPath = CndPathUtilitities.toAbsolutePath((FileObject)this.configurationDescriptor.getBaseDirFileObject(), (String)rootPath);
        if (!(!CndFileUtils.isLocalFileSystem((FileSystem)fileSystem) || (folderFile = new File(absRootPath)).exists() && folderFile.isDirectory())) {
            return;
        }
        if (this.isDiskFolder() && this.getRoot() != null) {
            block9: {
                VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
                CndFileVisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
                this.getConfigurationDescriptor().getFolderVisibilityQuery().addChangeListener((ChangeListener)this);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "-----------attachFilterListener {0}", this.getPath());
                }
                try {
                    FileSystemProvider.addRecursiveListener((FileChangeListener)this, (FileSystem)fileSystem, (String)absRootPath);
                    this.listenerAttached = true;
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "-----------attachFileChangeListener {0}", this.getPath());
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!log.isLoggable(Level.FINER)) break block9;
                    log.log(Level.FINER, "-----------attachFileChangeListener duplicate error{0}", this.getPath());
                }
            }
            return;
        }
        List<Folder> subFolders = this.getFolders();
        for (Folder f : subFolders) {
            f.attachListeners();
        }
    }

    public void detachListener() {
        if (!this.listenerAttached) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "-----------detachFileChangeListener {0}", this.getPath());
        }
        if (this.configurationDescriptor == null) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("null configurationDescriptor for " + this.name));
            return;
        }
        String rootPath = this.getRootPath();
        FileSystem fileSystem = this.configurationDescriptor.getBaseDirFileSystem();
        String absRootPath = CndPathUtilitities.toAbsolutePath((FileObject)this.configurationDescriptor.getBaseDirFileObject(), (String)rootPath);
        FileSystemProvider.removeRecursiveListener((FileChangeListener)this, (FileSystem)fileSystem, (String)absRootPath);
        this.listenerAttached = false;
        if (this.isDiskFolder() && this.getRoot() != null) {
            VisibilityQuery.getDefault().removeChangeListener((ChangeListener)this);
            CndFileVisibilityQuery.getDefault().removeChangeListener((ChangeListener)this);
            this.getConfigurationDescriptor().getFolderVisibilityQuery().removeChangeListener((ChangeListener)this);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "-----------detachFilterListener {0}", this.getPath());
            }
        }
    }

    public Folder getParent() {
        return this.parent;
    }

    public Project getProject() {
        return this.getConfigurationDescriptor().getProject();
    }

    public String getName() {
        return this.name;
    }

    private String getSortName() {
        return this.displayName;
    }

    public String getPath() {
        StringBuilder builder2 = new StringBuilder(32);
        this.reversePath(this, builder2, false);
        return builder2.toString();
    }

    public String getRootPath() {
        StringBuilder builder2 = new StringBuilder(32);
        this.reversePath(this, builder2, true);
        String path = builder2.toString();
        return path;
    }

    private void reversePath(Folder folder, StringBuilder builder, boolean fromRoot) {
        Folder aParent = folder.getParent();
        if (aParent != null && aParent.getParent() != null) {
            this.reversePath(aParent, builder, fromRoot);
            builder.append('/');
        }
        if (fromRoot && folder.isDiskFolder() && folder.getRoot() != null) {
            builder.append(folder.getRoot());
        } else {
            builder.append(folder.getName());
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.configurationDescriptor.setModified();
        this.getParent().reInsertElement(this);
    }

    public MakeConfigurationDescriptor getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    public boolean isProjectFiles() {
        return this.projectFiles;
    }

    public boolean isDiskFolder() {
        return this.getKind() == Kind.SOURCE_DISK_FOLDER;
    }

    public boolean isTestLogicalFolder() {
        return this.getKind() == Kind.TEST_LOGICAL_FOLDER;
    }

    public boolean isTestRootFolder() {
        return this.isTestLogicalFolder() && this.getName().equals("TestFiles");
    }

    public boolean isTest() {
        return this.getKind() == Kind.TEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getElements() {
        this.itemsLock.readLock().lock();
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.items);
            return arrayList;
        }
        finally {
            this.itemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reInsertElement(Object element) {
        this.itemsLock.writeLock().lock();
        try {
            int index = this.items.indexOf(element);
            if (index < 0) {
                return;
            }
            this.items.remove(element);
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
        if (element instanceof Folder) {
            this.insertFolderElement((Folder)element);
        } else if (element instanceof Item) {
            this.insertItemElement((Item)element);
        } else assert (false);
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertFolderElement(Folder element) {
        this.itemsLock.writeLock().lock();
        try {
            if (!element.isProjectFiles()) {
                this.items.add(element);
                return;
            }
            String name1 = element.getSortName();
            int indexAt = this.items.size() - 1;
            while (indexAt >= 0) {
                Object o = this.items.get(indexAt);
                if (!(o instanceof Folder)) {
                    --indexAt;
                    continue;
                }
                if (!((Folder)o).isProjectFiles()) {
                    --indexAt;
                    continue;
                }
                String name2 = ((Folder)o).getSortName();
                int compareRes = name1.compareToIgnoreCase(name2);
                if (compareRes >= 0) break;
                --indexAt;
            }
            this.items.add(indexAt + 1, element);
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
    }

    public static void insertItemElementInList(ArrayList<Object> list, Item element) {
        String name2;
        int compareRes;
        Object o;
        int indexAt;
        String name1 = element.getSortName();
        for (indexAt = list.size() - 1; indexAt >= 0 && (o = list.get(indexAt)) instanceof Item && (compareRes = name1.compareTo(name2 = ((Item)o).getSortName())) < 0; --indexAt) {
        }
        list.add(indexAt + 1, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertItemElement(Item element) {
        this.itemsLock.writeLock().lock();
        try {
            Folder.insertItemElementInList(this.items, element);
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
    }

    private void addElement(Object element, boolean setModified) {
        if (element instanceof Item) {
            this.insertItemElement((Item)element);
        } else if (element instanceof Folder) {
            this.insertFolderElement((Folder)element);
        } else assert (false);
        this.fireChangeEvent(this, setModified);
    }

    public Item addItemAction(Item item) {
        return this.addItemAction(item, true);
    }

    public Item addItemAction(Item item, boolean setModified) {
        if (this.addItem(item, true, setModified) == null) {
            return null;
        }
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>(1);
        list.add(item);
        this.configurationDescriptor.fireFilesAdded(list);
        return item;
    }

    public Item addItem(Item item) {
        return this.addItem(item, true);
    }

    public Item addItem(Item item, boolean notify) {
        return this.addItem(item, notify, true);
    }

    public Item addItem(Item item, boolean notify, boolean setModified) {
        Item existingItem;
        if (item == null) {
            return null;
        }
        if (this.isProjectFiles() && (existingItem = this.configurationDescriptor.findProjectItemByPath(item.getPath())) != null) {
            this.fireChangeEvent(existingItem, setModified);
            return null;
        }
        item.setFolder(this);
        this.addElement(item, setModified);
        if (this.isProjectFiles() && notify) {
            NativeFileItemSet myNativeFileItemSet;
            DataObject dao = item.getDataObject();
            NativeFileItemSet nativeFileItemSet = myNativeFileItemSet = dao == null ? null : (NativeFileItemSet)dao.getLookup().lookup(NativeFileItemSet.class);
            if (myNativeFileItemSet != null) {
                myNativeFileItemSet.add((NativeFileItem)item);
            } else if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "can not add folder's {0} item {1} using {2}", new Object[]{this, item, dao});
            }
        }
        if (this.isProjectFiles()) {
            this.configurationDescriptor.addProjectItem(item);
            if (setModified) {
                Project project = this.configurationDescriptor.getProject();
                if (project != null) {
                    CharSequence itemPath = CharSequences.create((CharSequence)item.getAbsolutePath());
                    MakeProjectFileProviderFactory.addToSearchBase(project, this, itemPath);
                }
                this.configurationDescriptor.setModified();
            }
            if (this.configurationDescriptor.getConfs() == null) {
                return item;
            }
            HashMap<Configuration, DeletedConfiguration> map = null;
            if (this.deletedItems != null) {
                map = this.deletedItems.get(item.getPath());
            }
            Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
            for (int i = 0; i < configurations.length; ++i) {
                FolderConfiguration folderConfiguration = this.getFolderConfiguration(configurations[i]);
                DeletedConfiguration old = null;
                if (map != null) {
                    old = map.get(configurations[i]);
                }
                ItemConfiguration ic = new ItemConfiguration(configurations[i], item);
                if (old != null && old.ic != null && old.aux != null) {
                    ic.setTool(old.ic.getTool());
                    ic.assignValues(old.aux);
                }
                configurations[i].addAuxObject(ic);
            }
            if (map != null && this.deletedItems != null) {
                this.deletedItems.remove(item.getPath());
            }
        }
        return item;
    }

    public void addFolder(Folder folder, boolean setModified) {
        this.addElement(folder, setModified);
        if (this.isProjectFiles()) {
            if (this.configurationDescriptor.getConfs() == null) {
                return;
            }
            Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
            for (int i = 0; i < configurations.length; ++i) {
                folder.getFolderConfiguration(configurations[i]);
            }
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = "f-" + this.getPath();
        }
        return this.id;
    }

    public FolderConfiguration getFolderConfiguration(Configuration configuration) {
        FolderConfiguration folderConfiguration = null;
        if ((this.isProjectFiles() || this.isTest() || this.isTestLogicalFolder()) && (folderConfiguration = (FolderConfiguration)configuration.getAuxObject(this.getId())) == null) {
            CCCompilerConfiguration parentCCCompilerConfiguration;
            CCompilerConfiguration parentCCompilerConfiguration;
            FolderConfiguration parentFolderConfiguration = null;
            if (this.getParent() != null) {
                parentFolderConfiguration = this.getParent().getFolderConfiguration(configuration);
            }
            if (parentFolderConfiguration != null) {
                parentCCompilerConfiguration = parentFolderConfiguration.getCCompilerConfiguration();
                parentCCCompilerConfiguration = parentFolderConfiguration.getCCCompilerConfiguration();
            } else {
                parentCCompilerConfiguration = ((MakeConfiguration)configuration).getCCompilerConfiguration();
                parentCCCompilerConfiguration = ((MakeConfiguration)configuration).getCCCompilerConfiguration();
            }
            folderConfiguration = new FolderConfiguration(configuration, parentCCompilerConfiguration, parentCCCompilerConfiguration, this);
            configuration.addAuxObject(folderConfiguration);
        }
        return folderConfiguration;
    }

    public String suggestedNewTestFolderName() {
        return this.suggestedName(DEFAULT_TEST_FOLDER_DISPLAY_NAME);
    }

    public String suggestedNewFolderName() {
        return this.suggestedName(DEFAULT_FOLDER_DISPLAY_NAME);
    }

    public String suggestedName(String template) {
        String aDisplayName;
        int i = 1;
        while (true) {
            String aNname = DEFAULT_FOLDER_NAME + i;
            aDisplayName = template + " " + i;
            if (this.findFolderByName(aNname) == null) break;
            ++i;
        }
        return aDisplayName;
    }

    public Folder addNewFolder(boolean projectFiles) {
        return this.addNewFolder(projectFiles, this.getKind());
    }

    public Folder addNewFolder(boolean projectFiles, Kind kind) {
        String aDisplayName;
        String aNname;
        int i = 1;
        while (true) {
            aNname = DEFAULT_FOLDER_NAME + i;
            aDisplayName = DEFAULT_FOLDER_DISPLAY_NAME + " " + i;
            if (this.findFolderByName(aNname) == null) break;
            ++i;
        }
        return this.addNewFolder(aNname, aDisplayName, projectFiles, kind);
    }

    public Folder addNewFolder(String name, String displayName, boolean projectFiles, String kindText) {
        Kind k = null;
        if (kindText != null) {
            if (kindText.equals("IMPORTANT_FILES_FOLDER")) {
                k = Kind.IMPORTANT_FILES_FOLDER;
            } else if (kindText.equals("SOURCE_DISK_FOLDER")) {
                k = Kind.SOURCE_DISK_FOLDER;
            } else if (kindText.equals("SOURCE_LOGICAL_FOLDER")) {
                k = Kind.SOURCE_LOGICAL_FOLDER;
            } else if (kindText.equals("TEST")) {
                k = Kind.TEST;
            } else if (kindText.equals("TEST_LOGICAL_FOLDER")) {
                k = Kind.TEST_LOGICAL_FOLDER;
            }
        }
        return this.addNewFolder(name, displayName, projectFiles, k);
    }

    public Folder addNewFolder(String name, String displayName, boolean projectFiles, Kind kind) {
        Folder newFolder = new Folder(this.getConfigurationDescriptor(), this, name, displayName, projectFiles, kind);
        this.addFolder(newFolder, true);
        return newFolder;
    }

    public boolean removeItemAction(Item item) {
        return this.removeItemAction(item, true);
    }

    public boolean removeItemAction(Item item, boolean setModified) {
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>(1);
        list.add(item);
        boolean ret = this.removeItem(item, setModified);
        if (this.isProjectFiles()) {
            this.configurationDescriptor.fireFilesRemoved(list);
        }
        return ret;
    }

    public void renameItemAction(String oldPath, Item newItem) {
        this.configurationDescriptor.fireFileRenamed(oldPath, newItem);
    }

    public boolean removeItem(Item item) {
        return this.removeItem(item, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItem(Item item, boolean setModified) {
        NativeFileItemSet myNativeFileItemSet;
        DataObject dataObject;
        boolean ret = false;
        if (item == null) {
            return false;
        }
        this.itemsLock.writeLock().lock();
        try {
            ret = this.items.remove(item);
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
        if (!ret) {
            this.fireChangeEvent(this, false);
            return ret;
        }
        if (this.isProjectFiles() && (dataObject = item.getDataObject()) != null && (myNativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class)) != null) {
            myNativeFileItemSet.remove((NativeFileItem)item);
        }
        if (this.isProjectFiles()) {
            this.configurationDescriptor.removeProjectItem(item);
            if (setModified) {
                Project project = this.configurationDescriptor.getProject();
                if (project != null) {
                    CharSequence itemPath = CharSequences.create((CharSequence)item.getAbsolutePath());
                    MakeProjectFileProviderFactory.removeFromSearchBase(project, this, itemPath);
                }
                this.configurationDescriptor.setModified();
            }
            if (this.deletedItems == null) {
                this.deletedItems = new HashMap();
            }
            HashMap<Configuration, DeletedConfiguration> map = new HashMap<Configuration, DeletedConfiguration>();
            this.deletedItems.put(item.getPath(), map);
            Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
            for (int i = 0; i < configurations.length; ++i) {
                DeletedConfiguration del = new DeletedConfiguration();
                del.ic = item.getItemConfiguration(configurations[i]);
                del.aux = configurations[i].removeAuxObject(item.getId());
                map.put(configurations[i], del);
            }
        }
        item.setFolder(null);
        this.fireChangeEvent(this, setModified);
        return ret;
    }

    public boolean removeFolderAction(Folder folder) {
        return this.removeFolderAction(folder, true);
    }

    public boolean removeFolderAction(Folder folder, boolean setModified) {
        boolean ret = this.removeFolder(folder, setModified);
        this.configurationDescriptor.fireFilesRemoved(folder.getAllItemsAsList());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFolder(Folder folder, boolean setModified) {
        boolean ret = false;
        if (folder != null) {
            for (Folder f : folder.getAllFolders(false)) {
                MakeProjectFileProviderFactory.updateSearchBase(this.configurationDescriptor.getProject(), f, null);
            }
            MakeProjectFileProviderFactory.updateSearchBase(this.configurationDescriptor.getProject(), folder, null);
            if (folder.isDiskFolder()) {
                folder.detachListener();
            }
            folder.removeAll();
            this.itemsLock.writeLock().lock();
            try {
                ret = this.items.remove(folder);
            }
            finally {
                this.itemsLock.writeLock().unlock();
            }
            if (this.isProjectFiles()) {
                Configuration[] configurations = this.configurationDescriptor.getConfs().toArray();
                for (int i = 0; i < configurations.length; ++i) {
                    configurations[i].removeAuxObject(folder.getId());
                }
            }
        }
        if (ret) {
            this.fireChangeEvent(this, setModified);
        }
        return ret;
    }

    private void removeAll() {
        int i;
        Item[] itemsToRemove = this.getItemsAsArray();
        Folder[] foldersToRemove = this.getFoldersAsArray();
        for (i = 0; i < itemsToRemove.length; ++i) {
            this.removeItem(itemsToRemove[i]);
        }
        for (i = 0; i < foldersToRemove.length; ++i) {
            this.removeFolder(foldersToRemove[i], true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.itemsLock.writeLock().lock();
        try {
            this.items.clear();
        }
        finally {
            this.itemsLock.writeLock().unlock();
        }
        this.fireChangeEvent();
    }

    public Item findItemByPath(String path) {
        if (path == null) {
            return null;
        }
        Item[] anItems = this.getItemsAsArray();
        for (int i = 0; i < anItems.length; ++i) {
            if (!path.equals(anItems[i].getPath())) continue;
            return anItems[i];
        }
        return null;
    }

    public Item findItemByAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        Item[] anItems = this.getItemsAsArray();
        for (int i = 0; i < anItems.length; ++i) {
            if (!path.equals(anItems[i].getAbsolutePath())) continue;
            return anItems[i];
        }
        return null;
    }

    public Item findItemByName(String name) {
        if (name == null) {
            return null;
        }
        Item[] anItems = this.getItemsAsArray();
        for (int i = 0; i < anItems.length; ++i) {
            if (!name.equals(anItems[i].getName())) continue;
            return anItems[i];
        }
        return null;
    }

    public Folder findFolderByName(String name) {
        if (name == null) {
            return null;
        }
        Folder[] folders = this.getFoldersAsArray();
        for (int i = 0; i < folders.length; ++i) {
            if (!name.equals(folders[i].getName())) continue;
            return folders[i];
        }
        return null;
    }

    public Folder findFolderByDisplayName(String name) {
        if (name == null) {
            return null;
        }
        Folder[] folders = this.getFoldersAsArray();
        for (int i = 0; i < folders.length; ++i) {
            if (!name.equals(folders[i].getDisplayName())) continue;
            return folders[i];
        }
        return null;
    }

    public Folder findFolderByAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        for (Folder folder : this.getFolders()) {
            String absPath = folder.getAbsolutePath();
            if (absPath == null || !path.equals(absPath)) continue;
            return folder;
        }
        return null;
    }

    public Folder findFolderByRelativePath(String path) {
        if (path == null) {
            return null;
        }
        for (Folder folder : this.getFolders()) {
            String relPath = folder.getRoot();
            if (relPath == null || !path.equals(relPath)) continue;
            return folder;
        }
        return null;
    }

    public String getAbsolutePath() {
        String absRootPath = CndPathUtilitities.toAbsolutePath((String)this.configurationDescriptor.getBaseDir(), (String)this.getRoot());
        FileObject folderFile = RemoteFileUtil.getFileObject((String)(absRootPath = RemoteFileUtil.normalizeAbsolutePath((String)absRootPath, (Project)this.getProject())), (Project)this.getProject());
        if (folderFile != null) {
            return folderFile.getPath();
        }
        return null;
    }

    public Folder findFolderByPath(String path) {
        int i = path.indexOf(47);
        if (i >= 0) {
            String aName = path.substring(0, i);
            Folder folder = this.findFolderByName(aName);
            if (folder == null) {
                return null;
            }
            return folder.findFolderByPath(path.substring(i + 1));
        }
        return this.findFolderByName(path);
    }

    public Item[] getItemsAsArray() {
        ArrayList<Item> found = new ArrayList<Item>();
        for (Object o : new ArrayList<Object>(this.getElements())) {
            if (!(o instanceof Item)) continue;
            found.add((Item)o);
        }
        return found.toArray(new Item[found.size()]);
    }

    private List<NativeFileItem> getAllItemsAsList() {
        ArrayList<NativeFileItem> found = new ArrayList<NativeFileItem>();
        for (Object o : new ArrayList<Object>(this.getElements())) {
            if (o instanceof Item) {
                found.add((Item)o);
            }
            if (!(o instanceof Folder)) continue;
            List<NativeFileItem> anItems = ((Folder)o).getAllItemsAsList();
            found.addAll(anItems);
        }
        return found;
    }

    public Item[] getAllItemsAsArray() {
        List<NativeFileItem> list = this.getAllItemsAsList();
        return list.toArray(new Item[list.size()]);
    }

    public Set<DataObject> getAllItemsAsDataObjectSet(boolean projectFilesOnly, String MIMETypeFilter) {
        LinkedHashSet<DataObject> files = new LinkedHashSet<DataObject>();
        this.getAllItemsAsDataObjectSet(files, projectFilesOnly, MIMETypeFilter);
        return files;
    }

    private void getAllItemsAsDataObjectSet(Set<DataObject> files, boolean projectFilesOnly, String MIMETypeFilter) {
        if (!projectFilesOnly || this.isProjectFiles()) {
            for (Object item : new ArrayList<Object>(this.getElements())) {
                if (item instanceof Item) {
                    DataObject da = ((Item)item).getDataObject();
                    if (da == null || MIMETypeFilter != null && !da.getPrimaryFile().getMIMEType().contains(MIMETypeFilter)) continue;
                    files.add(da);
                    continue;
                }
                if (!(item instanceof Folder)) continue;
                ((Folder)item).getAllItemsAsDataObjectSet(files, projectFilesOnly, MIMETypeFilter);
            }
        }
    }

    public Folder[] getFoldersAsArray() {
        List<Folder> folders = this.getFolders();
        return folders.toArray(new Folder[folders.size()]);
    }

    public List<Folder> getFolders() {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (Object item : new ArrayList<Object>(this.getElements())) {
            if (!(item instanceof Folder)) continue;
            folders.add((Folder)item);
        }
        return folders;
    }

    public List<Folder> getAllFolders(boolean projectFilesOnly) {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        this.getAllFolders(folders, projectFilesOnly);
        return folders;
    }

    private void getAllFolders(List<Folder> folders, boolean projectFilesOnly) {
        if (!projectFilesOnly || this.isProjectFiles()) {
            for (Object item : new ArrayList<Object>(this.getElements())) {
                if (!(item instanceof Folder)) continue;
                Folder folder = (Folder)item;
                if (projectFilesOnly && !folder.isProjectFiles()) continue;
                folders.add(folder);
                folder.getAllFolders(folders, projectFilesOnly);
            }
        }
    }

    public List<Folder> getAllTests() {
        ArrayList<Folder> list = new ArrayList<Folder>();
        this.getTests(list);
        return list;
    }

    private void getTests(List<Folder> list) {
        for (Object o : new ArrayList<Object>(this.getElements())) {
            if (!(o instanceof Folder)) continue;
            if (((Folder)o).isTest()) {
                list.add((Folder)o);
            }
            ((Folder)o).getTests(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.remove(cl);
        }
    }

    public void refresh(Object source) {
        this.fireChangeEvent(source, true);
    }

    public void fireChangeEvent() {
        this.fireChangeEvent(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(Object source, boolean setModified) {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.changeListenerList).iterator();
        }
        ChangeEvent ev = new ChangeEvent(source);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
        if (setModified) {
            this.configurationDescriptor.setModified();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINE, "------------stateChanged {0}", this.getPath());
        }
        if (this.isDiskFolder()) {
            this.refreshDiskFolder(true);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    private FileObject getThisFolder() {
        String rootPath = this.getRootPath();
        return RemoteFileUtil.getFileObject((FileObject)this.configurationDescriptor.getBaseDirFileObject(), (String)rootPath);
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fileObject = fe.getFile();
        FileObject thisFolder = this.getThisFolder();
        FileObject aParent = fileObject.getParent();
        if (aParent.equals(thisFolder)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------fileDataCreated {0} in {1}", new Object[]{fileObject, this.getPath()});
            }
            if (fileObject == null || !fileObject.isValid() || fileObject.isFolder()) {
                return;
            }
            if (!FileFilterFactory.getAllSourceFileFilter().accept(fileObject)) {
                this.fireChangeEvent(this, false);
                return;
            }
            String itemPath = fileObject.getPath();
            itemPath = CndPathUtilitities.toRelativePath((String)this.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
            itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath);
            Item item = Item.createInFileSystem(this.configurationDescriptor.getBaseDirFileSystem(), itemPath);
            this.addItemAction(item, false);
        } else {
            while (aParent != null && aParent.isValid() && !aParent.isRoot()) {
                if (aParent.equals(thisFolder)) {
                    for (Folder folder : this.getFolders()) {
                        folder.fileDataCreated(fe);
                    }
                    return;
                }
                aParent = aParent.getParent();
            }
        }
    }

    public void fileFolderCreated(FileEvent fe) {
        FileObject fileObject = fe.getFile();
        assert (fileObject.isFolder());
        FileObject thisFolder = this.getThisFolder();
        FileObject aParent = fileObject.getParent();
        if (aParent.equals(thisFolder)) {
            if (fileObject.isValid()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "------------fileFolderCreated {0} in {1}", new Object[]{fileObject, this.getPath()});
                }
                if (fileObject == null || !fileObject.isValid() || !fileObject.isFolder()) {
                    return;
                }
                this.getConfigurationDescriptor().addFilesFromDir(this, fileObject, true, false, null);
            }
        } else {
            while (aParent != null && aParent.isValid() && !aParent.isRoot()) {
                if (aParent.equals(thisFolder)) {
                    for (Folder folder : this.getFolders()) {
                        folder.fileFolderCreated(fe);
                    }
                    return;
                }
                aParent = aParent.getParent();
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        FileObject fileObject = fe.getFile();
        FileObject thisFolder = this.getThisFolder();
        FileObject aParent = fileObject.getParent();
        if (aParent.equals(thisFolder)) {
            Item item;
            String path;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------fileDeleted {0} in {1}", new Object[]{fileObject, this.getPath()});
            }
            if ((path = this.getRootPath() + '/' + fileObject.getNameExt()).startsWith("./")) {
                path = path.substring(2);
            }
            if ((item = CndPathUtilitities.isPathAbsolute((CharSequence)path) ? this.findItemByAbsolutePath(path) : this.findItemByPath(path)) != null) {
                this.removeItemAction(item, false);
                return;
            }
            Folder folder = this.findFolderByName(fileObject.getNameExt());
            if (folder != null) {
                this.removeFolderAction(folder, false);
                return;
            }
            this.fireChangeEvent(this, false);
        } else {
            while (aParent != null && aParent.isValid() && !aParent.isRoot()) {
                if (aParent.equals(thisFolder)) {
                    for (Folder folder : this.getFolders()) {
                        folder.fileDeleted(fe);
                    }
                    return;
                }
                aParent = aParent.getParent();
            }
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject fileObject = fe.getFile();
        FileObject thisFolder = this.getThisFolder();
        FileObject aParent = fileObject.getParent();
        if (aParent.equals(thisFolder)) {
            Folder folder;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "------------fileRenamed {0} in {1}", new Object[]{fileObject.getPath(), this.getPath()});
            }
            if ((folder = this.findFolderByName(fe.getName())) != null && folder.isDiskFolder()) {
                Folder top = this.getConfigurationDescriptor().addFilesFromDir(this, fileObject, true, false, null);
                Folder.copyConfigurations(folder, top);
                this.removeFolderAction(folder, false);
            }
        } else {
            while (aParent != null && aParent.isValid() && !aParent.isRoot()) {
                if (aParent.equals(thisFolder)) {
                    for (Folder folder : this.getFolders()) {
                        folder.fileRenamed(fe);
                    }
                }
                aParent = aParent.getParent();
            }
        }
    }

    private void copyConfigurations(Folder src) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        for (Configuration conf : makeConfigurationDescriptor.getConfs().toArray()) {
            FolderConfiguration srcFolderConfiguration = src.getFolderConfiguration(conf);
            FolderConfiguration dstFolderConfiguration = this.getFolderConfiguration(conf);
            if (srcFolderConfiguration == null || dstFolderConfiguration == null) continue;
            dstFolderConfiguration.assignValues(srcFolderConfiguration);
        }
    }

    private static void copyConfigurations(Folder oldFolder, Folder newFolder) {
        Folder[] srcFolders;
        Item[] oldItems;
        newFolder.copyConfigurations(oldFolder);
        for (Item oldItem : oldItems = oldFolder.getItemsAsArray()) {
            Item newItem = newFolder.findItemByName(oldItem.getName());
            if (newItem == null) continue;
            newItem.copyConfigurations(oldItem);
        }
        for (Folder srcFolder : srcFolders = oldFolder.getFoldersAsArray()) {
            Folder dstFolder = newFolder.findFolderByName(srcFolder.getName());
            if (dstFolder == null) continue;
            dstFolder.copyConfigurations(srcFolder);
        }
    }

    private static boolean checkLogging() {
        if (checkedLogging) {
            return true;
        }
        String logProp = System.getProperty("makeproject.folder");
        if (logProp != null) {
            if (logProp.equals("FINE")) {
                log.setLevel(Level.FINE);
            } else if (logProp.equals("FINER")) {
                log.setLevel(Level.FINER);
            } else if (logProp.equals("FINEST")) {
                log.setLevel(Level.FINEST);
            }
        }
        return true;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(Folder.class, (String)s);
    }

    public String toString() {
        return this.name;
    }

    private static final class DeletedConfiguration {
        private ConfigurationAuxObject aux;
        private ItemConfiguration ic;

        private DeletedConfiguration() {
        }
    }

    public static enum Kind {
        ROOT,
        SOURCE_LOGICAL_FOLDER,
        SOURCE_DISK_FOLDER,
        IMPORTANT_FILES_FOLDER,
        TEST_LOGICAL_FOLDER,
        TEST;

    }
}

