/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.CompilerSetNodeProp;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CompilerSet2Configuration
implements PropertyChangeListener {
    public static final String DEFAULT_CS = "default";
    private DevelopmentHostConfiguration dhconf;
    private StringConfiguration compilerSetName;
    private CompilerSetNodeProp compilerSetNodeProp;
    private String flavor;
    private boolean dirty = false;
    private Map<String, String> oldNameMap = new HashMap<String, String>();

    private CompilerSet2Configuration(CompilerSet2Configuration other) {
        this.dhconf = other.dhconf.clone();
        this.compilerSetName = other.compilerSetName.clone();
        this.flavor = other.flavor;
        this.compilerSetNodeProp = null;
    }

    public CompilerSet2Configuration(DevelopmentHostConfiguration dhconf) {
        this.dhconf = dhconf;
        this.compilerSetName = new StringConfiguration(null, DEFAULT_CS);
        this.flavor = null;
        this.compilerSetNodeProp = null;
    }

    public CompilerSet2Configuration(DevelopmentHostConfiguration dhconf, CompilerSet cs) {
        String csName;
        this.dhconf = dhconf;
        String string = csName = cs == null ? null : cs.getName();
        if (csName == null || csName.length() == 0) {
            csName = this.getCompilerSetManager().getCompilerSets().size() > 0 ? ((CompilerSet)this.getCompilerSetManager().getCompilerSets().get(0)).getName() : (Utilities.getOperatingSystem() == 8 ? "Sun" : "GNU");
        }
        this.compilerSetName = new StringConfiguration(null, csName);
        this.flavor = null;
        this.compilerSetNodeProp = null;
    }

    public final CompilerSetManager getCompilerSetManager() {
        return CompilerSetManager.get((ExecutionEnvironment)this.dhconf.getExecutionEnvironment());
    }

    public StringConfiguration getCompilerSetName() {
        return this.compilerSetName;
    }

    public void setCompilerSetName(StringConfiguration compilerSetName) {
        this.compilerSetName = compilerSetName;
    }

    public void setCompilerSetNodeProp(CompilerSetNodeProp compilerSetNodeProp) {
        this.compilerSetNodeProp = compilerSetNodeProp;
    }

    public void setValue(String name) {
        if (!this.getOption().equals(name)) {
            this.setValue(name, null);
        }
    }

    public void restore(String name, int version) {
        String fl;
        String nm;
        int index = name.indexOf(124);
        if (index > 0) {
            nm = name.substring(0, index);
            fl = name.substring(index + 1);
        } else {
            nm = name;
            fl = DEFAULT_CS.equals(nm) ? null : name;
        }
        this.setValue(CompilerSet2Configuration.mapOldToNew(nm, version), CompilerSet2Configuration.mapOldToNew(fl, version));
    }

    private void setValue(String name, String flavor) {
        if (name == null || name.startsWith(CompilerSetNodeProp.DEFAULT_CS + " (")) {
            name = DEFAULT_CS;
        }
        this.getCompilerSetName().setValue(name);
        this.setFlavor(flavor);
    }

    public CompilerSet getCompilerSet() {
        String value = this.getCompilerSetName().getValue();
        if (DEFAULT_CS.equals(value)) {
            return this.getCompilerSetManager().getDefaultCompilerSet();
        }
        return this.getCompilerSetManager().getCompilerSet(value);
    }

    public boolean isDefaultCompilerSet() {
        return DEFAULT_CS.equals(this.getCompilerSetName().getValue());
    }

    public String getName() {
        return this.getDisplayName(false);
    }

    public String getDisplayName(boolean createIfNotFound) {
        CompilerSet compilerSet;
        boolean isDefault;
        String value = this.getCompilerSetName().getValue();
        if (DEFAULT_CS.equals(value)) {
            isDefault = true;
            compilerSet = this.getCompilerSetManager().getDefaultCompilerSet();
        } else {
            isDefault = false;
            compilerSet = this.getCompilerSetManager().getCompilerSet(value);
        }
        String displayName = null;
        if (compilerSet != null) {
            displayName = isDefault ? CompilerSetNodeProp.DEFAULT_CS + " (" + compilerSet.getName() + ")" : compilerSet.getName();
        }
        if (displayName != null && this.dhconf.isConfigured()) {
            return displayName;
        }
        if (createIfNotFound) {
            return this.createNotFoundName(value);
        }
        return "";
    }

    private String createNotFoundName(String name) {
        if (!this.dhconf.isConfigured()) {
            return "";
        }
        return name.equals("None") ? name : NbBundle.getMessage(CompilerSet2Configuration.class, (String)"NOT_FOUND", (Object)name);
    }

    public boolean isDevHostSetUp() {
        return this.dhconf.isConfigured();
    }

    public void assign(CompilerSet2Configuration conf) {
        String oldName = this.getCompilerSetName().getValue();
        String newName = conf.getCompilerSetName().getValue();
        this.setDirty(newName != null && !newName.equals(oldName));
        this.setValue(conf.getCompilerSetName().getValue());
    }

    public CompilerSet2Configuration clone() {
        CompilerSet2Configuration clone = new CompilerSet2Configuration(this);
        return clone;
    }

    public void setDevelopmentHostConfiguration(DevelopmentHostConfiguration dhconf) {
        this.dhconf = dhconf;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public boolean isValid() {
        return this.getCompilerSet() != null;
    }

    public String getOption() {
        return this.getCompilerSetName().getValue();
    }

    public String getNameAndFlavor() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getOption());
        if (!DEFAULT_CS.equals(this.getOption()) && this.getFlavor() != null) {
            ret.append("|");
            ret.append(this.getFlavor());
        }
        return ret.toString();
    }

    public String getFlavor() {
        CompilerSet cs;
        if (this.flavor == null && (cs = this.getCompilerSet()) != null) {
            this.flavor = cs.getCompilerFlavor().toString();
        }
        return this.flavor;
    }

    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        CompilerSet ocs = null;
        String hkey = ((DevelopmentHostConfiguration)evt.getNewValue()).getHostKey();
        final ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)hkey);
        String oldName = this.oldNameMap.get(hkey);
        ocs = oldName != null ? CompilerSetManager.get((ExecutionEnvironment)env).getCompilerSet(oldName) : CompilerSetManager.get((ExecutionEnvironment)env).getDefaultCompilerSet();
        if (ocs == null && !CompilerSetManager.get((ExecutionEnvironment)env).getCompilerSets().isEmpty()) {
            ocs = (CompilerSet)CompilerSetManager.get((ExecutionEnvironment)env).getCompilerSets().get(0);
        }
        if (ocs == null) {
            return;
        }
        String okey = (String)evt.getOldValue();
        this.oldNameMap.put(okey, this.getName());
        if (env.isLocal()) {
            this.setValue(ocs.getName());
        } else {
            this.setValue(ocs.getName());
            final CompilerSet focs = ocs;
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ServerRecord record = ServerList.get((ExecutionEnvironment)env);
                    if (record != null) {
                        CompilerSet2Configuration.this.setValue(focs.getName());
                        if (CompilerSet2Configuration.this.compilerSetNodeProp != null) {
                            CompilerSet2Configuration.this.compilerSetNodeProp.repaint();
                        }
                    }
                }
            });
        }
    }

    private static String mapOldToNew(String flavor, int version) {
        if (version <= 43) {
            if ("Sun".equals(flavor)) {
                return "SunStudio";
            }
            if ("SunExpress".equals(flavor)) {
                return "SunStudioExpress";
            }
            if ("Sun12".equals(flavor)) {
                return "SunStudio_12";
            }
            if ("Sun11".equals(flavor)) {
                return "SunStudio_11";
            }
            if ("Sun10".equals(flavor)) {
                return "SunStudio_10";
            }
            if ("Sun9".equals(flavor)) {
                return "SunStudio_9";
            }
            if ("Sun8".equals(flavor)) {
                return "SunStudio_8";
            }
            if ("DJGPP".equals(flavor)) {
                return "GNU";
            }
            if ("Interix".equals(flavor)) {
                return "GNU";
            }
            if ("Unknown".equals(flavor)) {
                return "GNU";
            }
        }
        return flavor;
    }
}

