/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import javax.swing.Action;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public class RunDialogAction
extends NodeAction {
    protected JButton runButton = null;
    private Object[] options;
    private FileObject contextFileObject;

    private void init(boolean isRun) {
        if (this.runButton == null) {
            this.runButton = new JButton(this.getString("RunButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("RunButtonAD"));
            this.options = new Object[]{this.runButton, DialogDescriptor.CANCEL_OPTION};
        }
        if (isRun) {
            this.runButton.setText(this.getString("RunButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("RunButtonAD"));
        } else {
            this.runButton.setText(this.getString("CreateButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("CreateButtonAD"));
        }
    }

    public String getName() {
        return this.getString("RUN_COMMAND");
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.contextFileObject = (FileObject)actionContext.lookup(FileObject.class);
        return super.createContextAwareInstance(actionContext);
    }

    protected void performAction(Node[] activatedNodes) {
        FileObject executableFO = null;
        boolean isRun = true;
        if (activatedNodes != null && activatedNodes.length == 1) {
            FileObject fo;
            DataObject dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class);
            String mime = this.getMime(dataObject);
            if (dataObject != null && dataObject.isValid() && MIMENames.isBinary((String)mime) && (fo = dataObject.getPrimaryFile()) != null) {
                executableFO = fo;
            }
        } else if (this.contextFileObject != null) {
            executableFO = this.contextFileObject;
            isRun = false;
        }
        this.perform(executableFO, isRun);
    }

    protected String getMime(DataObject dob) {
        FileObject primaryFile = dob == null ? null : dob.getPrimaryFile();
        String mime = primaryFile == null ? "" : primaryFile.getMIMEType();
        return mime;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class);
        String mime = this.getMime(dataObject);
        return MIMENames.isBinary((String)mime) && !"application/x-core+elf".equals(mime);
    }

    protected void perform(FileObject executableFO, boolean isRun) {
        this.init(isRun);
        try {
            this.perform(new RunDialogPanel(executableFO, this.runButton, isRun), isRun);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void perform(final RunDialogPanel runDialogPanel, final boolean isRun) {
        if (WindowManager.getDefault().getRegistry().getOpened().isEmpty()) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            runDialogPanel.getSelectedProject(null);
                        }
                    });
                }
            });
            return;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runDialogPanel, isRun ? this.getString("RunDialogTitle") : this.getString("CreateDialogTitle"), true, this.options, (Object)this.runButton, 0, null, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (ret == this.runButton) {
            runDialogPanel.getSelectedProject(new RunDialogPanel.RunProjectAction(){

                @Override
                public void run(Project project) {
                    MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration(project);
                    if (conf != null && isRun) {
                        RunProfile profile = conf.getProfile();
                        String path = runDialogPanel.getExecutablePath();
                        path = CndPathUtilitities.toRelativePath((String)profile.getRunDirectory(), (String)path);
                        ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, ProjectActionEvent.PredefinedType.RUN, path, conf, profile, false);
                        ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
                    }
                }
            });
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunDialogAction.class);
    }

    private String getString(String s) {
        return NbBundle.getMessage(RunDialogAction.class, (String)s);
    }

    protected boolean asynchronous() {
        return false;
    }
}

