/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

public class MakeSharabilityQuery
implements SharabilityQueryImplementation {
    private final FileObject baseDirFile;
    private final String baseDir;
    private final int baseDirLength;
    private boolean privateShared;
    private final ConfigurationDescriptorProvider projectDescriptorProvider;
    private static final boolean IGNORE_BINARIES = CndUtils.getBoolean((String)"cnd.vcs.ignore.binaries", (boolean)true);
    private boolean inited = false;
    private Set<String> skippedFiles = new HashSet<String>();

    MakeSharabilityQuery(ConfigurationDescriptorProvider projectDescriptorProvider, FileObject baseDirFile) {
        this.projectDescriptorProvider = projectDescriptorProvider;
        this.baseDirFile = baseDirFile;
        this.baseDir = baseDirFile.getPath();
        this.baseDirLength = this.baseDir.length();
        this.privateShared = false;
    }

    public int getSharability(final File file) {
        this.init();
        Integer ret = (Integer)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer run() {
                MakeSharabilityQuery makeSharabilityQuery = MakeSharabilityQuery.this;
                synchronized (makeSharabilityQuery) {
                    if (IGNORE_BINARIES && CndFileVisibilityQuery.getDefault().isIgnored(file)) {
                        return 2;
                    }
                    if (MakeSharabilityQuery.this.skippedFiles.contains(file.getAbsolutePath())) {
                        return 2;
                    }
                    boolean sub = file.getPath().startsWith(MakeSharabilityQuery.this.baseDir);
                    if (!sub) {
                        return 0;
                    }
                    if (file.getPath().equals(MakeSharabilityQuery.this.baseDir)) {
                        return 3;
                    }
                    if (file.getPath().length() <= MakeSharabilityQuery.this.baseDirLength + 1) {
                        return 0;
                    }
                    String subString = file.getPath().substring(MakeSharabilityQuery.this.baseDirLength + 1);
                    if (subString.equals("nbproject")) {
                        return 3;
                    }
                    if (subString.equals("Makefile")) {
                        return 1;
                    }
                    if (subString.equals("nbproject" + File.separator + "configurations.xml")) {
                        return 1;
                    }
                    if (subString.equals("nbproject" + File.separator + "private")) {
                        return MakeSharabilityQuery.this.privateShared ? 1 : 2;
                    }
                    if (subString.equals("nbproject" + File.separator + "project.properties")) {
                        return 1;
                    }
                    if (subString.equals("nbproject" + File.separator + "project.xml")) {
                        return 1;
                    }
                    if (subString.startsWith("nbproject" + File.separator + "Makefile-")) {
                        return 1;
                    }
                    if (subString.startsWith("nbproject" + File.separator + "Package-")) {
                        return 1;
                    }
                    if (subString.startsWith("nbproject" + File.separator + "qt-")) {
                        return subString.endsWith(".pro") ? 1 : 2;
                    }
                    if (subString.startsWith("build" + File.separator)) {
                        return 2;
                    }
                    if (subString.startsWith("dist" + File.separator)) {
                        return 2;
                    }
                    return 0;
                }
            }
        });
        return ret;
    }

    public void setPrivateShared(boolean privateShared) {
        this.privateShared = privateShared;
    }

    public boolean getPrivateShared() {
        return this.privateShared;
    }

    public void update() {
        this.inited = false;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.inited) {
            MakeSharabilityQuery makeSharabilityQuery = this;
            synchronized (makeSharabilityQuery) {
                MakeConfigurationDescriptor cd;
                if (!this.inited && this.projectDescriptorProvider.gotDescriptor() && (cd = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
                    Configurations confs = cd.getConfs();
                    HashSet<String> newSet = new HashSet<String>();
                    for (Configuration conf : confs.getConfigurations()) {
                        if (!(conf instanceof MakeConfiguration)) continue;
                        newSet.add(CndFileUtils.normalizeAbsolutePath((String)((MakeConfiguration)conf).getAbsoluteOutputValue()));
                    }
                    this.skippedFiles = newSet;
                    this.inited = true;
                }
            }
        }
    }
}

