/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MakeProjectGeneratorImpl {
    private static final String PROP_DBCONN = "dbconn";

    private MakeProjectGeneratorImpl() {
    }

    public static String getDefaultProjectFolder() {
        return ProjectChooser.getProjectsFolder().getPath();
    }

    public static String getDefaultProjectFolder(ExecutionEnvironment env) {
        try {
            return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir() + '/' + ProjectChooser.getProjectsFolder().getName();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ConnectionManager.CancellationException ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    public static String getValidProjectName(String projectFolder) {
        return MakeProjectGeneratorImpl.getValidProjectName(projectFolder, "Project");
    }

    public static String getValidProjectName(String projectFolder, String name) {
        File projectNameFile;
        int baseCount = 0;
        String projectName = null;
        while ((projectNameFile = CndFileUtils.createLocalFile((String)projectFolder, (String)(projectName = baseCount == 0 ? name : name + baseCount))).exists()) {
            ++baseCount;
        }
        return projectName;
    }

    public static MakeProject createBlankProject(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        MakeConfiguration[] confs = prjParams.getConfigurations();
        String projectFolderPath = prjParams.getProjectFolderPath();
        MakeConfiguration[] copyConfs = new MakeConfiguration[confs.length];
        for (int i = 0; i < confs.length; ++i) {
            copyConfs[i] = confs[i].clone();
            copyConfs[i].setBaseFSPath(new FSPath(prjParams.getSourceFileSystem(), projectFolderPath));
            RunProfile profile = (RunProfile)copyConfs[i].getAuxObject("runprofile");
            profile.setBuildFirst(false);
        }
        FileObject dirFO = MakeProjectGeneratorImpl.createProjectDir(prjParams);
        prjParams.setConfigurations(copyConfs);
        MakeProjectGeneratorImpl.createProject(dirFO, prjParams, true);
        MakeProject p = (MakeProject)ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject((Project)p);
        if (prjParams.getOpenFlag()) {
            OpenProjects.getDefault().open(new Project[]{p}, false);
            OpenProjects.getDefault().setMainProject((Project)p);
        }
        return p;
    }

    public static MakeProject createProject(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        FileObject dirFO = MakeProjectGeneratorImpl.createProjectDir(prjParams);
        MakeProjectHelper h = MakeProjectGeneratorImpl.createProject(dirFO, prjParams, false);
        MakeProject p = (MakeProject)ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject((Project)p);
        p.setRemoteMode(prjParams.getRemoteMode());
        if (prjParams.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
            p.setRemoteFileSystemHost(ExecutionEnvironmentFactory.fromUniqueID((String)prjParams.getHostUID()));
        }
        if (prjParams.getDatabaseConnection() != null) {
            Preferences prefs = ProjectUtils.getPreferences((Project)p, ProjectSupport.class, (boolean)true);
            prefs.put(PROP_DBCONN, prjParams.getDatabaseConnection());
        }
        return p;
    }

    private static MakeProjectHelper createProject(FileObject dirFO, final ProjectGenerator.ProjectParameters prjParams, boolean saveNow) throws IOException {
        FileObject sourceBaseFO;
        String name = prjParams.getProjectName();
        String makefileName = prjParams.getMakefileName();
        Configuration[] confs = prjParams.getConfigurations();
        if (prjParams.getFullRemote()) {
            RemoteSyncFactory factory = RemoteSyncFactory.fromID((String)"full");
            CndUtils.assertNotNull((Object)factory, (String)"Can not find sync factory for full remote");
            Configuration[] arr$ = confs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                MakeConfiguration conf;
                MakeConfiguration mk = conf = arr$[i$];
                mk.setFixedRemoteSyncFactory(factory);
                mk.setRemoteMode(RemoteProject.Mode.REMOTE_SOURCES);
            }
        }
        final Iterator<SourceFolderInfo> sourceFolders = prjParams.getSourceFolders();
        String sourceFoldersFilter = prjParams.getSourceFoldersFilter();
        final Iterator<SourceFolderInfo> testFolders = prjParams.getTestFolders();
        final Iterator<String> importantItems = prjParams.getImportantFiles();
        String mainFile = prjParams.getMainFile();
        MakeProjectHelper h = MakeProjectGenerator.createProject(dirFO, "org.netbeans.modules.cnd.makeproject");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        if (prjParams.getFullRemote()) {
            Element fullRemoteNode = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "remote-sources-mode");
            fullRemoteNode.appendChild(doc.createTextNode(prjParams.getRemoteMode().name()));
            data.appendChild(fullRemoteNode);
            Element rfsHostNode = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "remote-filesystem-host");
            rfsHostNode.appendChild(doc.createTextNode(prjParams.getHostUID()));
            data.appendChild(rfsHostNode);
            String remoteProjectPath = prjParams.getFullRemoteNativeProjectPath();
            Element rfsBaseDir = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "remote-filesystem-base-dir");
            rfsBaseDir.appendChild(doc.createTextNode(remoteProjectPath));
            data.appendChild(rfsBaseDir);
            ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)prjParams.getHostUID());
            sourceBaseFO = FileSystemProvider.getFileObject((ExecutionEnvironment)env, (String)remoteProjectPath);
            if (sourceBaseFO == null) {
                throw new FileNotFoundException("File does not exist: " + env + ':' + remoteProjectPath);
            }
        } else {
            sourceBaseFO = dirFO;
        }
        h.putPrimaryConfigurationData(data, true);
        final MakeConfigurationDescriptor projectDescriptor = new MakeConfigurationDescriptor(dirFO, sourceBaseFO);
        if (makefileName != null) {
            projectDescriptor.setProjectMakefileName(makefileName);
        }
        projectDescriptor.init(confs);
        projectDescriptor.setState(ConfigurationDescriptor.State.READY);
        Project project = projectDescriptor.getProject();
        projectDescriptor.setProject(project);
        final String mainFilePath = mainFile.length() > 0 ? MakeProjectGeneratorImpl.createMain(mainFile, dirFO, prjParams.getTemplateParams()) : null;
        if (sourceFoldersFilter != null && !"^(nbproject|build|test|tests)$".equals(sourceFoldersFilter)) {
            projectDescriptor.setFolderVisibilityQuery(sourceFoldersFilter);
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                projectDescriptor.initLogicalFolders(sourceFolders, sourceFolders == null, testFolders, importantItems, mainFilePath, prjParams.getFullRemote());
                projectDescriptor.save();
                projectDescriptor.closed();
                projectDescriptor.clean();
            }
        };
        if (project instanceof MakeProject && !saveNow) {
            MakeProject makeProject = (MakeProject)project;
            makeProject.addOpenedTask(task);
        } else {
            task.run();
        }
        if (!prjParams.getFullRemote() && !prjParams.isMakefileProject()) {
            MakeProjectGeneratorImpl.copyURLFile("nbresloc:/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile", projectDescriptor.getBaseDir() + File.separator + projectDescriptor.getProjectMakefileName());
        }
        return h;
    }

    private static void copyURLFile(String fromURL, String toFile) throws IOException {
        InputStream is = null;
        try {
            URL url = new URL(fromURL);
            is = url.openStream();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            FileOutputStream os = new FileOutputStream(toFile);
            MakeProjectGeneratorImpl.copy(is, os);
        }
    }

    private static void copy(InputStream is, OutputStream os) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        while ((line = br.readLine()) != null) {
            bw.write(line + "\n");
        }
        bw.flush();
    }

    private static FileObject createProjectDir(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        FileObject dirFO = FileUtil.createFolder((FileObject)prjParams.getSourceFileSystem().getRoot(), (String)prjParams.getProjectFolderPath());
        assert (dirFO != null) : "No such dir on disk: " + prjParams.getProjectFolderPath();
        assert (dirFO.isValid()) : "No such dir on disk: " + prjParams.getProjectFolderPath();
        assert (dirFO.isFolder()) : "Not really a dir: " + prjParams.getProjectFolderPath();
        return dirFO;
    }

    private static String createMain(String mainFile, FileObject srcFolder, Map<String, Object> templateParams) throws IOException {
        String mainName = mainFile.substring(0, mainFile.indexOf(124));
        String template = mainFile.substring(mainFile.indexOf(124) + 1);
        if (mainName.length() == 0) {
            return null;
        }
        FileObject mainTemplate = FileUtil.getConfigFile((String)template);
        if (mainTemplate == null) {
            return null;
        }
        String createdMainName = mainName;
        if (mainName.indexOf(92) > 0 || mainName.indexOf(47) > 0) {
            String absPath = CndPathUtilitities.toAbsolutePath((FileObject)srcFolder, (String)mainName);
            absPath = FileSystemProvider.getCanonicalPath((FileSystem)srcFolder.getFileSystem(), (String)absPath);
            srcFolder = FileUtil.createFolder((FileObject)srcFolder, (String)CndPathUtilitities.getDirName((String)mainName));
            createdMainName = CndPathUtilitities.getBaseName((String)absPath);
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        DataFolder pDf = DataFolder.findFolder((FileObject)srcFolder);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("freeFileExtension", true);
        params.putAll(templateParams);
        mt.createFromTemplate(pDf, createdMainName, params);
        return mainName;
    }
}

