/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.indexing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.spi.AstNodeVisitor;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.html.editor.indexing.HtmlLinkEntry;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class HtmlFileModel {
    private static final String STYLE_TAG_NAME = "style";
    private static final Logger LOGGER = Logger.getLogger(HtmlFileModel.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private List<HtmlLinkEntry> references;
    private List<OffsetRange> embeddedCssSections;
    private HtmlParserResult parserResult;

    public HtmlFileModel(Source source) throws ParseException {
        ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                if (ri != null) {
                    HtmlFileModel.this.parserResult = (HtmlParserResult)ri.getParserResult();
                    HtmlFileModel.this.init();
                }
            }
        });
    }

    public HtmlFileModel(HtmlParserResult parserResult) {
        this.parserResult = parserResult;
        this.init();
    }

    public HtmlParserResult getParserResult() {
        return this.parserResult;
    }

    public Snapshot getSnapshot() {
        return this.parserResult.getSnapshot();
    }

    public FileObject getFileObject() {
        return this.getSnapshot().getSource().getFileObject();
    }

    public List<HtmlLinkEntry> getReferences() {
        return this.references == null ? Collections.emptyList() : this.references;
    }

    public List<OffsetRange> getEmbeddedCssSections() {
        return this.embeddedCssSections == null ? Collections.emptyList() : this.embeddedCssSections;
    }

    public boolean isEmpty() {
        return null == this.references;
    }

    private List<HtmlLinkEntry> getReferencesCollectionInstance() {
        if (this.references == null) {
            this.references = new ArrayList<HtmlLinkEntry>();
        }
        return this.references;
    }

    private List<OffsetRange> getEmbeddedCssSectionsCollectionInstance() {
        if (this.embeddedCssSections == null) {
            this.embeddedCssSections = new ArrayList<OffsetRange>();
        }
        return this.embeddedCssSections;
    }

    private void init() {
        AstNode root = this.parserResult.root();
        if (root != null) {
            AstNodeUtils.visitChildren((AstNode)root, (AstNodeVisitor)new ReferencesSearch(), (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(":");
        for (HtmlLinkEntry c : this.getReferences()) {
            buf.append(" references=");
            buf.append(c);
            buf.append(',');
        }
        return buf.toString();
    }

    private HtmlLinkEntry createFileReferenceEntry(String name, OffsetRange range, String tagName, String attributeName) {
        int qmIndex = name.indexOf("?");
        if (qmIndex >= 0) {
            range = new OffsetRange(range.getStart(), range.getEnd() - (name.length() - qmIndex));
            name = name.substring(0, qmIndex);
        }
        int documentFrom = this.getSnapshot().getOriginalOffset(range.getStart());
        int documentTo = this.getSnapshot().getOriginalOffset(range.getEnd());
        OffsetRange documentRange = null;
        if (documentFrom == -1 || documentTo == -1) {
            if (LOG) {
                LOGGER.log(Level.FINER, "Ast offset range {0}, text=''{1}'',  cannot be properly mapped to source offset range: [{2},{3}] in file {4}", new Object[]{range.toString(), this.getSnapshot().getText().subSequence(range.getStart(), range.getEnd()), documentFrom, documentTo, this.getFileObject().getPath()});
            }
        } else {
            documentRange = new OffsetRange(documentFrom, documentTo);
        }
        return new HtmlLinkEntry(this.getFileObject(), name, range, documentRange, tagName, attributeName);
    }

    public class ReferencesSearch
    implements AstNodeVisitor {
        public void visit(AstNode node) {
            Map<String, ValueCompletion<HtmlCompletionItem>> completions = AttrValuesCompletion.getSupportsForTag(node.name());
            if (completions != null) {
                for (AstNode.Attribute attr : node.getAttributes()) {
                    ValueCompletion<HtmlCompletionItem> avc = completions.get(attr.name());
                    if (AttrValuesCompletion.FILE_NAME_SUPPORT != avc) continue;
                    HtmlFileModel.this.getReferencesCollectionInstance().add(HtmlFileModel.this.createFileReferenceEntry(attr.unquotedValue(), new OffsetRange(attr.unqotedValueOffset(), attr.unqotedValueOffset() + attr.unquotedValue().length()), node.name(), attr.name()));
                }
            }
            if (HtmlFileModel.STYLE_TAG_NAME.equalsIgnoreCase(node.name()) && !node.isEmpty()) {
                int from = node.endOffset();
                if (from != -1) {
                    AstNode closeTag = node.getMatchingTag();
                    if (closeTag != null) {
                        int to = closeTag.startOffset();
                        HtmlFileModel.this.getEmbeddedCssSectionsCollectionInstance().add(new OffsetRange(from, to));
                    }
                } else {
                    LOGGER.log(Level.INFO, "The end offset of the node {0} is not set! Please report the exception and attach the {1} to the issue.", new Object[]{node.path().toString(), FileUtil.getFileDisplayName((FileObject)HtmlFileModel.this.getFileObject())});
                }
            }
        }
    }
}

