/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints;

import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.HtmlValidatorRule;
import org.openide.util.NbBundle;

public abstract class PatternRule
extends HtmlValidatorRule {
    private static final String ERROR_MGS_PATTERN_PREFIX = "[^:]*:\\s";
    private static final String ERROR_MGS_PATTERN_POSTFIX = ".*";

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>");
        sb.append(super.getDescription());
        sb.append("</b>");
        sb.append("<br><br>");
        sb.append(NbBundle.getMessage(PatternRule.class, (String)"MSG_PatterRuleDesc"));
        sb.append("<br>");
        sb.append("<ul>");
        for (Pattern p : this.getPatterns()) {
            sb.append("<li>");
            sb.append(p.pattern());
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public abstract Pattern[] getPatterns();

    @Override
    protected final boolean appliesTo(HtmlRuleContext content, Error e) {
        String msg = e.getDescription();
        for (Pattern p : this.getPatterns()) {
            if (!p.matcher(msg).matches()) continue;
            return true;
        }
        return false;
    }

    protected static Pattern[] buildPatterns(String[] sources) {
        Pattern[] patterns = new Pattern[sources.length];
        for (int i = 0; i < patterns.length; ++i) {
            String src = ERROR_MGS_PATTERN_PREFIX + sources[i] + ERROR_MGS_PATTERN_POSTFIX;
            patterns[i] = Pattern.compile(src, 32);
        }
        return patterns;
    }
}

