/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.PatternSet;
import org.apache.webdav.ant.CollectionScanner;
import org.apache.webdav.ant.Utils;

public class WebdavFileSet {
    private PatternSet patterns = new PatternSet();
    private List patternSets = new ArrayList();
    private String directory = null;
    private boolean isCaseSensitive = true;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};

    public CollectionScanner getCollectionScanner(Project project, HttpClient httpClient, HttpURL baseUrl) {
        this.validate();
        CollectionScanner scanner = new CollectionScanner();
        try {
            scanner.setBaseURL(Utils.createHttpURL(baseUrl, this.directory));
        }
        catch (URIException e) {
            throw new BuildException("Invalid URL. " + e.toString(), (Throwable)e);
        }
        scanner.setHttpClient(httpClient);
        scanner.setCaseSensitive(this.isCaseSensitive);
        if (this.patterns.getExcludePatterns(project) == null && this.patterns.getIncludePatterns(project) == null && this.patternSets.size() == 0) {
            scanner.setIncludes(DEFAULT_INCLUDES);
        } else {
            scanner.setExcludes(this.patterns.getExcludePatterns(project));
            scanner.setIncludes(this.patterns.getIncludePatterns(project));
            Iterator i = this.patternSets.iterator();
            while (i.hasNext()) {
                PatternSet patternSet = (PatternSet)i.next();
                scanner.addExcludes(patternSet.getExcludePatterns(project));
                scanner.addIncludes(patternSet.getIncludePatterns(project));
            }
        }
        scanner.scan();
        return scanner;
    }

    protected void validate() {
        if (this.directory == null) {
            this.directory = "";
        }
    }

    public void setDir(String dir) {
        this.directory = dir;
        if (!this.directory.endsWith("/")) {
            this.directory = this.directory + "/";
        }
        if (this.directory.startsWith("/")) {
            this.directory = this.directory.substring(1);
        }
    }

    public void setCasesensitive(boolean b) {
        this.isCaseSensitive = b;
    }

    public PatternSet.NameEntry createInclude() {
        return this.patterns.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        return this.patterns.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        return this.patterns.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        return this.patterns.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        PatternSet patterns = new PatternSet();
        this.patternSets.add(patterns);
        return patterns;
    }
}

