/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class BoxFillerInitializer {
    private RADComponent metaComp;
    private String initializerId;

    public BoxFillerInitializer(RADComponent metaComp, String initializerId) {
        this.metaComp = metaComp;
        this.initializerId = initializerId;
    }

    public void initialize() {
        this.metaComp.setAuxValue("classDetails", this.initializerId);
        boolean dialogOKClosed = true;
        if ("Box.Filler.Glue".equals(this.initializerId)) {
            this.setProperty("maximumSize", new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        } else if ("Box.Filler.HorizontalGlue".equals(this.initializerId)) {
            this.setProperty("maximumSize", new Dimension(Short.MAX_VALUE, 0));
        } else if ("Box.Filler.VerticalGlue".equals(this.initializerId)) {
            this.setProperty("maximumSize", new Dimension(0, Short.MAX_VALUE));
        } else if ("Box.Filler.HorizontalStrut".equals(this.initializerId)) {
            WidthHeightPanel panel = new WidthHeightPanel(true, false);
            dialogOKClosed = this.showDialog(panel, "BoxFillerInitializer.HorizontalStrut");
            int width = panel.getFillerWidth();
            this.setProperty("minimumSize", new Dimension(width, 0));
            this.setProperty("preferredSize", new Dimension(width, 0));
            this.setProperty("maximumSize", new Dimension(width, Short.MAX_VALUE));
        } else if ("Box.Filler.VerticalStrut".equals(this.initializerId)) {
            WidthHeightPanel panel = new WidthHeightPanel(false, true);
            dialogOKClosed = this.showDialog(panel, "BoxFillerInitializer.VerticalStrut");
            int height = panel.getFillerHeight();
            this.setProperty("minimumSize", new Dimension(0, height));
            this.setProperty("preferredSize", new Dimension(0, height));
            this.setProperty("maximumSize", new Dimension(Short.MAX_VALUE, height));
        } else if ("Box.Filler.RigidArea".equals(this.initializerId)) {
            WidthHeightPanel panel = new WidthHeightPanel(true, true);
            dialogOKClosed = this.showDialog(panel, "BoxFillerInitializer.RigidArea");
            int width = panel.getFillerWidth();
            int height = panel.getFillerHeight();
            this.setProperty("minimumSize", new Dimension(width, height));
            this.setProperty("preferredSize", new Dimension(width, height));
            this.setProperty("maximumSize", new Dimension(width, height));
        }
        if (!dialogOKClosed) {
            if (this.metaComp.isInModel()) {
                this.metaComp.getFormModel().removeComponent(this.metaComp, true);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PaletteUtils.clearPaletteSelection();
                    }
                });
            }
        }
    }

    private boolean showDialog(WidthHeightPanel panel, String titleKey) {
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(BoxFillerInitializer.class, (String)titleKey), true, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        return dd.getValue() == DialogDescriptor.OK_OPTION;
    }

    private void setProperty(String propName, Dimension value) {
        try {
            Node.Property prop = this.metaComp.getPropertyByName(propName);
            prop.setValue((Object)value);
        }
        catch (IllegalAccessException iaex) {
            Logger.getLogger(BoxFillerInitializer.class.getName()).log(Level.INFO, iaex.getMessage(), iaex);
        }
        catch (InvocationTargetException itex) {
            Logger.getLogger(BoxFillerInitializer.class.getName()).log(Level.INFO, itex.getMessage(), itex);
        }
    }

    private class WidthHeightPanel
    extends JPanel {
        private JSpinner widthField;
        private JSpinner heightField;

        WidthHeightPanel(boolean showWidth, boolean showHeight) {
            ResourceBundle bundle = NbBundle.getBundle(BoxFillerInitializer.class);
            JLabel widthLabel = new JLabel(bundle.getString("BoxFillerInitializer.width"));
            JLabel heightLabel = new JLabel(bundle.getString("BoxFillerInitializer.height"));
            this.widthField = new JSpinner(new SpinnerNumberModel());
            this.heightField = new JSpinner(new SpinnerNumberModel());
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(widthLabel).addComponent(heightLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthField).addComponent(this.heightField)).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(widthLabel).addComponent(this.widthField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(heightLabel).addComponent(this.heightField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
            widthLabel.setVisible(showWidth);
            heightLabel.setVisible(showHeight);
            this.widthField.setVisible(showWidth);
            this.heightField.setVisible(showHeight);
        }

        int getFillerWidth() {
            return (Integer)this.widthField.getValue();
        }

        int getFillerHeight() {
            return (Integer)this.heightField.getValue();
        }
    }
}

