/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.swing.JLayeredPane;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.delegates.AbsoluteLayoutSupport;
import org.openide.nodes.Node;

public class JLayeredPaneSupport
extends AbsoluteLayoutSupport {
    private static Method setBoundsMethod;

    @Override
    public Class getSupportedClass() {
        return JLayeredPane.class;
    }

    @Override
    public void convertConstraints(LayoutConstraints[] previousConstraints, LayoutConstraints[] currentConstraints, Component[] components) {
    }

    @Override
    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        if (!(container instanceof JLayeredPane)) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            LayoutConstraints constraints = this.getConstraints(i + index);
            if (!(constraints instanceof LayeredConstraints)) continue;
            Component comp = components[i];
            container.add(comp, constraints.getConstraintsObject(), i + index);
            Rectangle bounds = ((LayeredConstraints)constraints).getBounds();
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension pref = comp.getPreferredSize();
                if (bounds.width == -1) {
                    bounds.width = pref.width;
                }
                if (bounds.height == -1) {
                    bounds.height = pref.height;
                }
            }
            comp.setBounds(bounds);
        }
    }

    @Override
    protected LayoutConstraints readConstraintsCode(CodeExpression constrExp, CodeGroup constrCode, CodeExpression compExp) {
        LayeredConstraints constr = new LayeredConstraints(0, 0, 0, -1, -1);
        Iterator it = CodeStructure.getDefinedStatementsIterator(compExp);
        CodeStatement[] statements = CodeStructure.filterStatements(it, JLayeredPaneSupport.getSetBoundsMethod());
        if (statements.length > 0) {
            CodeStatement boundsStatement = statements[statements.length - 1];
            constr.readPropertyExpressions(boundsStatement.getStatementParameters(), 1);
            constrCode.addStatement(boundsStatement);
        }
        FormCodeSupport.readPropertyExpression(constrExp, constr.getProperties()[0], false);
        return constr;
    }

    @Override
    protected CodeExpression createConstraintsCode(CodeGroup constrCode, LayoutConstraints constr, CodeExpression compExp, int index) {
        if (!(constr instanceof LayeredConstraints)) {
            return null;
        }
        LayeredConstraints layerConstr = (LayeredConstraints)constr;
        layerConstr.refComponent = this.getLayoutContext().getPrimaryComponent(index);
        CodeStructure codeStructure = this.getCodeStructure();
        CodeStatement boundsStatement = CodeStructure.createStatement(compExp, JLayeredPaneSupport.getSetBoundsMethod(), layerConstr.createPropertyExpressions(codeStructure, 1));
        constrCode.addStatement(boundsStatement);
        return codeStructure.createExpression(FormCodeSupport.createOrigin(layerConstr.getProperties()[0]));
    }

    @Override
    protected LayoutConstraints createDefaultConstraints() {
        return new LayeredConstraints(0, 0, 0, -1, -1);
    }

    @Override
    public CodeGroup getComponentCode(int index) {
        LayoutConstraints constr = this.getConstraints(index);
        if (constr instanceof AbsoluteLayoutSupport.AbsoluteLayoutConstraints) {
            AbsoluteLayoutSupport.AbsoluteLayoutConstraints absConstr = (AbsoluteLayoutSupport.AbsoluteLayoutConstraints)constr;
            if (absConstr.refComponent == null) {
                absConstr.refComponent = this.getLayoutContext().getPrimaryComponent(index);
            }
        }
        return super.getComponentCode(index);
    }

    @Override
    protected LayoutConstraints createNewConstraints(LayoutConstraints currentConstr, int x, int y, int w, int h) {
        int layer = currentConstr instanceof LayeredConstraints ? ((LayeredConstraints)currentConstr).getLayer() : 0;
        return new LayeredConstraints(layer, x, y, w, h);
    }

    private static Method getSetBoundsMethod() {
        if (setBoundsMethod == null) {
            try {
                setBoundsMethod = Component.class.getMethod("setBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return setBoundsMethod;
    }

    public static final class LayerEditor
    extends PropertyEditorSupport {
        final String[] tags = new String[]{"DEFAULT_LAYER", "PALETTE_LAYER", "MODAL_LAYER", "POPUP_LAYER", "DRAG_LAYER"};
        final Integer[] values = new Integer[]{JLayeredPane.DEFAULT_LAYER, JLayeredPane.PALETTE_LAYER, JLayeredPane.MODAL_LAYER, JLayeredPane.POPUP_LAYER, JLayeredPane.DRAG_LAYER};
        final String[] javaInitStrings = new String[]{"javax.swing.JLayeredPane.DEFAULT_LAYER", "javax.swing.JLayeredPane.PALETTE_LAYER", "javax.swing.JLayeredPane.MODAL_LAYER", "javax.swing.JLayeredPane.POPUP_LAYER", "javax.swing.JLayeredPane.DRAG_LAYER"};

        @Override
        public String[] getTags() {
            return this.tags;
        }

        @Override
        public String getAsText() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.tags[i];
            }
            return value.toString();
        }

        @Override
        public void setAsText(String str) {
            for (int i = 0; i < this.tags.length; ++i) {
                if (!this.tags[i].equals(str)) continue;
                this.setValue(this.values[i]);
                return;
            }
            try {
                this.setValue(new Integer(Integer.parseInt(str)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        public String getJavaInitializationString() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.javaInitStrings[i];
            }
            return value != null ? "new Integer(" + value.toString() + ")" : null;
        }
    }

    public static class LayeredConstraints
    extends AbsoluteLayoutSupport.AbsoluteLayoutConstraints {
        private int layer;

        public LayeredConstraints(int layer, int x, int y, int w, int h) {
            super(x, y, w, h);
            this.layer = layer;
            this.nullMode = true;
        }

        public int getLayer() {
            return this.layer;
        }

        @Override
        public Object getConstraintsObject() {
            return new Integer(this.layer);
        }

        @Override
        public LayoutConstraints cloneConstraints() {
            return new LayeredConstraints(this.layer, this.x, this.y, this.w, this.h);
        }

        @Override
        protected Node.Property[] createProperties() {
            Node.Property[] props = super.createProperties();
            Node.Property[] layeredProps = new Node.Property[props.length + 1];
            layeredProps[0] = new FormProperty("LayeredConstraints layer", Integer.TYPE, JLayeredPaneSupport.getBundle().getString("PROP_layer"), JLayeredPaneSupport.getBundle().getString("HINT_layer")){

                @Override
                public Object getTargetValue() {
                    return new Integer(LayeredConstraints.this.layer);
                }

                @Override
                public void setTargetValue(Object value) {
                    LayeredConstraints.this.layer = (Integer)value;
                }

                @Override
                public boolean supportsDefaultValue() {
                    return true;
                }

                @Override
                public Object getDefaultValue() {
                    return new Integer(0);
                }

                @Override
                public PropertyEditor getExpliciteEditor() {
                    return new LayerEditor();
                }

                public Object getValue(String key) {
                    if ("canEditAsText".equals(key)) {
                        return Boolean.TRUE;
                    }
                    return super.getValue(key);
                }

                @Override
                public void setPropertyContext(FormPropertyContext ctx) {
                }
            };
            System.arraycopy(props, 0, layeredProps, 1, props.length);
            return layeredProps;
        }
    }
}

