/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

public class RADVisualComponent
extends RADComponent {
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE = "layoutComponentHorizontalSize";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_SIZE = "layoutComponentVerticalSize";
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE = "layoutComponentHorizontalResizable";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE = "layoutComponentVerticalResizable";
    private Map<String, LayoutConstraints> constraints = new HashMap<String, LayoutConstraints>();
    private Node.Property[] constraintsProperties;
    private ConstraintsListenerConvertor constraintsListener;

    public final RADVisualContainer getParentContainer() {
        return (RADVisualContainer)this.getParentComponent();
    }

    public final int getComponentIndex() {
        RADVisualContainer parent = (RADVisualContainer)this.getParentComponent();
        return parent != null ? parent.getIndexOf(this) : -1;
    }

    final LayoutSupportManager getParentLayoutSupport() {
        RADVisualContainer parent = (RADVisualContainer)this.getParentComponent();
        return parent != null ? parent.getLayoutSupport() : null;
    }

    boolean isMenuTypeComponent() {
        return MenuElement.class.isAssignableFrom(this.getBeanClass());
    }

    public boolean isMenuComponent() {
        RADVisualContainer parent;
        return this.isMenuTypeComponent() && ((parent = this.getParentContainer()) == null && !this.isInModel() || parent != null && (parent.isMenuTypeComponent() || this == parent.getContainerMenu()));
    }

    static MenuType getMenuType(Class cl) {
        if (MenuElement.class.isAssignableFrom(cl)) {
            if (JMenu.class.isAssignableFrom(cl)) {
                return MenuType.JMenu;
            }
            if (JMenuBar.class.isAssignableFrom(cl)) {
                return MenuType.JMenuBar;
            }
            if (JCheckBoxMenuItem.class.isAssignableFrom(cl)) {
                return MenuType.JCheckBoxMenuItem;
            }
            if (JRadioButtonMenuItem.class.isAssignableFrom(cl)) {
                return MenuType.JRadioButtonMenuItem;
            }
            if (JMenuItem.class.isAssignableFrom(cl)) {
                return MenuType.JMenuItem;
            }
            if (JPopupMenu.class.isAssignableFrom(cl)) {
                return MenuType.JPopupMenu;
            }
        } else if (JSeparator.class.isAssignableFrom(cl)) {
            return MenuType.JSeparator;
        }
        return null;
    }

    public void setLayoutConstraints(Class layoutDelegateClass, LayoutConstraints constr) {
        if (constr != null) {
            this.constraints.put(layoutDelegateClass.getName(), constr);
        }
    }

    public LayoutConstraints getLayoutConstraints(Class layoutDelegateClass) {
        return this.constraints.get(layoutDelegateClass.getName());
    }

    Map<String, LayoutConstraints> getConstraintsMap() {
        return this.constraints;
    }

    void setConstraintsMap(Map<String, LayoutConstraints> map) {
        this.constraints.putAll(map);
    }

    @Override
    protected synchronized void createPropertySets(List<Node.PropertySet> propSets) {
        super.createPropertySets(propSets);
        if (SUPPRESS_PROPERTY_TABS) {
            return;
        }
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        if (this.constraintsProperties != null && this.constraintsProperties.length > 0) {
            propSets.add(propSets.size() - 1, new Node.PropertySet("layout", FormUtils.getBundleString("CTL_LayoutTab"), FormUtils.getBundleString("CTL_LayoutTabHint")){

                public Node.Property[] getProperties() {
                    Node.Property[] props = RADVisualComponent.this.getConstraintsProperties();
                    return props == null ? RADComponent.NO_PROPERTIES : props;
                }
            });
        }
    }

    @Override
    protected synchronized void clearProperties() {
        super.clearProperties();
        this.constraintsProperties = null;
    }

    public synchronized Node.Property[] getConstraintsProperties() {
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        return this.constraintsProperties;
    }

    public synchronized void resetConstraintsProperties() {
        if (this.constraintsProperties != null) {
            for (int i = 0; i < this.constraintsProperties.length; ++i) {
                this.nameToProperty.remove(this.constraintsProperties[i].getName());
            }
            this.constraintsProperties = null;
            this.propertySets = null;
            RADComponentNode node = this.getNodeReference();
            if (node != null) {
                node.fireComponentPropertySetsChange();
            }
        }
    }

    private synchronized void createConstraintsProperties() {
        this.constraintsProperties = null;
        LayoutSupportManager layoutSupport = this.getParentLayoutSupport();
        if (layoutSupport != null) {
            LayoutConstraints constr;
            if (this.getParentContainer().isLayoutSubcomponent(this) && (constr = layoutSupport.getConstraints(this)) != null) {
                this.constraintsProperties = constr.getProperties();
            }
        } else if (this.getParentContainer() != null) {
            LayoutComponent component = this.getFormModel().getLayoutModel().getLayoutComponent(this.getId());
            if (component == null) {
                return;
            }
            this.constraintsProperties = new Node.Property[]{new LayoutComponentSizeProperty(component, 0), new LayoutComponentSizeProperty(component, 1), new LayoutComponentResizableProperty(component, 0), new LayoutComponentResizableProperty(component, 1)};
            component.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    RADComponentNode node = RADVisualComponent.this.getNodeReference();
                    if (node != null) {
                        String propName = evt.getPropertyName();
                        if ("horizontalPrefSize".equals(propName)) {
                            node.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE, null, null);
                        } else if ("verticalPrefSize".equals(propName)) {
                            node.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, null, null);
                        } else if ("horizontalMaxSize".equals(propName)) {
                            node.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE, null, null);
                        } else if ("verticalMaxSize".equals(propName)) {
                            node.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE, null, null);
                        }
                    }
                }
            });
        }
        if (this.constraintsProperties == null) {
            this.constraintsProperties = NO_PROPERTIES;
            return;
        }
        for (int i = 0; i < this.constraintsProperties.length; ++i) {
            if (!(this.constraintsProperties[i] instanceof FormProperty)) continue;
            FormProperty prop = (FormProperty)this.constraintsProperties[i];
            prop.addVetoableChangeListener(this.getConstraintsListener());
            prop.addPropertyChangeListener(this.getConstraintsListener());
            prop.addValueConvertor(this.getConstraintsListener());
            prop.setPropertyContext(new FormPropertyContext.Component(this));
            if (this.isReadOnly() || !this.isValid()) {
                int type = prop.getAccessType() | 0xA;
                prop.setAccessType(type);
            }
            this.nameToProperty.put(prop.getName(), prop);
        }
    }

    private ConstraintsListenerConvertor getConstraintsListener() {
        if (this.constraintsListener == null) {
            this.constraintsListener = new ConstraintsListenerConvertor();
        }
        return this.constraintsListener;
    }

    private class LayoutComponentResizableProperty
    extends PropertySupport.ReadWrite {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentResizableProperty(LayoutComponent component, int dimension) {
            super(dimension == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE, Boolean.class, null, null);
            boolean horizontal = dimension == 0;
            this.setDisplayName(FormUtils.getBundleString(horizontal ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.setShortDescription(FormUtils.getBundleString(horizontal ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "HINT_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.component = component;
            this.dimension = dimension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            Boolean oldValue = (Boolean)this.getValue();
            Boolean newValue = (Boolean)value;
            boolean resizable = newValue;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval interval = this.component.getLayoutInterval(this.dimension);
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                layoutModel.setIntervalSize(interval, resizable ? -1 : -2, interval.getPreferredSize(false), resizable ? Short.MAX_VALUE : -2);
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), oldValue, newValue);
                autoUndo = false;
            }
            finally {
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(ue);
                }
                if (autoUndo) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
            }
        }

        public Object getValue() {
            int pref = this.component.getLayoutInterval(this.dimension).getPreferredSize(false);
            int max = this.component.getLayoutInterval(this.dimension).getMaximumSize(false);
            return max != pref && max != -2;
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            this.setValue(Boolean.FALSE);
        }

        public boolean isDefaultValue() {
            return this.getValue().equals(Boolean.FALSE);
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }

    private class LayoutComponentSizeProperty
    extends PropertySupport.ReadWrite {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentSizeProperty(LayoutComponent component, int dimension) {
            super(dimension == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, Integer.class, null, null);
            boolean horizontal = dimension == 0;
            this.setDisplayName(FormUtils.getBundleString(horizontal ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "PROP_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.setShortDescription(FormUtils.getBundleString(horizontal ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "HINT_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.component = component;
            this.dimension = dimension;
            this.setValue("canEditAsText", Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer oldValue = (Integer)this.getValue();
            Integer newValue = (Integer)value;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval interval = this.component.getLayoutInterval(this.dimension);
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                layoutModel.setIntervalSize(interval, interval.getMinimumSize(false), newValue, interval.getMaximumSize(false));
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), oldValue, newValue);
                autoUndo = false;
            }
            finally {
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(ue);
                }
                if (autoUndo) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
            }
        }

        public Object getValue() {
            int size = this.component.getLayoutInterval(this.dimension).getPreferredSize(false);
            return new Integer(size);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            this.setValue(new Integer(-1));
        }

        public boolean isDefaultValue() {
            return (Integer)this.getValue() == -1;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport(){
                private String notExplicitelyDefined = FormUtils.getBundleString("VALUE_SizeNotExplicitelyDefined");

                @Override
                public String[] getTags() {
                    return new String[]{this.notExplicitelyDefined};
                }

                @Override
                public String getAsText() {
                    Integer value = (Integer)this.getValue();
                    if (value == -1) {
                        return this.notExplicitelyDefined;
                    }
                    return value.toString();
                }

                @Override
                public void setAsText(String str) {
                    if (this.notExplicitelyDefined.equals(str)) {
                        this.setValue(new Integer(-1));
                    } else {
                        try {
                            int size = Integer.parseInt(str);
                            if (size < 0) {
                                throw new IllegalArgumentException();
                            }
                            this.setValue(size);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException();
                        }
                    }
                }
            };
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }

    public static class AccessibleParentEditor
    extends ComponentChooserEditor {
        public AccessibleParentEditor() {
            this.setBeanTypes(new Class[]{Accessible.class});
        }
    }

    private class ConstraintsListenerConvertor
    implements VetoableChangeListener,
    PropertyChangeListener,
    FormProperty.ValueConvertor {
        private ConstraintsListenerConvertor() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            Object source = ev.getSource();
            String eventName = ev.getPropertyName();
            if (source instanceof FormProperty && ("propertyValue".equals(eventName) || "propertyValueAndEditor".equals(eventName))) {
                RADVisualComponent.this.resourcePropertyChanged(ev);
                LayoutSupportManager layoutSupport = RADVisualComponent.this.getParentLayoutSupport();
                int index = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints constraints = layoutSupport.getConstraints(index);
                ev = new PropertyChangeEvent(constraints, ((FormProperty)((Object)source)).getName(), ev.getOldValue(), ev.getNewValue());
                layoutSupport.componentLayoutChanged(index, ev);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            Object source = ev.getSource();
            if (source instanceof FormProperty && "currentEditor".equals(ev.getPropertyName())) {
                LayoutSupportManager layoutSupport = RADVisualComponent.this.getParentLayoutSupport();
                int index = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints constraints = layoutSupport.getConstraints(index);
                ev = new PropertyChangeEvent(constraints, null, null, null);
                try {
                    layoutSupport.componentLayoutChanged(index, ev);
                }
                catch (PropertyVetoException ex) {
                    // empty catch block
                }
            }
        }

        @Override
        public Object convert(Object value, FormProperty property) {
            return RADVisualComponent.this.resourcePropertyConvert(value, property);
        }
    }

    static enum MenuType {
        JMenuItem,
        JCheckBoxMenuItem,
        JRadioButtonMenuItem,
        JMenu,
        JMenuBar,
        JPopupMenu,
        JSeparator;

    }
}

