/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.applet;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AppletSupport {
    private static final SpecificationVersion JDK_15 = new SpecificationVersion("1.5");
    private static final String HTML_EXT = "html";
    private static final String CLASS_EXT = "class";
    private static final String POLICY_FILE_NAME = "applet";
    private static final String POLICY_FILE_EXT = "policy";
    public static Boolean unitTestingSupport_isApplet = null;

    private AppletSupport() {
    }

    public static boolean isApplet(FileObject file) {
        if (file == null) {
            return false;
        }
        if (unitTestingSupport_isApplet != null) {
            return unitTestingSupport_isApplet;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            return false;
        }
        final boolean[] result = new boolean[]{false};
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController control) throws Exception {
                    if (JavaSource.Phase.ELEMENTS_RESOLVED.compareTo((Enum)control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED)) <= 0) {
                        Elements elements = control.getElements();
                        Trees trees = control.getTrees();
                        Types types = control.getTypes();
                        TypeElement applet = elements.getTypeElement("java.applet.Applet");
                        TypeElement japplet = elements.getTypeElement("javax.swing.JApplet");
                        CompilationUnitTree cu = control.getCompilationUnit();
                        List<? extends Tree> topLevels = cu.getTypeDecls();
                        for (Tree tree : topLevels) {
                            Set<Modifier> modifiers;
                            TypeElement type;
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || (type = (TypeElement)trees.getElement(TreePath.getPath(cu, tree))) == null || !(modifiers = type.getModifiers()).contains((Object)Modifier.PUBLIC) || (applet == null || !types.isSubtype(type.asType(), applet.asType())) && (japplet == null || !types.isSubtype(type.asType(), japplet.asType()))) continue;
                            result[0] = true;
                            break;
                        }
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject generateHtml(FileObject appletFile, FileObject buildDir, FileObject classesDir) throws IOException {
        FileObject htmlFile = buildDir.getFileObject(appletFile.getName(), HTML_EXT);
        if (htmlFile == null) {
            htmlFile = buildDir.createData(appletFile.getName(), HTML_EXT);
        }
        FileLock lock = htmlFile.lock();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(htmlFile.getOutputStream(lock));
            ClassPath cp = ClassPath.getClassPath((FileObject)appletFile, (String)"classpath/execute");
            ClassPath sp = ClassPath.getClassPath((FileObject)appletFile, (String)"classpath/source");
            String path = FileUtil.getRelativePath((FileObject)sp.findOwnerRoot(appletFile), (FileObject)appletFile);
            path = path.substring(0, path.length() - 5);
            String codebase = FileUtil.getRelativePath((FileObject)buildDir, (FileObject)classesDir);
            if (codebase == null) {
                codebase = classesDir.getURL().toString();
            }
            AppletSupport.fillInFile(writer, path + "." + CLASS_EXT, "codebase=\"" + codebase + "\"");
        }
        finally {
            lock.releaseLock();
            if (writer != null) {
                writer.close();
            }
        }
        return htmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateSecurityPolicy(FileObject projectDir) {
        FileObject policyFile = projectDir.getFileObject(POLICY_FILE_NAME, POLICY_FILE_EXT);
        try {
            if (policyFile == null) {
                policyFile = projectDir.createData(POLICY_FILE_NAME, POLICY_FILE_EXT);
            }
            FileLock lock = policyFile.lock();
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(policyFile.getOutputStream(lock));
                AppletSupport.fillInPolicyFile(writer);
            }
            finally {
                lock.releaseLock();
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().log(1, "Problem when generating applet policy file: " + ioe);
        }
        return policyFile;
    }

    public static URL generateHtmlFileURL(FileObject appletFile, FileObject buildDir, FileObject classesDir, String activePlatform) throws FileStateInvalidException {
        FileObject html = null;
        Object ex = null;
        if (appletFile == null || buildDir == null || classesDir == null) {
            return null;
        }
        try {
            html = AppletSupport.generateHtml(appletFile, buildDir, classesDir);
            if (html != null) {
                return AppletSupport.getHTMLPageURL(html, activePlatform);
            }
            return null;
        }
        catch (IOException iex) {
            return null;
        }
    }

    public static URL getHTMLPageURL(FileObject htmlFile, String activePlatform) {
        assert (htmlFile != null) : "htmlFile cannot be null";
        JavaPlatform platform = CommonProjectUtils.getActivePlatform(activePlatform);
        boolean workAround6193279 = platform != null && platform.getSpecification().getVersion().compareTo((Object)JDK_15) >= 0;
        URL url = null;
        if (workAround6193279) {
            File f = FileUtil.toFile((FileObject)htmlFile);
            try {
                String path = f.getAbsolutePath();
                if (File.separatorChar != '/') {
                    path = path.replace(File.separatorChar, '/');
                }
                url = new URL("file", null, path);
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            try {
                url = htmlFile.getURL();
            }
            catch (FileStateInvalidException f) {
                ErrorManager.getDefault().notify((Throwable)f);
            }
        }
        return url;
    }

    private static void fillInFile(PrintWriter writer, String name, String codebase) {
        ResourceBundle bundle = NbBundle.getBundle(AppletSupport.class);
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.print("   <TITLE>");
        writer.print(bundle.getString("GEN_title"));
        writer.println("</TITLE>");
        writer.println("</HEAD>");
        writer.println("<BODY>\n");
        writer.print(bundle.getString("GEN_warning"));
        writer.print("<H3><HR WIDTH=\"100%\">");
        writer.print(bundle.getString("GEN_header"));
        writer.println("<HR WIDTH=\"100%\"></H3>\n");
        writer.println("<P>");
        if (codebase == null) {
            writer.print("<APPLET code=");
        } else {
            writer.print("<APPLET " + codebase + " code=");
        }
        writer.print("\"");
        writer.print(name);
        writer.print("\"");
        writer.println(" width=350 height=200></APPLET>");
        writer.println("</P>\n");
        writer.print("<HR WIDTH=\"100%\"><FONT SIZE=-1><I>");
        writer.print(bundle.getString("GEN_copy"));
        writer.println("</I></FONT>");
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.flush();
    }

    private static void fillInPolicyFile(PrintWriter writer) {
        writer.println("grant {");
        writer.println("permission java.security.AllPermission;");
        writer.println("};");
        writer.flush();
    }
}

