/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;

public abstract class RemoteFileObjectFile
extends RemoteFileObjectBase {
    private ThreadLocal<Boolean> magic = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    protected RemoteFileObjectFile(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, File cache) {
        super(fileSystem, execEnv, parent, remotePath, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMIMEType() {
        this.magic.set(Boolean.TRUE);
        try {
            String string = super.getMIMEType();
            return string;
        }
        finally {
            this.magic.set(Boolean.FALSE);
        }
    }

    protected boolean isMimeResolving() {
        if (this.magic.get().booleanValue()) {
            return true;
        }
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if ((!"org.openide.filesystems.MIMESupport".equals(element.getClassName()) || !"findMIMEType".equals(element.getMethodName())) && (!"org.openide.loaders.DefaultDataObject".equals(element.getClassName()) || !"fixCookieSet".equals(element.getMethodName()))) continue;
            return true;
        }
        return false;
    }

    protected byte[] getMagic() {
        try {
            RemoteDirectory parent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (parent != null) {
                return parent.getMagic(this);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

