/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.fold;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.editor.fold.GsfFoldScheduler;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.filesystems.FileObject;

public class GsfFoldManager
implements FoldManager {
    private static final Logger LOG = Logger.getLogger(GsfFoldManager.class.getName());
    public static final FoldType CODE_BLOCK_FOLD_TYPE = new FoldType("code-block");
    public static final FoldType INITIAL_COMMENT_FOLD_TYPE = new FoldType("initial-comment");
    public static final FoldType IMPORTS_FOLD_TYPE = new FoldType("imports");
    public static final FoldType JAVADOC_FOLD_TYPE = new FoldType("javadoc");
    public static final FoldType TAG_FOLD_TYPE = new FoldType("tag");
    private static final String IMPORTS_FOLD_DESCRIPTION = "...";
    private static final String COMMENT_FOLD_DESCRIPTION = "...";
    private static final String JAVADOC_FOLD_DESCRIPTION = "...";
    private static final String CODE_BLOCK_FOLD_DESCRIPTION = "{...}";
    private static final String TAG_FOLD_DESCRIPTION = "<.../>";
    public static final FoldTemplate CODE_BLOCK_FOLD_TEMPLATE = new FoldTemplate(CODE_BLOCK_FOLD_TYPE, "{...}", 1, 1);
    public static final FoldTemplate INITIAL_COMMENT_FOLD_TEMPLATE = new FoldTemplate(INITIAL_COMMENT_FOLD_TYPE, "...", 2, 2);
    public static final FoldTemplate IMPORTS_FOLD_TEMPLATE = new FoldTemplate(IMPORTS_FOLD_TYPE, "...", 0, 0);
    public static final FoldTemplate JAVADOC_FOLD_TEMPLATE = new FoldTemplate(JAVADOC_FOLD_TYPE, "...", 3, 2);
    public static final FoldTemplate TAG_FOLD_TEMPLATE = new FoldTemplate(TAG_FOLD_TYPE, "<.../>", 0, 0);
    public static final String CODE_FOLDING_COLLAPSE_METHOD = "code-folding-collapse-method";
    public static final String CODE_FOLDING_COLLAPSE_INNERCLASS = "code-folding-collapse-innerclass";
    public static final String CODE_FOLDING_COLLAPSE_IMPORT = "code-folding-collapse-import";
    public static final String CODE_FOLDING_COLLAPSE_JAVADOC = "code-folding-collapse-javadoc";
    public static final String CODE_FOLDING_COLLAPSE_INITIAL_COMMENT = "code-folding-collapse-initial-comment";
    public static final String CODE_FOLDING_COLLAPSE_TAGS = "code-folding-collapse-tags";
    private FoldOperation operation;
    private FileObject file;
    private JavaElementFoldTask task;
    private Preferences prefs;
    private Map<FoldInfo, Fold> currentFolds;
    private Fold initialCommentFold;
    private Fold importsFold;

    public void init(FoldOperation operation) {
        this.operation = operation;
        String mimeType = DocumentUtilities.getMimeType((JTextComponent)operation.getHierarchy().getComponent());
        this.prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
    }

    public synchronized void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.operation.getHierarchy().getComponent().getDocument();
        this.file = DataLoadersBridge.getDefault().getFileObject(doc);
        if (this.file != null) {
            this.currentFolds = new HashMap<FoldInfo, Fold>();
            this.task = JavaElementFoldTask.getTask(this.file);
            this.task.setGsfFoldManager(this, this.file);
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold emptyFold) {
        this.removeDamagedNotify(emptyFold);
    }

    public void removeDamagedNotify(Fold damagedFold) {
        this.currentFolds.remove(this.operation.getExtraInfo(damagedFold));
        if (this.importsFold == damagedFold) {
            this.importsFold = null;
        }
        if (this.initialCommentFold == damagedFold) {
            this.initialCommentFold = null;
        }
    }

    public void expandNotify(Fold expandedFold) {
    }

    public synchronized void release() {
        if (this.task != null) {
            this.task.setGsfFoldManager(null, null);
        }
        this.task = null;
        this.file = null;
        this.currentFolds = null;
        this.importsFold = null;
        this.initialCommentFold = null;
    }

    private boolean getSetting(String settingName) {
        return this.prefs.getBoolean(settingName, false);
    }

    private static boolean hasErrors(ParserResult r) {
        for (Error error : r.getDiagnostics()) {
            if (error.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    protected static final class FoldInfo
    implements Comparable {
        private Position start;
        private Position end;
        private FoldTemplate template;
        private boolean collapseByDefault;

        public FoldInfo(Document doc, int start, int end, FoldTemplate template, boolean collapseByDefault) throws BadLocationException {
            this.start = doc.createPosition(start);
            this.end = doc.createPosition(end);
            this.template = template;
            this.collapseByDefault = collapseByDefault;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FoldInfo)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int compareTo(Object o) {
            FoldInfo remote = (FoldInfo)o;
            if (this.start.getOffset() < remote.start.getOffset()) {
                return -1;
            }
            if (this.start.getOffset() > remote.start.getOffset()) {
                return 1;
            }
            if (this.end.getOffset() < remote.end.getOffset()) {
                return -1;
            }
            if (this.end.getOffset() > remote.end.getOffset()) {
                return 1;
            }
            return 0;
        }
    }

    private class CommitFolds
    implements Runnable {
        private boolean insideRender;
        private TreeSet<FoldInfo> infos;
        private long startTime;

        public CommitFolds(TreeSet<FoldInfo> infos) {
            this.infos = infos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Document document = GsfFoldManager.this.operation.getHierarchy().getComponent().getDocument();
            if (!this.insideRender) {
                this.startTime = System.currentTimeMillis();
                this.insideRender = true;
                document.render(this);
                return;
            }
            GsfFoldManager.this.operation.getHierarchy().lock();
            try {
                FoldHierarchyTransaction tr = GsfFoldManager.this.operation.openTransaction();
                try {
                    if (GsfFoldManager.this.currentFolds == null) {
                        return;
                    }
                    TreeMap<FoldInfo, Fold> added = new TreeMap<FoldInfo, Fold>();
                    TreeSet removed = new TreeSet(GsfFoldManager.this.currentFolds.keySet());
                    int documentLength = document.getLength();
                    for (FoldInfo i : this.infos) {
                        if (removed.remove(i)) continue;
                        int start = i.start.getOffset();
                        int end = i.end.getOffset();
                        if (end > documentLength || end <= start || end - start <= i.template.getStartGuardedLength() + i.template.getEndGuardedLength()) continue;
                        Fold f = GsfFoldManager.this.operation.addToHierarchy(i.template.getType(), i.template.getDescription(), i.collapseByDefault, start, end, i.template.getStartGuardedLength(), i.template.getEndGuardedLength(), (Object)i, tr);
                        added.put(i, f);
                        if (i.template == IMPORTS_FOLD_TEMPLATE) {
                            GsfFoldManager.this.importsFold = f;
                        }
                        if (i.template != INITIAL_COMMENT_FOLD_TEMPLATE) continue;
                        GsfFoldManager.this.initialCommentFold = f;
                    }
                    for (FoldInfo i : removed) {
                        Fold f = (Fold)GsfFoldManager.this.currentFolds.remove(i);
                        GsfFoldManager.this.operation.removeFromHierarchy(f, tr);
                        if (GsfFoldManager.this.importsFold == f) {
                            GsfFoldManager.this.importsFold = null;
                        }
                        if (GsfFoldManager.this.initialCommentFold != f) continue;
                        GsfFoldManager.this.initialCommentFold = f;
                    }
                    GsfFoldManager.this.currentFolds.putAll(added);
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, null, e);
                }
                finally {
                    tr.commit();
                }
            }
            finally {
                GsfFoldManager.this.operation.getHierarchy().unlock();
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 2", new Object[]{GsfFoldManager.this.file, endTime - this.startTime});
        }
    }

    static final class JavaElementFoldTask
    extends ParserResultTask<ParserResult> {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private static Map<FileObject, JavaElementFoldTask> file2Task = new WeakHashMap<FileObject, JavaElementFoldTask>();
        private Reference<GsfFoldManager> manager;

        static JavaElementFoldTask getTask(FileObject file) {
            JavaElementFoldTask task = file2Task.get(file);
            if (task == null) {
                task = new JavaElementFoldTask();
                file2Task.put(file, task);
            }
            return task;
        }

        synchronized void setGsfFoldManager(GsfFoldManager manager, FileObject file) {
            this.manager = new WeakReference<GsfFoldManager>(manager);
            if (file != null) {
                GsfFoldScheduler.reschedule();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ParserResult info, SchedulerEvent event) {
            GsfFoldManager fm;
            this.cancelled.set(false);
            JavaElementFoldTask javaElementFoldTask = this;
            synchronized (javaElementFoldTask) {
                fm = this.manager != null ? this.manager.get() : null;
            }
            if (fm == null) {
                return;
            }
            long startTime = System.currentTimeMillis();
            if (GsfFoldManager.hasErrors(info)) {
                return;
            }
            TreeSet<FoldInfo> folds = new TreeSet<FoldInfo>();
            boolean success = this.gsfFoldScan(fm, info, folds);
            if (!success || this.cancelled.get()) {
                return;
            }
            GsfFoldManager gsfFoldManager = fm;
            gsfFoldManager.getClass();
            SwingUtilities.invokeLater(gsfFoldManager.new CommitFolds(folds));
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 1", new Object[]{info.getSnapshot().getSource().getFileObject(), endTime - startTime});
        }

        private boolean gsfFoldScan(final GsfFoldManager manager, ParserResult info, final TreeSet<FoldInfo> folds) {
            final Document doc = manager.operation.getHierarchy().getComponent().getDocument();
            final boolean[] success = new boolean[]{false};
            Source source = info.getSnapshot().getSource();
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        String mimeType = resultIterator.getSnapshot().getMimeType();
                        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(mimeType);
                        if (language == null) {
                            return;
                        }
                        StructureScanner scanner = language.getStructure();
                        if (scanner == null) {
                            return;
                        }
                        Parser.Result r = resultIterator.getParserResult();
                        if (!(r instanceof ParserResult)) {
                            return;
                        }
                        JavaElementFoldTask.this.scan(manager, (ParserResult)r, folds, doc, scanner);
                        if (JavaElementFoldTask.this.cancelled.get()) {
                            return;
                        }
                        for (Embedding e : resultIterator.getEmbeddings()) {
                            this.run(resultIterator.getResultIterator(e));
                            if (!JavaElementFoldTask.this.cancelled.get()) continue;
                            return;
                        }
                        success[0] = true;
                    }
                });
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
            }
            if (success[0]) {
                success[0] = this.checkInitialFold(manager, folds);
            }
            return success[0];
        }

        private boolean checkInitialFold(final GsfFoldManager manager, final TreeSet<FoldInfo> folds) {
            final boolean[] ret = new boolean[]{true};
            final Document doc = manager.operation.getHierarchy().getComponent().getDocument();
            final TokenHierarchy th = TokenHierarchy.get((Document)doc);
            if (th == null) {
                return false;
            }
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        TokenSequence ts = th.tokenSequence();
                        if (ts == null) {
                            return;
                        }
                        while (ts.moveNext()) {
                            Token token = ts.token();
                            String category = token.id().primaryCategory();
                            if ("comment".equals(category)) {
                                int startOffset = ts.offset();
                                int endOffset = startOffset + token.length();
                                boolean collapsed = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
                                if (manager.initialCommentFold != null) {
                                    collapsed = manager.initialCommentFold.isCollapsed();
                                }
                                while (ts.moveNext()) {
                                    token = ts.token();
                                    category = token.id().primaryCategory();
                                    if ("comment".equals(category)) {
                                        endOffset = ts.offset() + token.length();
                                        continue;
                                    }
                                    if ("whitespace".equals(category)) continue;
                                }
                                try {
                                    startOffset = Utilities.getRowEnd((BaseDocument)((BaseDocument)doc), (int)startOffset);
                                    if (startOffset >= endOffset) {
                                        return;
                                    }
                                }
                                catch (BadLocationException ex) {
                                    LOG.log(Level.WARNING, null, ex);
                                }
                                folds.add(new FoldInfo(doc, startOffset, endOffset, INITIAL_COMMENT_FOLD_TEMPLATE, collapsed));
                                return;
                            }
                            if ("whitespace".equals(category)) continue;
                            break;
                        }
                    }
                    catch (BadLocationException e) {
                        ret[0] = false;
                    }
                }
            });
            return ret[0];
        }

        private void scan(final GsfFoldManager manager, final ParserResult info, final TreeSet<FoldInfo> folds, final Document doc, final StructureScanner scanner) {
            doc.render(new Runnable(){

                @Override
                public void run() {
                    JavaElementFoldTask.this.addTree(manager, folds, info, doc, scanner);
                }
            });
        }

        private void addTree(GsfFoldManager manager, TreeSet<FoldInfo> result, ParserResult info, Document doc, StructureScanner scanner) {
            boolean collapseByDefault;
            Map<String, List<OffsetRange>> folds = scanner.folds(info);
            if (this.cancelled.get()) {
                return;
            }
            List<OffsetRange> ranges = folds.get("codeblocks");
            if (ranges != null) {
                collapseByDefault = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_METHOD);
                for (OffsetRange range : ranges) {
                    try {
                        this.addFold(range, result, doc, collapseByDefault, CODE_BLOCK_FOLD_TEMPLATE);
                    }
                    catch (BadLocationException ble) {
                        LOG.log(Level.WARNING, "StructureScanner " + scanner + " supplied invalid fold " + range, ble);
                    }
                }
            }
            if ((ranges = folds.get("comments")) != null) {
                collapseByDefault = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_JAVADOC);
                for (OffsetRange range : ranges) {
                    try {
                        this.addFold(range, result, doc, collapseByDefault, JAVADOC_FOLD_TEMPLATE);
                    }
                    catch (BadLocationException ble) {
                        LOG.log(Level.WARNING, "StructureScanner " + scanner + " supplied invalid fold " + range, ble);
                    }
                }
            }
            if ((ranges = folds.get("initial-comment")) != null) {
                for (OffsetRange range : ranges) {
                    try {
                        boolean collapseByDefault2 = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
                        this.addFold(range, result, doc, collapseByDefault2, INITIAL_COMMENT_FOLD_TEMPLATE);
                    }
                    catch (BadLocationException ble) {
                        LOG.log(Level.WARNING, "StructureScanner " + scanner + " supplied invalid fold " + range, ble);
                    }
                }
            }
            if ((ranges = folds.get("imports")) != null) {
                for (OffsetRange range : ranges) {
                    try {
                        boolean collapseByDefault3 = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_IMPORT);
                        this.addFold(range, result, doc, collapseByDefault3, IMPORTS_FOLD_TEMPLATE);
                    }
                    catch (BadLocationException ble) {
                        LOG.log(Level.WARNING, "StructureScanner " + scanner + " supplied invalid fold " + range, ble);
                    }
                }
            }
            if ((ranges = folds.get("tags")) != null) {
                for (OffsetRange range : ranges) {
                    try {
                        boolean collapseByDefault4 = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_TAGS);
                        this.addFold(range, result, doc, collapseByDefault4, TAG_FOLD_TEMPLATE);
                    }
                    catch (BadLocationException ble) {
                        LOG.log(Level.WARNING, "StructureScanner " + scanner + " supplied invalid fold " + range, ble);
                    }
                }
            }
        }

        private void addFold(OffsetRange range, TreeSet<FoldInfo> folds, Document doc, boolean collapseByDefault, FoldTemplate template) throws BadLocationException {
            if (range != OffsetRange.NONE) {
                int start = range.getStart();
                int end = range.getEnd();
                if (start != -1 && end != -1 && end <= doc.getLength()) {
                    folds.add(new FoldInfo(doc, start, end, template, collapseByDefault));
                }
            }
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public Class<? extends Scheduler> getSchedulerClass() {
            return GsfFoldScheduler.class;
        }

        public void cancel() {
            this.cancelled.set(true);
        }
    }

    protected static final class FoldTemplate {
        private FoldType type;
        private String description;
        private int startGuardedLength;
        private int endGuardedLength;

        protected FoldTemplate(FoldType type, String description, int startGuardedLength, int endGuardedLength) {
            this.type = type;
            this.description = description;
            this.startGuardedLength = startGuardedLength;
            this.endGuardedLength = endGuardedLength;
        }

        public FoldType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public int getStartGuardedLength() {
            return this.startGuardedLength;
        }

        public int getEndGuardedLength() {
            return this.endGuardedLength;
        }
    }
}

