/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginExecution;
import org.netbeans.modules.xml.jaxb.spi.SchemaCompiler;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class MavenSchemaCompiler
implements SchemaCompiler {
    private static final String JAVA_SE_CONFIG_DIR = "resources/jaxb";
    private static final String JAXB_PLUGIN_GROUP_ID = "org.jvnet.jaxb2.maven2";
    private static final String JAXB_PLUGIN_ARTIFACT_ID = "maven-jaxb2-plugin";
    private static final String JAXB_GENERATE_PREFIX = "jaxb-generate-";
    private Project project;

    MavenSchemaCompiler(Project project) {
        this.project = project;
    }

    public void compileSchema(final WizardDescriptor wiz) {
        final String schemaName = (String)wiz.getProperty("schema.name");
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Plugin plugin = MavenSchemaCompiler.this.addJaxb2Plugin(model);
                String packageName = (String)wiz.getProperty("xsd.package.name");
                if (packageName != null && packageName.trim().length() == 0) {
                    packageName = null;
                }
                MavenSchemaCompiler.addJaxb2Execution(plugin, schemaName, packageName);
            }
        };
        Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(operation));
    }

    public void importResources(WizardDescriptor wiz) throws IOException {
        block6: {
            List xsdFileList = (List)wiz.getProperty("xsd.file.list");
            if (xsdFileList == null) break block6;
            String schemaName = (String)wiz.getProperty("schema.name");
            List bindingFileList = (List)wiz.getProperty("jaxb.binding.files");
            String catlogFile = (String)wiz.getProperty("jaxb.catalog.file");
            boolean srcLocTypeUrl = "url".equals((String)wiz.getProperty("xsd.locatiom.type"));
            if (srcLocTypeUrl) {
                for (int i = 0; i < xsdFileList.size(); ++i) {
                    String url = (String)xsdFileList.get(i);
                    URL schemaURL = new URL(url);
                    try {
                        FileObject newFileFO = MavenSchemaCompiler.retrieveResource(this.getSchemaFolder(schemaName), schemaURL.toURI());
                        continue;
                    }
                    catch (URISyntaxException ex) {
                        throw new IOException(ex.getMessage());
                    }
                }
            } else {
                FileObject projFO = this.project.getProjectDirectory();
                File projDir = FileUtil.toFile((FileObject)projFO);
                for (int i = 0; i < xsdFileList.size(); ++i) {
                    File srcFile = MavenSchemaCompiler.Relative2AbsolutePath(projDir, (String)xsdFileList.get(i));
                    FileObject newFileFO = MavenSchemaCompiler.retrieveResource(this.getSchemaFolder(schemaName), srcFile.toURI());
                }
            }
        }
    }

    private static FileObject retrieveResource(FileObject targetFolder, URI source) {
        Retriever retriever = Retriever.getDefault();
        FileObject result = null;
        try {
            result = retriever.retrieveResource(targetFolder, source);
        }
        catch (UnknownHostException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result == null) {
            // empty if block
        }
        return result;
    }

    public FileObject getSchemaFolder(String schemaName) throws IOException {
        FileObject mainFolder = this.project.getProjectDirectory().getFileObject("src/main");
        if (mainFolder != null) {
            FileObject resourcesFolder = mainFolder.getFileObject("resources");
            if (resourcesFolder == null) {
                resourcesFolder = mainFolder.createFolder("resources");
            }
            if (resourcesFolder != null) {
                FileObject jaxbFolder = resourcesFolder.getFileObject("jaxb");
                if (jaxbFolder == null) {
                    jaxbFolder = resourcesFolder.createFolder("jaxb");
                }
                if (jaxbFolder != null) {
                    FileObject schemaFolder = jaxbFolder.getFileObject(schemaName);
                    if (schemaFolder == null) {
                        schemaFolder = jaxbFolder.createFolder(schemaName);
                    }
                    return schemaFolder;
                }
            }
        }
        return null;
    }

    private static File Relative2AbsolutePath(File base, String relPath) {
        File relPathFile = new File(relPath);
        File absPath = null;
        absPath = !relPathFile.isAbsolute() ? new File(base, relPath) : relPathFile;
        return absPath;
    }

    private Plugin addJaxb2Plugin(POMModel model) {
        Plugin plugin;
        assert (model.isIntransaction()) : "need to call model modifications under transaction.";
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            bld = model.getFactory().createBuild();
            model.getProject().setBuild(bld);
        }
        if ((plugin = bld.findPluginById(JAXB_PLUGIN_GROUP_ID, JAXB_PLUGIN_ARTIFACT_ID)) != null) {
            return plugin;
        }
        plugin = model.getFactory().createPlugin();
        plugin.setGroupId(JAXB_PLUGIN_GROUP_ID);
        plugin.setArtifactId(JAXB_PLUGIN_ARTIFACT_ID);
        bld.addPlugin(plugin);
        Configuration config = plugin.getConfiguration();
        if (config == null) {
            config = model.getFactory().createConfiguration();
            config.setSimpleParameter("catalog", "src/main/resources/jaxb/catalog.xml");
            config.setSimpleParameter("catalogResolver", "org.jvnet.jaxb2.maven2.resolver.tools.ClasspathCatalogResolver");
            config.setSimpleParameter("forceRegenerate", "true");
            config.setSimpleParameter("generateDirectory", "${project.build.directory}/generated-sources/xjc");
            config.setSimpleParameter("verbose", "true");
            plugin.setConfiguration(config);
        }
        return plugin;
    }

    public static void addJaxb2Execution(Plugin plugin, String id, String packageName) {
        POMModel model = plugin.getModel();
        assert (model.isIntransaction());
        PluginExecution exec = model.getFactory().createExecution();
        String uniqueId = MavenSchemaCompiler.getUniqueId(plugin, id);
        exec.setId(JAXB_GENERATE_PREFIX + uniqueId);
        exec.addGoal("generate");
        plugin.addExecution(exec);
        Configuration config = model.getFactory().createConfiguration();
        exec.setConfiguration(config);
        QName qname = POMQName.createQName((String)"schemaIncludes", (boolean)model.getPOMQNames().isNSAware());
        POMExtensibilityElement schemaIncludes = model.getFactory().createPOMExtensibilityElement(qname);
        config.addExtensibilityElement(schemaIncludes);
        qname = POMQName.createQName((String)"include", (boolean)model.getPOMQNames().isNSAware());
        POMExtensibilityElement include = model.getFactory().createPOMExtensibilityElement(qname);
        include.setElementText("jaxb/" + id + "/*.xsd");
        schemaIncludes.addExtensibilityElement(include);
        qname = POMQName.createQName((String)"episodeFile", (boolean)model.getPOMQNames().isNSAware());
        POMExtensibilityElement episodeFile = model.getFactory().createPOMExtensibilityElement(qname);
        episodeFile.setElementText("${project.build.directory}/generated-sources/xjc/META-INF/jaxb-" + id + ".episode");
        config.addExtensibilityElement(episodeFile);
        if (packageName != null) {
            qname = POMQName.createQName((String)"generatePackage", (boolean)model.getPOMQNames().isNSAware());
            POMExtensibilityElement generatePackage = model.getFactory().createPOMExtensibilityElement(qname);
            generatePackage.setElementText(packageName);
            config.addExtensibilityElement(generatePackage);
        }
    }

    private static String getUniqueId(Plugin plugin, String id) {
        String result = id;
        List executions = plugin.getExecutions();
        if (executions != null) {
            HashSet<String> execIdSet = new HashSet<String>();
            for (PluginExecution ex : executions) {
                String execId = ex.getId();
                if (execId == null) continue;
                if (execId.startsWith(JAXB_GENERATE_PREFIX)) {
                    execIdSet.add(execId.substring(JAXB_GENERATE_PREFIX.length()));
                    continue;
                }
                execIdSet.add(execId);
            }
            int i = 1;
            while (execIdSet.contains(result)) {
                result = id + "_" + String.valueOf(i++);
            }
        }
        return result;
    }
}

