/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.dlight.visualizers.ui.FunctionCallNode;
import org.netbeans.swing.etable.ETable;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

public final class FunctionCallNodeRenderer
extends DefaultTableCellRenderer {
    private static final Color htmlEnabledForeground = FunctionCallNodeRenderer.getColor("FormattedTextField.foreground", Color.BLACK);
    private static final Color htmlDisabledForeground = FunctionCallNodeRenderer.getColor("FormattedTextField.inactiveForeground", Color.GRAY);
    private static final Color tooltipBG = FunctionCallNodeRenderer.getColor("ToolTip.background", Color.YELLOW);
    private static final String dots = " ... ";
    private final Graphics2D scratchGraphics = new BufferedImage(1, 1, 1).createGraphics();
    private FunctionCallNode node;
    private int cellwidth;
    private int cellheight;
    private final ExplorerManager manager;

    private static Color getColor(String propName, Color defaultColor) {
        Color result = UIManager.getDefaults().getColor(propName);
        return result == null ? defaultColor : result;
    }

    public FunctionCallNodeRenderer(ExplorerManager manager) {
        this.manager = manager;
        this.setVerticalAlignment(1);
    }

    @Override
    public String getToolTipText() {
        return this.ensureVisible(this.node.getHtmlDisplayName(), tooltipBG);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table instanceof ETable) {
            row = ((ETable)table).convertRowIndexToModel(row);
            Node n = this.manager.getRootContext().getChildren().getNodeAt(row);
            if (n instanceof FunctionCallNode) {
                this.node = (FunctionCallNode)n;
                this.setText(this.ensureVisible(this.node.getHtmlDisplayName(), this.getBackground()));
            }
        }
        return this;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int strw = 0;
        if (width > 0 && height > 0) {
            this.cellwidth = width;
            this.cellheight = height;
            strw = (int)HtmlRenderer.renderHTML((String)(this.node.getHtmlDisplayName() + ' '), (Graphics)this.scratchGraphics, (int)x, (int)y, (int)width, (int)height, (Font)this.getFont(), (Color)Color.black, (int)0, (boolean)false);
        }
        super.setBounds(x, y, Math.max(width, strw) + 10, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fm = g.getFontMetrics();
        int strw = (int)HtmlRenderer.renderHTML((String)(this.node.getHtmlDisplayName() + ' '), (Graphics)this.scratchGraphics, (int)0, (int)0, (int)this.cellwidth, (int)0, (Font)this.getFont(), (Color)Color.black, (int)0, (boolean)false);
        if (this.cellwidth < strw) {
            int dotsw = (int)g.getFontMetrics().getStringBounds(dots, g).getMaxX();
            ((Graphics2D)g).setBackground(this.getBackground());
            g.setColor(this.getContrastGrayColor(htmlDisabledForeground, this.getBackground()));
            g.clearRect(this.cellwidth - dotsw, 0, dotsw, this.cellheight);
            g.drawString(dots, this.cellwidth - dotsw, fm.getHeight() + fm.getLeading() - fm.getDescent());
        }
    }

    private Color getContrastGrayColor(Color orig, Color bg) {
        int rgb = orig.getRGB();
        int orig_gray = ((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3;
        int bg_gray = (((rgb = bg.getRGB()) >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3;
        if (Math.abs(orig_gray - bg_gray) > 100) {
            return new Color(orig_gray, orig_gray, orig_gray);
        }
        int avg = bg_gray > 128 ? bg_gray - 100 : bg_gray + 100;
        return new Color(avg, avg, avg);
    }

    private String ensureVisible(String html, Color bg) {
        Color black = this.getContrastGrayColor(htmlEnabledForeground, bg);
        Color gray = this.getContrastGrayColor(htmlDisabledForeground, bg);
        String sblack = String.format("color='#%02x%02x%02x'", black.getRed(), black.getGreen(), black.getBlue());
        String sgray = String.format("color='#%02x%02x%02x'", gray.getRed(), gray.getGreen(), gray.getBlue());
        html = html.replace("color='#000000'", sblack);
        return html.replace("color='#808080'", sgray);
    }
}

