/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.visualizers.GotoSourceActionProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public final class FunctionCallNode
extends AbstractNode {
    private static final boolean useHtmlFormat = "true".equalsIgnoreCase(System.getProperty("FunctionsListViewVisualizer.usehtml", "true"));
    private final FunctionCallWithMetric functionCall;
    private final List<DataTableMetadata.Column> metrics;
    private final PropertyChangeListener pcl;
    private final GotoSourceActionProvider.GotoSourceAction goToSourceAction;
    private String plainDisplayName = null;
    private String htmlDisplayName = null;
    private String functionName = null;

    public FunctionCallNode(GotoSourceActionProvider actionsProvider, FunctionCallWithMetric f, List<DataTableMetadata.Column> metrics) {
        super(Children.LEAF);
        this.functionCall = f;
        this.metrics = metrics;
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FunctionCallNode.this.updateNames();
                FunctionCallNode.this.fireDisplayNameChange(null, FunctionCallNode.this.getDisplayName());
            }
        };
        this.goToSourceAction = actionsProvider.getAction(this.functionCall);
        this.goToSourceAction.addPropertyChangeListener(this.pcl);
        this.updateNames();
    }

    protected Sheet createSheet() {
        Sheet result = new Sheet();
        Sheet.Set set = new Sheet.Set();
        for (final DataTableMetadata.Column metric : this.metrics) {
            PropertySupport.ReadOnly property = new PropertySupport.ReadOnly(metric.getColumnName(), metric.getColumnClass(), metric.getColumnUName(), metric.getColumnLongUName()){

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    return !FunctionCallNode.this.functionCall.hasMetric(metric.getColumnName()) ? NbBundle.getMessage(FunctionCallNode.class, (String)"NotDefined") : FunctionCallNode.this.functionCall.getMetricValue(metric.getColumnName());
                }
            };
            set.put((Node.Property)property);
        }
        result.put(set);
        return result;
    }

    public Image getIcon(int type) {
        return null;
    }

    public Image getOpenedIcon(int type) {
        return null;
    }

    public synchronized Action getPreferredAction() {
        return this.goToSourceAction;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{this.goToSourceAction};
    }

    public synchronized String getName() {
        return this.functionName;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName().concat(": ").concat(this.getName());
    }

    public synchronized GotoSourceActionProvider.GotoSourceAction getGoToSourceAction() {
        return this.goToSourceAction;
    }

    public synchronized String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public synchronized String getDisplayName() {
        return useHtmlFormat ? this.htmlDisplayName : this.plainDisplayName;
    }

    private synchronized void updateNames() {
        this.plainDisplayName = this.functionCall.getDisplayedName();
        String name = this.functionCall.getFunction().getName();
        String funcName = this.functionCall.getFunction().getQuilifiedName();
        int idx1 = name.indexOf(funcName);
        int idx2 = funcName.lastIndexOf(58);
        if (idx2 > 0) {
            idx1 += idx2 + 1;
            funcName = funcName.substring(idx2 + 1);
        }
        this.functionName = funcName;
        String prefix = name.substring(0, idx1);
        String suffix = name.substring(idx1 + funcName.length());
        prefix = this.toHtml(prefix);
        funcName = this.toHtml(funcName);
        suffix = this.toHtml(suffix);
        funcName = "<b>" + funcName + "</b>";
        String dispName = prefix + funcName + suffix + "&nbsp;";
        GotoSourceActionProvider.GotoSourceAction action = this.getGoToSourceAction();
        StringBuilder result = new StringBuilder("<html>");
        String infoSuffix = null;
        if (action != null && action.isEnabled()) {
            result.append("<font color='#000000'>").append(dispName).append("</font>");
            SourceFileInfoProvider.SourceFileInfo sourceInfo = action.getSourceInfo();
            if (sourceInfo != null && sourceInfo.isSourceKnown()) {
                String fname = new File(sourceInfo.getFileName()).getName();
                int line = sourceInfo.getLine();
                String infoPrefix = line > 0 ? NbBundle.getMessage(FunctionCallNode.class, (String)"FunctionCallNode.prefix.withLine") : NbBundle.getMessage(FunctionCallNode.class, (String)"FunctionCallNode.prefix.withoutLine");
                infoSuffix = infoPrefix + "&nbsp;" + fname + (line > 0 ? ":" + line : "");
                result.append("<font color='#808080'>").append(infoSuffix).append("</font>");
            }
        } else {
            result.append("<font color='#808080'>").append(dispName).append("</font>");
        }
        result.append("</html>");
        this.htmlDisplayName = result.toString();
    }

    private String toHtml(String plain) {
        plain = plain.replace("&", "&amp;");
        plain = plain.replace("<", "&lt;");
        plain = plain.replace(">", "&gt;");
        plain = plain.replace(" ", "&nbsp;");
        return plain;
    }
}

