/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.api.visualizer.TableBasedVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.impl.TreeTableVisualizerConfigurationAccessor;
import org.netbeans.spi.viewmodel.NodeActionsProvider;

public class TreeTableVisualizerConfiguration
implements TableBasedVisualizerConfiguration {
    private DataTableMetadata dataTableMetadata;
    private DataTableMetadata.Column treeColumn;
    private DataTableMetadata.Column[] tableColumns;
    private boolean isPlainTable = false;
    private ColumnsUIMapping columnsUIMapping;
    private NodeActionsProvider nodeActionsProvider;

    private TreeTableVisualizerConfiguration(String tableName, DataTableMetadata.Column treeColumn, DataTableMetadata.Column[] tableColumns) {
        this.treeColumn = treeColumn;
        this.tableColumns = tableColumns;
        List<DataTableMetadata.Column> columns = Arrays.asList(treeColumn);
        columns.addAll(Arrays.asList(tableColumns));
        this.dataTableMetadata = new DataTableMetadata(tableName, columns, null);
    }

    public TreeTableVisualizerConfiguration(DataTableMetadata dataTableMetadata, String treeColumnName) {
        this(dataTableMetadata, treeColumnName, false);
    }

    public TreeTableVisualizerConfiguration(DataTableMetadata dataTableMetadata, String treeColumnName, boolean isPlainTable) {
        this.setDataTableMetadata(dataTableMetadata, treeColumnName);
        this.isPlainTable = isPlainTable;
    }

    protected TreeTableVisualizerConfiguration() {
    }

    private void setDataTableMetadata(DataTableMetadata dataTableMetadata, String treeColumnName) {
        this.dataTableMetadata = dataTableMetadata;
        this.treeColumn = dataTableMetadata.getColumnByName(treeColumnName);
        List columns = dataTableMetadata.getColumns();
        ArrayList<DataTableMetadata.Column> tableColumnsList = new ArrayList<DataTableMetadata.Column>();
        for (DataTableMetadata.Column c : columns) {
            if (c.getColumnName().equals(treeColumnName)) continue;
            tableColumnsList.add(c);
        }
        this.tableColumns = tableColumnsList.toArray(new DataTableMetadata.Column[0]);
    }

    boolean isTableView() {
        return this.isPlainTable;
    }

    DataTableMetadata.Column[] getTableColumns() {
        return this.tableColumns;
    }

    DataTableMetadata.Column getTreeColumn() {
        return this.treeColumn;
    }

    NodeActionsProvider getNodeActionsProvider() {
        return this.nodeActionsProvider;
    }

    public void setNodeActionProvider(NodeActionsProvider nodeActionsProvider) {
        this.nodeActionsProvider = nodeActionsProvider;
    }

    public final void setColumnsUIMapping(ColumnsUIMapping columnsUIMapping) {
        this.columnsUIMapping = columnsUIMapping;
    }

    public DataTableMetadata getMetadata() {
        return this.dataTableMetadata;
    }

    public DataModelScheme getSupportedDataScheme() {
        return DataModelSchemeProvider.getInstance().getScheme("model:tree:table");
    }

    public String getID() {
        return "treeTable";
    }

    static {
        TreeTableVisualizerConfigurationAccessor.setDefault(new TreeTableVisualizerConfigurationAccessorImpl());
    }

    private static final class TreeTableVisualizerConfigurationAccessorImpl
    extends TreeTableVisualizerConfigurationAccessor {
        private TreeTableVisualizerConfigurationAccessorImpl() {
        }

        @Override
        public DataTableMetadata.Column[] getTableColumns(TreeTableVisualizerConfiguration configuration) {
            return configuration.getTableColumns();
        }

        @Override
        public DataTableMetadata.Column getTreeColumn(TreeTableVisualizerConfiguration configuration) {
            return configuration.getTreeColumn();
        }

        @Override
        public boolean isTableView(TreeTableVisualizerConfiguration configuration) {
            return configuration.isTableView();
        }

        @Override
        public NodeActionsProvider getNodesActionProvider(TreeTableVisualizerConfiguration configuration) {
            return configuration.getNodeActionsProvider();
        }

        @Override
        public ColumnsUIMapping getColumnsUIMapping(TreeTableVisualizerConfiguration configuration) {
            return configuration.columnsUIMapping;
        }
    }
}

