/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.installer.product.dependencies.Conflict;
import org.netbeans.installer.product.dependencies.InstallAfter;
import org.netbeans.installer.product.dependencies.Requirement;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.helper.Dependency;
import org.netbeans.installer.utils.helper.ExtendedUri;
import org.netbeans.installer.utils.helper.Feature;
import org.netbeans.installer.utils.helper.NbiProperties;
import org.netbeans.installer.utils.helper.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLUtils {
    public static final String XSLT_REFORMAT_URI = "resource:org/netbeans/installer/utils/xml/reformat.xslt";
    private static final int MAXIMUM_SAVE_ATTEMPTS = 3;

    /*
     * Unable to fully structure code
     */
    public static void saveXMLDocument(Document document, File file) throws XMLException {
        LogManager.logEntry("saving document to xml file : " + file);
        output = null;
        for (i = 0; i < 3; ++i) {
            block10: {
                try {
                    output = new FileOutputStream(file);
                    XMLUtils.saveXMLDocument(document, output);
                    var6_4 = null;
                    ** if (output == null) goto lbl-1000
                }
                catch (Throwable var5_7) {
                    var6_4 = null;
                    if (output != null) {
                        try {
                            output.close();
                            output = null;
                        }
                        catch (IOException e) {
                            ErrorManager.notifyDebug("Could not close the stream", e);
                        }
                    }
                    throw var5_7;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        output.close();
                        output = null;
                    }
                    catch (IOException e) {
                        ErrorManager.notifyDebug("Could not close the stream", e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block10;
                    catch (IOException e) {
                        LogManager.log("... can`t save XML, an exception caught", (Throwable)e);
                        LogManager.logExit("... document not saved");
                        throw new XMLException("Cannot save XML document", e);
                    }
                }
            }
            if (file.length() <= 0L) continue;
            LogManager.logExit("... document saved");
            return;
        }
        LogManager.logExit("... throwing XML exception since xml file could not be saved for several attemps");
        throw new XMLException("Cannot save XML document after 3 attempts, the resulting file is empty.");
    }

    public static void saveXMLDocument(Document document, OutputStream output) throws XMLException {
        try {
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(output);
            StreamSource xslt = new StreamSource(FileProxy.getInstance().getFile(XSLT_REFORMAT_URI, true));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer(xslt);
            transformer.transform(source, result);
        }
        catch (DownloadException e) {
            throw new XMLException("Cannot save XML document", e);
        }
        catch (TransformerConfigurationException e) {
            throw new XMLException("Cannot save XML document", e);
        }
        catch (TransformerException e) {
            throw new XMLException("Cannot save XML document", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document loadXMLDocument(File file) throws XMLException {
        Document document;
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(file);
                document = XMLUtils.loadXMLDocument(input);
                Object var4_4 = null;
                if (input == null) return document;
            }
            catch (IOException e) {
                throw new XMLException("Cannot open XML file", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (input == null) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException e2) {
                ErrorManager.notifyDebug("Cannot close the stream", e2);
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            ErrorManager.notifyDebug("Cannot close the stream", e2);
            return document;
        }
        input.close();
        return document;
    }

    public static Document loadXMLDocument(InputStream input) throws XMLException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException("Cannot parse XML", e);
        }
        catch (SAXException e) {
            throw new XMLException("Cannot parse XML", e);
        }
        catch (IOException e) {
            throw new XMLException("Cannot parse XML", e);
        }
    }

    public static Element getDocumentElement(File file) throws XMLException {
        return XMLUtils.loadXMLDocument(file).getDocumentElement();
    }

    public static Element getDocumentElement(InputStream input) throws XMLException {
        return XMLUtils.loadXMLDocument(input).getDocumentElement();
    }

    public static List<Element> getChildren(Element element) {
        LinkedList<Element> children = new LinkedList<Element>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            children.add((Element)node);
        }
        return children;
    }

    public static List<Element> getChildren(Element element, String ... names) {
        LinkedList<Element> children = new LinkedList<Element>();
        NodeList list = element.getChildNodes();
        block0: for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            for (int j = 0; j < names.length; ++j) {
                if (!node.getNodeName().equals(names[j])) continue;
                children.add((Element)node);
                continue block0;
            }
        }
        return children;
    }

    public static Element getChild(Element element, String path) {
        String[] pathComponents = path.contains("/") ? path.split("/") : new String[]{path};
        Element child = element;
        for (String name : pathComponents) {
            boolean found = false;
            for (Element subchild : XMLUtils.getChildren(child)) {
                if (!subchild.getNodeName().equals(name)) continue;
                child = subchild;
                found = true;
                break;
            }
            if (found) continue;
            child = null;
            break;
        }
        return child;
    }

    public static int countDescendants(Element element, String ... names) {
        return XMLUtils.countDescendants(element, Arrays.asList(names));
    }

    public static int countDescendants(Element element, List<String> names) {
        int count = 0;
        for (Element child : XMLUtils.getChildren(element)) {
            if (names.contains(child.getNodeName())) {
                ++count;
            }
            count += XMLUtils.countDescendants(child, names);
        }
        return count;
    }

    public static Element appendChild(Element element, String name, String text) {
        Element child = element.getOwnerDocument().createElement(name);
        child.setTextContent(text != null ? text : "");
        element.appendChild(child);
        return child;
    }

    public static Dependency parseDependency(Element element) throws ParseException {
        String type = element.getNodeName();
        String uid = element.getAttribute("uid");
        Version lower = Version.getVersion(element.getAttribute("version-lower"));
        Version upper = Version.getVersion(element.getAttribute("version-upper"));
        Version resolved = Version.getVersion(element.getAttribute("version-resolved"));
        Dependency dependency = null;
        if (type.equals("requirement")) {
            ArrayList<List<Requirement>> orList = new ArrayList<List<Requirement>>();
            for (Element orElement : XMLUtils.getChildren(element, "or")) {
                ArrayList<Requirement> requirements = new ArrayList<Requirement>();
                for (Element el : XMLUtils.getChildren(orElement)) {
                    Dependency dep = XMLUtils.parseDependency(el);
                    if (dep instanceof Requirement) {
                        requirements.add((Requirement)dep);
                        continue;
                    }
                    throw new ParseException("OR dependencies are not supported for " + dep.getName());
                }
                orList.add(requirements);
            }
            dependency = new Requirement(uid, lower, upper, resolved, orList);
        } else if (type.equals("conflict")) {
            dependency = new Conflict(uid, lower, upper, resolved);
        } else if (type.equals("install-after")) {
            dependency = new InstallAfter(uid, lower, upper, resolved);
        } else {
            throw new ParseException("Unknown dependency : " + type);
        }
        return dependency;
    }

    public static Element saveDependency(Dependency dependency, Element element) {
        element.setAttribute("uid", dependency.getUid());
        if (dependency.getVersionLower() != null) {
            element.setAttribute("version-lower", dependency.getVersionLower().toString());
        }
        if (dependency.getVersionUpper() != null) {
            element.setAttribute("version-upper", dependency.getVersionUpper().toString());
        }
        if (dependency.getVersionResolved() != null) {
            element.setAttribute("version-resolved", dependency.getVersionResolved().toString());
        }
        if (dependency instanceof Requirement) {
            Requirement requirement = (Requirement)dependency;
            List<List<Requirement>> orList = requirement.getAlternatives();
            for (List<Requirement> requirememntsBlock : orList) {
                element.appendChild(XMLUtils.saveDependencies(requirememntsBlock, element.getOwnerDocument().createElement("or")));
            }
        }
        return element;
    }

    public static List<Dependency> parseDependencies(Element element) throws ParseException {
        LinkedList<Dependency> dependencies = new LinkedList<Dependency>();
        for (Element child : XMLUtils.getChildren(element)) {
            dependencies.add(XMLUtils.parseDependency(child));
        }
        return dependencies;
    }

    public static Element saveDependencies(List<? extends Dependency> dependencies, Element element) {
        Document document = element.getOwnerDocument();
        for (Dependency dependency : dependencies) {
            element.appendChild(XMLUtils.saveDependency(dependency, document.createElement(dependency.getName())));
        }
        return element;
    }

    public static Properties parseProperties(Element element) throws ParseException {
        Properties properties = new Properties();
        if (element != null) {
            for (Element child : XMLUtils.getChildren(element, "property")) {
                String name = child.getAttribute("name");
                String value = child.getTextContent();
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    public static Element saveProperties(Properties properties, Element element) {
        Document document = element.getOwnerDocument();
        for (Object key : properties.keySet()) {
            Element propertyElement = document.createElement("property");
            propertyElement.setAttribute("name", key.toString());
            propertyElement.setTextContent(properties.get(key).toString());
            element.appendChild(propertyElement);
        }
        return element;
    }

    public static NbiProperties parseNbiProperties(Element element) throws ParseException {
        return new NbiProperties(XMLUtils.parseProperties(element));
    }

    public static Element saveNbiProperties(NbiProperties properties, Element element) {
        return XMLUtils.saveProperties(properties, element);
    }

    public static ExtendedUri parseExtendedUri(Element element) throws ParseException {
        try {
            URI uri = new URI(XMLUtils.getChild(element, "default-uri").getTextContent());
            long size = Long.parseLong(element.getAttribute("size"));
            String md5 = element.getAttribute("md5");
            LinkedList<URI> alternates = new LinkedList<URI>();
            for (Element alternateElement : XMLUtils.getChildren(element, "alternate-uri")) {
                alternates.add(new URI(alternateElement.getTextContent()));
            }
            if (uri.getScheme().equals("file")) {
                return new ExtendedUri(uri, alternates, uri, size, md5);
            }
            return new ExtendedUri(uri, alternates, size, md5);
        }
        catch (URISyntaxException e) {
            throw new ParseException("Cannot parse extended URI", e);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse extended URI", e);
        }
    }

    public static Element saveExtendedUri(ExtendedUri uri, Element element) {
        Document document = element.getOwnerDocument();
        element.setAttribute("size", Long.toString(uri.getSize()));
        element.setAttribute("md5", uri.getMd5());
        Element uriElement = document.createElement("default-uri");
        if (uri.getLocal() != null) {
            uriElement.setTextContent(uri.getLocal().toString());
        } else {
            uriElement.setTextContent(uri.getRemote().toString());
        }
        element.appendChild(uriElement);
        if (uri.getLocal() != null && !uri.getRemote().equals(uri.getLocal())) {
            uriElement = document.createElement("alternate-uri");
            uriElement.setTextContent(uri.getRemote().toString());
            element.appendChild(uriElement);
        }
        for (URI alternateUri : uri.getAlternates()) {
            if (alternateUri.equals(uri.getRemote())) continue;
            uriElement = document.createElement("alternate-uri");
            uriElement.setTextContent(alternateUri.toString());
            element.appendChild(uriElement);
        }
        return element;
    }

    public static List<ExtendedUri> parseExtendedUrisList(Element element) throws ParseException {
        LinkedList<ExtendedUri> uris = new LinkedList<ExtendedUri>();
        for (Element uriElement : XMLUtils.getChildren(element)) {
            uris.add(XMLUtils.parseExtendedUri(uriElement));
        }
        return uris;
    }

    public static Element saveExtendedUrisList(List<ExtendedUri> uris, Element element) {
        Document document = element.getOwnerDocument();
        for (ExtendedUri uri : uris) {
            element.appendChild(XMLUtils.saveExtendedUri(uri, document.createElement("file")));
        }
        return element;
    }

    public static Map<Locale, String> parseLocalizedString(Element element) throws ParseException {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Element defaultElement = XMLUtils.getChild(element, "default");
        map.put(new Locale(""), StringUtils.parseAscii(defaultElement.getTextContent()));
        for (Element localizedElement : XMLUtils.getChildren(element, "localized")) {
            Locale locale = StringUtils.parseLocale(localizedElement.getAttribute("locale"));
            String localizedString = StringUtils.parseAscii(localizedElement.getTextContent());
            map.put(locale, localizedString);
        }
        return map;
    }

    public static Element saveLocalizedString(Map<Locale, String> map, Element element) {
        Document document = element.getOwnerDocument();
        Element defaultElement = document.createElement("default");
        defaultElement.setTextContent(StringUtils.convertToAscii(map.get(new Locale(""))));
        element.appendChild(defaultElement);
        for (Locale locale : map.keySet()) {
            if (map.get(locale).equals(map.get(new Locale("")))) continue;
            Element localizedElement = document.createElement("localized");
            localizedElement.setAttribute("locale", locale.toString());
            localizedElement.setTextContent(StringUtils.convertToAscii(map.get(locale)));
            element.appendChild(localizedElement);
        }
        return element;
    }

    public static Feature parseFeature(Element element) throws ParseException {
        String id = element.getAttribute("id");
        long offset = Long.parseLong(element.getAttribute("offset"));
        ExtendedUri iconUri = XMLUtils.parseExtendedUri(XMLUtils.getChild(element, "icon"));
        Map<Locale, String> displayNames = XMLUtils.parseLocalizedString(XMLUtils.getChild(element, "display-name"));
        Map<Locale, String> descriptions = XMLUtils.parseLocalizedString(XMLUtils.getChild(element, "description"));
        return new Feature(id, offset, iconUri, displayNames, descriptions);
    }

    public static Element saveFeature(Feature feature, Element element) {
        Document document = element.getOwnerDocument();
        element.setAttribute("id", feature.getId());
        element.setAttribute("offset", Long.toString(feature.getOffset()));
        element.appendChild(XMLUtils.saveExtendedUri(feature.getIconUri(), document.createElement("icon")));
        element.appendChild(XMLUtils.saveLocalizedString(feature.getDisplayNames(), document.createElement("display-name")));
        element.appendChild(XMLUtils.saveLocalizedString(feature.getDescriptions(), document.createElement("description")));
        return element;
    }

    public static List<Feature> parseFeaturesList(Element element) throws ParseException {
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (Element featureElement : XMLUtils.getChildren(element)) {
            features.add(XMLUtils.parseFeature(featureElement));
        }
        return features;
    }

    public static Element saveFeaturesList(List<Feature> features, Element element) {
        Document document = element.getOwnerDocument();
        for (Feature feature : features) {
            element.appendChild(XMLUtils.saveFeature(feature, document.createElement("feature")));
        }
        return element;
    }
}

