/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.BrandingUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class OpenBrandingEditorAction
extends AbstractAction
implements ContextAwareAction {
    private final Lookup context;

    public OpenBrandingEditorAction() {
        this(Lookup.EMPTY);
    }

    private OpenBrandingEditorAction(Lookup context) {
        super(Bundle.LBL_OpenBrandingEditor());
        this.putValue("hideWhenDisabled", true);
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Project project = (Project)this.context.lookup(Project.class);
        MavenProject mavenProject = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        BrandingUtils.openBrandingEditor((String)mavenProject.getName(), (Project)project, (String)this.brandingPath(mavenProject));
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new OpenBrandingEditorAction(actionContext);
    }

    @Override
    public boolean isEnabled() {
        Project project = (Project)this.context.lookup(Project.class);
        if (project == null) {
            return false;
        }
        NbMavenProject mproject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (mproject == null) {
            return false;
        }
        return project.getProjectDirectory().getFileObject(this.brandingPath(mproject.getMavenProject())) != null;
    }

    private String brandingPath(MavenProject mavenProject) {
        String brandingPath = PluginPropertyUtils.getPluginProperty((MavenProject)mavenProject, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"brandingSources", (String)"branding");
        return brandingPath != null ? brandingPath : "src/main/nbm-branding";
    }
}

