/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.xml.namespace.QName;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.apisupport.AddOSGiParamToNbmPluginConfiguration;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.NbmWizardPanel;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.model.settings.Activation;
import org.netbeans.modules.maven.model.settings.Profile;
import org.netbeans.modules.maven.model.settings.Properties;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.netbeans.modules.maven.model.settings.SettingsQName;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class NbmWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    public static final String NBM_ARTIFACTID = "nbm_artifactId";
    static final Archetype NB_MODULE_ARCH = new Archetype();
    static final Archetype NB_APP_ARCH;
    static final Archetype NB_SUITE_ARCH;
    static final String OSGIDEPENDENCIES = "osgi.dependencies";
    static final String NB_VERSION = "nb.version";
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor wiz;
    private final Archetype archetype;

    private NbmWizardIterator(Archetype archetype) {
        this.archetype = archetype;
    }

    public static NbmWizardIterator createNbModuleIterator() {
        return new NbmWizardIterator(NB_MODULE_ARCH);
    }

    public static NbmWizardIterator createNbAppIterator() {
        return new NbmWizardIterator(NB_APP_ARCH);
    }

    public static NbmWizardIterator createNbSuiteIterator() {
        return new NbmWizardIterator(NB_SUITE_ARCH);
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] createPanels(ValidationGroup vg) {
        return new WizardDescriptor.Panel[]{ArchetypeWizards.basicWizardPanel((ValidationGroup)vg, (boolean)false, (Archetype)this.archetype), new NbmWizardPanel(vg, this.archetype)};
    }

    private String[] createSteps() {
        return new String[]{Bundle.LBL_CreateProjectStep2(), Bundle.LBL_CreateProjectStepNbm()};
    }

    public Set<FileObject> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        ProjectInfo vi = new ProjectInfo((String)this.wiz.getProperty("groupId"), (String)this.wiz.getProperty("artifactId"), (String)this.wiz.getProperty("version"), (String)this.wiz.getProperty("package"));
        ArchetypeWizards.logUsage((String)this.archetype.getGroupId(), (String)this.archetype.getArtifactId(), (String)this.archetype.getVersion());
        try {
            String nbm_artifactId = (String)this.wiz.getProperty(NBM_ARTIFACTID);
            int max = nbm_artifactId != null ? 7 : 4;
            handle.start(max);
            File projFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
            String version = (String)this.wiz.getProperty(NB_VERSION);
            Map<String, String> additional = version != null ? Collections.singletonMap("netbeansVersion", version) : null;
            ArchetypeWizards.createFromArchetype((ProgressHandle)handle, (File)projFile, (ProjectInfo)vi, (Archetype)this.archetype, additional, (int)0, (boolean)true);
            if (nbm_artifactId != null && projFile.exists()) {
                ProjectInfo nbm = new ProjectInfo(vi.groupId, nbm_artifactId, vi.version, vi.packageName);
                File nbm_folder = FileUtil.normalizeFile((File)new File(projFile, nbm_artifactId));
                ArchetypeWizards.createFromArchetype((ProgressHandle)handle, (File)nbm_folder, (ProjectInfo)nbm, (Archetype)NB_MODULE_ARCH, additional, (int)2, (boolean)true);
                NbmWizardIterator.trimInheritedFromNbmProject(nbm_folder);
                if (this.archetype == NB_APP_ARCH) {
                    File appDir = new File(projFile, "application");
                    NbmWizardIterator.addModuleToApplication(appDir, new ProjectInfo("${project.groupId}", nbm.artifactId, "${project.version}", nbm.packageName), null);
                }
            }
            if (Boolean.TRUE.equals(this.wiz.getProperty(OSGIDEPENDENCIES))) {
                NbmWizardIterator.addNbmPluginOsgiParameter(projFile);
            }
            if (this.archetype == NB_SUITE_ARCH) {
                FileObject settingsXml = FileUtil.toFileObject((File)MavenEmbedder.DEFAULT_USER_SETTINGS_FILE);
                if (settingsXml == null) {
                    settingsXml = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)"Maven2Templates/settings.xml"), (FileObject)FileUtil.createFolder((File)MavenEmbedder.DEFAULT_USER_SETTINGS_FILE.getParentFile()), (String)"settings");
                }
                Utilities.performSettingsModelOperations((FileObject)settingsXml, Collections.singletonList(new ModelOperation<SettingsModel>(){

                    public void performOperation(SettingsModel model) {
                        Profile netbeansIde = model.getSettings().findProfileById("netbeans-ide");
                        if (netbeansIde != null) {
                            return;
                        }
                        netbeansIde = model.getFactory().createProfile();
                        netbeansIde.setId("netbeans-ide");
                        Activation activation = model.getFactory().createActivation();
                        QName ACTIVE_BY_DEFAULT = SettingsQName.createQName((String)"activeByDefault", (boolean)true, (boolean)false);
                        activation.setChildElementText("activeByDefault", "true", ACTIVE_BY_DEFAULT);
                        netbeansIde.setActivation(activation);
                        Properties properties = model.getFactory().createProperties();
                        properties.setProperty("netbeans.installation", new File(System.getProperty("netbeans.home")).getParent());
                        netbeansIde.setProperties(properties);
                        model.getSettings().addProfile(netbeansIde);
                    }
                }));
            }
            Set projects = ArchetypeWizards.openProjects((File)projFile, (File)new File(projFile, "application"));
            for (FileObject project : projects) {
                NbMavenProject mprj;
                Project prj = ProjectManager.getDefault().findProject(project);
                if (prj != null && (mprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class)) != null) continue;
            }
            if ("SNAPSHOT".equals(version)) {
                NbmWizardIterator.addSnapshotRepo(projFile);
            }
            Templates.setDefinesMainProject((WizardDescriptor)this.wiz, (projects.size() > 1 ? 1 : 0) != 0);
            handle.progress(max);
            Set set = projects;
            return set;
        }
        finally {
            handle.finish();
        }
    }

    public void initialize(WizardDescriptor wiz) {
        this.index = 0;
        ValidationGroup vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz)});
        this.panels = this.createPanels(vg);
        this.wiz = wiz;
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public String name() {
        return Bundle.NameFormat(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private static void addNbmPluginOsgiParameter(File projFile) throws IOException {
        FileObject pom;
        FileObject prjDir = FileUtil.toFileObject((File)projFile);
        if (prjDir != null && (pom = prjDir.getFileObject("pom.xml")) != null) {
            Project prj = ProjectManager.getDefault().findProject(prjDir);
            if (prj == null) {
                return;
            }
            NbMavenProject mav = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
            AddOSGiParamToNbmPluginConfiguration op = new AddOSGiParamToNbmPluginConfiguration(true, mav.getMavenProject());
            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(op));
        }
    }

    private static void addSnapshotRepo(File projFile) throws IOException {
        FileObject pom;
        FileObject prjDir = FileUtil.toFileObject((File)projFile);
        if (prjDir != null && (pom = prjDir.getFileObject("pom.xml")) != null) {
            Project prj = ProjectManager.getDefault().findProject(prjDir);
            if (prj == null) {
                return;
            }
            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    Repository repo = model.getFactory().createRepository();
                    repo.setId("netbeans-snapshot");
                    repo.setName("NetBeans Snapshots");
                    repo.setUrl("http://bits.netbeans.org/netbeans/trunk/maven-snapshot/");
                    model.getProject().addRepository(repo);
                }
            }));
        }
    }

    private static void trimInheritedFromNbmProject(File projFile) throws IOException {
        FileObject pom;
        FileObject prjDir = FileUtil.toFileObject((File)projFile);
        if (prjDir != null && (pom = prjDir.getFileObject("pom.xml")) != null) {
            TrimInheritedFromNbmProject op = new TrimInheritedFromNbmProject();
            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(op));
        }
    }

    private static void addModuleToApplication(File file, ProjectInfo nbm, Object object) {
        FileObject appPrjFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (appPrjFO == null) {
            return;
        }
        ArrayList<ModelOperation> operations = new ArrayList<ModelOperation>();
        operations.add(ArchetypeWizards.addDependencyOperation((ProjectInfo)nbm, null));
        Utilities.performPOMModelOperations((FileObject)appPrjFO.getFileObject("pom.xml"), operations);
    }

    static {
        NB_MODULE_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        NB_MODULE_ARCH.setVersion("1.8");
        NB_MODULE_ARCH.setArtifactId("nbm-archetype");
        NB_APP_ARCH = new Archetype();
        NB_APP_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        NB_APP_ARCH.setVersion("1.9");
        NB_APP_ARCH.setArtifactId("netbeans-platform-app-archetype");
        NB_SUITE_ARCH = new Archetype();
        NB_SUITE_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        NB_SUITE_ARCH.setVersion("1.5");
        NB_SUITE_ARCH.setArtifactId("nbm-suite-root");
    }

    private static class TrimInheritedFromNbmProject
    implements ModelOperation<POMModel> {
        private TrimInheritedFromNbmProject() {
        }

        public void performOperation(POMModel model) {
            List deps;
            Build b;
            List pr;
            org.netbeans.modules.maven.model.pom.Project p = model.getProject();
            p.setGroupId(null);
            p.setVersion(null);
            List reps = p.getRepositories();
            if (reps != null) {
                for (Repository r : reps) {
                    p.removeRepository(r);
                }
            }
            if ((pr = p.getPluginRepositories()) != null) {
                for (Repository r : pr) {
                    p.removePluginRepository(r);
                }
            }
            if ((b = p.getBuild()) != null) {
                Plugin pl = b.findPluginById("org.codehaus.mojo", "nbm-maven-plugin");
                if (pl != null) {
                    pl.setConfiguration(null);
                    pl.setVersion(null);
                }
                if ((pl = b.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin")) != null) {
                    b.removePlugin(pl);
                }
                if ((pl = b.findPluginById("org.apache.maven.plugins", "maven-jar-plugin")) != null) {
                    pl.setVersion(null);
                }
            }
            if ((deps = p.getDependencies()) != null) {
                for (Dependency d : deps) {
                    if (!d.getGroupId().startsWith("org.netbeans")) continue;
                    d.setVersion("${netbeans.version}");
                }
            }
        }
    }
}

