/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.catalog;

import java.awt.Dialog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Enumeration;
import org.netbeans.modules.mobility.cldcplatform.wizard.InstallerIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutionEngine;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class PlatformCatalogAutoInstaller
implements Runnable,
FileChangeListener,
LookupListener {
    private final RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);
    private final FileObject fo = FileUtil.getConfigFile((String)"platform_installers");
    private final Lookup.Result res;
    private static final String TEMPLATE = "Templates/Services/Platforms/org-netbeans-api-java-Platform/javaplatform.xml";
    private static final String STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";

    public PlatformCatalogAutoInstaller() {
        assert (this.fo != null);
        this.fo.addFileChangeListener((FileChangeListener)this);
        this.res = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        this.res.allInstances();
        this.res.addLookupListener((LookupListener)this);
        this.res.allInstances();
        FileUtil.getConfigFile((String)"Modules").addFileChangeListener((FileChangeListener)this);
    }

    @Override
    public void run() {
        Enumeration en;
        boolean onceMore = false;
        this.fo.refresh(true);
        boolean success = false;
        while ((en = this.fo.getData(false)).hasMoreElements()) {
            try {
                FileObject instFo = (FileObject)en.nextElement();
                final File inst = FileUtil.toFile((FileObject)instFo);
                if (Utilities.getOperatingSystem() == 16 || Utilities.getOperatingSystem() == 8) {
                    Runtime.getRuntime().exec(new String[]{"chmod", "+x", inst.getAbsolutePath()}).waitFor();
                }
                final InputOutput io = IOProvider.getDefault().getIO(inst.getName(), false);
                io.setErrSeparated(false);
                io.setErrVisible(true);
                io.setInputVisible(true);
                io.setOutputVisible(true);
                io.setFocusTaken(true);
                success = ExecutionEngine.getDefault().execute(inst.getName(), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String[] args = Utilities.getOperatingSystem() == 262144 ? new String[]{"cmd.exe", "/c", inst.getAbsolutePath()} : new String[]{inst.getAbsolutePath()};
                            Process p = Runtime.getRuntime().exec(args);
                            RequestProcessor streamPumpsProcessor = new RequestProcessor("Platform Catalog Auto Installer Stream Pumps", 3);
                            streamPumpsProcessor.post((Runnable)new StreamPumper(io.getIn(), new OutputStreamWriter(p.getOutputStream())));
                            streamPumpsProcessor.post((Runnable)new StreamPumper(new InputStreamReader(p.getInputStream()), (Writer)io.getOut()));
                            streamPumpsProcessor.post((Runnable)new StreamPumper(new InputStreamReader(p.getErrorStream()), (Writer)io.getErr()));
                            p.waitFor();
                        }
                        catch (Exception e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                }, null).result() == 0 | success;
                if (!inst.delete()) {
                    instFo.delete();
                }
                this.fo.refresh(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                onceMore = true;
            }
        }
        if (success) {
            this.launchAddPlatformWizard();
        }
        if (onceMore) {
            this.task.schedule(400);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchAddPlatformWizard() {
        try {
            WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)InstallerIterator.getDefault());
            DataObject template = DataObject.find((FileObject)FileUtil.getConfigFile((String)TEMPLATE));
            wiz.putProperty("targetTemplate", (Object)template);
            DataFolder folder = DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)STORAGE));
            wiz.putProperty("targetFolder", (Object)folder);
            wiz.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
            wiz.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
            wiz.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
            wiz.setTitle(NbBundle.getMessage(PlatformCatalogAutoInstaller.class, (String)"CTL_AddPlatformTitle"));
            wiz.setTitleFormat(new MessageFormat("{0}"));
            Dialog dlg = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wiz);
            try {
                dlg.setVisible(true);
                wiz.getValue();
            }
            finally {
                dlg.dispose();
            }
        }
        catch (DataObjectNotFoundException dfne) {
            ErrorManager.getDefault().notify((Throwable)dfne);
        }
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        this.task.schedule(400);
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void resultChanged(LookupEvent ev) {
        this.task.schedule(400);
    }

    private static class StreamPumper
    implements Runnable {
        private final Reader in;
        private final Writer out;

        public StreamPumper(Reader in, Writer out) {
            this.in = in;
            this.out = new BufferedWriter(out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int i;
                while ((i = this.in.read()) >= 0) {
                    this.out.write(i);
                    this.out.flush();
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
        }
    }
}

