/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.util.FileUtils;

public class IndexUtils {
    public static final String TIMESTAMP_FILE = "timestamp";
    private static final int BUFFER_SIZE = 16384;

    public static void copyDirectory(Directory source, Directory target) throws IOException {
        Directory.copy((Directory)source, (Directory)target, (boolean)false);
        IndexUtils.copyFile(source, target, "nexus-maven-repository-index-updater.properties");
        IndexUtils.copyFile(source, target, "nexus-maven-repository-index-packer.properties");
        Date ts = IndexUtils.getTimestamp(source);
        IndexUtils.updateTimestamp(target, ts);
    }

    public static boolean copyFile(Directory source, Directory target, String name) throws IOException {
        return IndexUtils.copyFile(source, target, name, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(Directory source, Directory target, String srcName, String targetName) throws IOException {
        boolean bl;
        if (!source.fileExists(srcName)) {
            return false;
        }
        byte[] buf = new byte[16384];
        IndexInput is = null;
        IndexOutput os = null;
        try {
            int toRead;
            is = source.openInput(srcName);
            os = target.createOutput(targetName);
            long len = is.length();
            for (long readCount = 0L; readCount < len; readCount += (long)toRead) {
                toRead = readCount + 16384L > len ? (int)(len - readCount) : 16384;
                is.readBytes(buf, 0, toRead);
                os.writeBytes(buf, toRead);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            IndexUtils.close(os);
            IndexUtils.close(is);
            throw throwable;
        }
        IndexUtils.close(os);
        IndexUtils.close(is);
        return bl;
    }

    public static ArtifactInfo constructArtifactInfo(Document doc, IndexingContext context) {
        if (doc.get(ArtifactInfo.UINFO) == null) {
            return null;
        }
        boolean res = false;
        ArtifactInfo artifactInfo = new ArtifactInfo();
        for (IndexCreator ic : context.getIndexCreators()) {
            res |= ic.updateArtifactInfo(doc, artifactInfo);
        }
        return res ? artifactInfo : null;
    }

    public static Document updateDocument(Document doc, IndexingContext context) {
        return IndexUtils.updateDocument(doc, context, true);
    }

    public static Document updateDocument(Document doc, IndexingContext context, boolean updateLastModified) {
        ArtifactInfo ai = IndexUtils.constructArtifactInfo(doc, context);
        if (ai == null) {
            return doc;
        }
        Document document = new Document();
        document.add((Fieldable)new Field(ArtifactInfo.UINFO, ai.getUinfo(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (updateLastModified || doc.getField(ArtifactInfo.LAST_MODIFIED) == null) {
            document.add((Fieldable)new Field(ArtifactInfo.LAST_MODIFIED, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
        } else {
            document.add((Fieldable)doc.getField(ArtifactInfo.LAST_MODIFIED));
        }
        for (IndexCreator ic : context.getIndexCreators()) {
            ic.updateDocument(ai, document);
        }
        return document;
    }

    public static void deleteTimestamp(Directory directory) throws IOException {
        if (directory.fileExists(TIMESTAMP_FILE)) {
            directory.deleteFile(TIMESTAMP_FILE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTimestamp(Directory directory, Date timestamp) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            Date currentTimestamp = IndexUtils.getTimestamp(directory);
            if (!(timestamp == null || currentTimestamp != null && currentTimestamp.equals(timestamp))) {
                IndexUtils.deleteTimestamp(directory);
                IndexOutput io = directory.createOutput(TIMESTAMP_FILE);
                try {
                    io.writeLong(timestamp.getTime());
                    io.flush();
                }
                finally {
                    IndexUtils.close(io);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getTimestamp(Directory directory) {
        Directory directory2 = directory;
        synchronized (directory2) {
            Date result;
            block8: {
                result = null;
                try {
                    if (!directory.fileExists(TIMESTAMP_FILE)) break block8;
                    IndexInput ii = null;
                    try {
                        ii = directory.openInput(TIMESTAMP_FILE);
                        result = new Date(ii.readLong());
                    }
                    finally {
                        IndexUtils.close(ii);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    public static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(IndexOutput io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(IndexInput in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(IndexReader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(IndexWriter w) {
        if (w != null) {
            try {
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Directory d) {
        if (d != null) {
            try {
                d.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void delete(File indexDir) {
        try {
            FileUtils.deleteDirectory((File)indexDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

