/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.DOMHelper;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Element;

public class SpringHelper {
    private static final String BEAN_TAG = "bean";
    private static final String ANNOTATION_DRIVEN_TAG = "tx:annotation-driven";
    private static final String PROPERTY_TAG = "property";
    private static final String PROPS_TAG = "props";
    private static final String PROP_TAG = "prop";
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String REF_ATTR = "ref";
    private static final String KEY_ATTR = "key";
    private static final String EMF_ID = "entityManagerFactory";
    private static final String TXM_ID = "transactionManager";
    private static final String EMF_CLASS = "org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean";
    private static final String SIMPLE_EMF_CLASS = "org.springframework.orm.jpa.LocalEntityManagerFactoryBean";
    private static final String DATA_SOURCE_CLASS = "org.springframework.jdbc.datasource.DriverManagerDataSource";
    private static final String WEAVER_CLASS = "org.springframework.instrument.classloading.glassfish.GlassFishLoadTimeWeaver";
    private static final String JPA_ADAPTER_CLASS = "org.springframework.orm.jpa.vendor.TopLinkJpaVendorAdapter";
    private static final String JTA_TXM_CLASS = "org.springframework.transaction.jta.JtaTransactionManager";
    private static final String JPA_TXM_CLASS = "org.springframework.orm.jpa.JpaTransactionManager";
    private static final String DATABASE_PLATFORM_CLASS = "oracle.toplink.essentials.platform.database.DerbyPlatform";
    private static final String PERSISTENCE_ANNOTATION_POST_PROCESSOR_CLASS = "org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor";
    private static final String HIBERNATE_TRANSACTION_FACTORY_CLASS = "org.hibernate.transaction.JTATransactionFactory";
    private static final String HIBERANTE_TRANSACTION_LOOKUP_CLASS = "org.hibernate.transaction.SunONETransactionManagerLookup";
    private static final String PERSISTENCE_UNIT_NAME_PROP = "persistenceUnitName";
    private static final String DATA_SOURCE_PROP = "dataSource";
    private static final String DRIVER_CLASS_NAME_PROP = "driverClassName";
    private static final String URL_PROP = "url";
    private static final String USER_NAME_PROP = "username";
    private static final String PASSWORD_PROP = "password";
    private static final String LOAD_TIME_WEAVER_PROP = "loadTimeWeaver";
    private static final String JPA_VENDOR_ADAPTER_PROP = "jpaVendorAdapter";
    private static final String JPA_PROPERTIES_PROP = "jpaProperties";
    private static final String DATABASE_PLATFORM_PROP = "databasePlatform";
    private static final String SHOW_SQL_PROP = "showSql";
    private static final String GENERATE_DDL_PROP = "generateDdl";
    private static final String HIBERNATE_TRANSACTION_FACTORY_CLASS_PROP = "hibernate.transaction.factory_class";
    private static final String HIBERANTE_TRANSACTION_LOOKUP_CLASS_PROP = "hibernate.transaction.manager_lookup_class";
    private static final String HIBERNATE_PROVIDER = "org.hibernate.ejb.HibernatePersistence";
    private Project project;
    private PersistenceHelper.PersistenceUnit pu;
    private DOMHelper helper;
    private boolean generateDdl;

    public SpringHelper(Project project, PersistenceHelper.PersistenceUnit persistenceUnit) {
        this.project = project;
        this.pu = persistenceUnit;
        this.generateDdl = false;
    }

    public void configure() {
        Element element;
        FileObject fileObject = this.getApplicationContextXml(this.project);
        if (fileObject == null) {
            return;
        }
        this.helper = new DOMHelper(fileObject);
        Element element2 = this.helper.findElementById(EMF_ID);
        if (element2 != null) {
            return;
        }
        boolean bl = RestUtils.hasJTASupport(this.project);
        if (bl) {
            element2 = this.createBean(EMF_ID, EMF_CLASS);
            element2.appendChild(this.createProperty(PERSISTENCE_UNIT_NAME_PROP, this.pu.getName()));
            element = this.createJpaProperties();
            if (element != null) {
                element2.appendChild(element);
            }
        } else {
            element2 = this.createBean(EMF_ID, SIMPLE_EMF_CLASS);
            element2.appendChild(this.createProperty(PERSISTENCE_UNIT_NAME_PROP, this.pu.getName()));
        }
        this.helper.appendChild(element2);
        if (bl) {
            this.helper.appendChild(this.createBean(TXM_ID, JTA_TXM_CLASS));
        } else {
            element = this.createBean(TXM_ID, JPA_TXM_CLASS);
            element.appendChild(this.createProperty(EMF_ID, EMF_ID, true));
            this.helper.appendChild(element);
        }
        this.helper.appendChild(this.createBean(null, PERSISTENCE_ANNOTATION_POST_PROCESSOR_CLASS));
        this.helper.appendChild(this.helper.createElement(ANNOTATION_DRIVEN_TAG));
        this.helper.save();
    }

    private FileObject getApplicationContextXml(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.getApplicationContextXml();
        }
        return null;
    }

    private Element createBean(String string, String string2) {
        Element element = this.helper.createElement(BEAN_TAG);
        if (string != null) {
            element.setAttribute(ID_ATTR, string);
        }
        if (string2 != null) {
            element.setAttribute(CLASS_ATTR, string2);
        }
        return element;
    }

    private Element createProperty(String string, String string2) {
        return this.createProperty(string, string2, false);
    }

    private Element createProperty(String string, String string2, boolean bl) {
        Element element = this.helper.createElement(PROPERTY_TAG);
        element.setAttribute(NAME_ATTR, string);
        if (string2 != null) {
            if (bl) {
                element.setAttribute(REF_ATTR, string2);
            } else {
                element.setAttribute(VALUE_ATTR, string2);
            }
        }
        return element;
    }

    private Element createDataSourceProperty() {
        Element element = this.createProperty(DATA_SOURCE_PROP, null);
        Element element2 = this.createBean(null, DATA_SOURCE_CLASS);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Datasource datasource = this.pu.getDatasource();
        if (datasource != null) {
            string = datasource.getUrl();
            string2 = datasource.getUsername();
            string3 = datasource.getPassword();
            string4 = datasource.getDriverClassName();
        }
        element2.appendChild(this.createProperty(DRIVER_CLASS_NAME_PROP, string4));
        element2.appendChild(this.createProperty(URL_PROP, string));
        element2.appendChild(this.createProperty(USER_NAME_PROP, string2));
        element2.appendChild(this.createProperty(PASSWORD_PROP, string3));
        element.appendChild(element2);
        return element;
    }

    private Element createWeaverProperty() {
        Element element = this.createProperty(LOAD_TIME_WEAVER_PROP, null);
        element.appendChild(this.createBean(null, WEAVER_CLASS));
        return element;
    }

    private Element createJpaVendorAdapterProperty() {
        Element element = this.createProperty(JPA_VENDOR_ADAPTER_PROP, null);
        Element element2 = this.createBean(null, JPA_ADAPTER_CLASS);
        element2.appendChild(this.createProperty(DATABASE_PLATFORM_PROP, DATABASE_PLATFORM_CLASS));
        element2.appendChild(this.createProperty(SHOW_SQL_PROP, "true"));
        element2.appendChild(this.createProperty(GENERATE_DDL_PROP, String.valueOf(this.generateDdl)));
        element.appendChild(element2);
        return element;
    }

    private Element createJpaProperties() {
        Element element = null;
        if (HIBERNATE_PROVIDER.equals(this.pu.getProvider())) {
            element = this.createProperty(JPA_PROPERTIES_PROP, null);
            Element element2 = this.helper.createElement(PROPS_TAG);
            Element element3 = this.helper.createElement(PROP_TAG, HIBERNATE_TRANSACTION_FACTORY_CLASS);
            element3.setAttribute(KEY_ATTR, HIBERNATE_TRANSACTION_FACTORY_CLASS_PROP);
            element2.appendChild(element3);
            element3 = this.helper.createElement(PROP_TAG, HIBERANTE_TRANSACTION_LOOKUP_CLASS);
            element3.setAttribute(KEY_ATTR, HIBERANTE_TRANSACTION_LOOKUP_CLASS_PROP);
            element2.appendChild(element3);
            element.appendChild(element2);
        }
        return element;
    }
}

