/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.DOMHelper;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PersistenceHelper {
    private static final String PERSISTENCE_UNIT_TAG = "persistence-unit";
    private static final String PROPERTIES_TAG = "properties";
    private static final String NAME_ATTR = "name";
    private static final String EXCLUDE_UNLISTED_CLASSES_TAG = "exclude-unlisted-classes";
    private static final String TRANSACTION_TYPE_ATTR = "transaction-type";
    private static final String RESOURCE_LOCAL_VALUE = "RESOURCE_LOCAL";
    private static final String JTA_DATA_SOURCE_TAG = "jta-data-source";
    private static final String NON_JTA_DATA_SOURCE_TAG = "non-jta-data-source";
    private static final String CLASS_TAG = "class";
    private static final String PROVIDER_TAG = "provider";
    private static final String DEFAULT_GFV2_PROVIDER = "oracle.toplink.essentials.PersistenceProvider";
    private static final String DEFAULT_GFV3_PROVIDER = "org.eclipse.persistence.jpa.PersistenceProvider";
    private Project project;
    private DOMHelper helper;

    public PersistenceHelper(Project project) {
        this.project = project;
        FileObject fileObject = this.getPersistenceXML();
        if (fileObject != null) {
            this.helper = new DOMHelper(fileObject);
        }
    }

    public PersistenceUnit getPersistenceUnit() {
        Element element;
        if (this.helper != null && (element = this.helper.findElement(PERSISTENCE_UNIT_TAG)) != null) {
            Attr attr = element.getAttributeNode(NAME_ATTR);
            String string = attr == null ? null : attr.getValue();
            NodeList nodeList = element.getElementsByTagName(PROVIDER_TAG);
            String string2 = nodeList.getLength() > 0 ? this.helper.getValue((Element)nodeList.item(0)) : (RestUtils.isServerGFV3(this.project) ? DEFAULT_GFV3_PROVIDER : DEFAULT_GFV3_PROVIDER);
            Datasource datasource = null;
            NodeList nodeList2 = element.getElementsByTagName(JTA_DATA_SOURCE_TAG);
            if (nodeList2.getLength() > 0) {
                Element element2 = (Element)nodeList2.item(0);
                String string3 = this.helper.getValue(element2);
                datasource = RestUtils.getDatasource(this.project, string3);
            }
            return new PersistenceUnit(string, string2, datasource);
        }
        return null;
    }

    public void configure(Collection<String> collection, boolean bl) throws IOException {
        if (this.helper == null) {
            return;
        }
        if (RestUtils.isServerTomcat(this.project)) {
            this.unsetExcludeEnlistedClasses();
            this.addEntityClasses(collection);
        }
        if (bl) {
            this.switchToResourceLocalTransaction();
        }
        this.helper.save();
    }

    private void unsetExcludeEnlistedClasses() throws IOException {
        Element element = this.helper.findElement(PERSISTENCE_UNIT_TAG);
        NodeList nodeList = element.getElementsByTagName(EXCLUDE_UNLISTED_CLASSES_TAG);
        if (nodeList.getLength() > 0) {
            this.helper.setValue((Element)nodeList.item(0), "false");
        } else {
            element.insertBefore(this.helper.createElement(EXCLUDE_UNLISTED_CLASSES_TAG, "false"), this.helper.findElement(PROPERTIES_TAG));
        }
    }

    private void switchToResourceLocalTransaction() throws IOException {
        Element element = this.helper.findElement(PERSISTENCE_UNIT_TAG);
        element.setAttribute(TRANSACTION_TYPE_ATTR, RESOURCE_LOCAL_VALUE);
        NodeList nodeList = element.getElementsByTagName(JTA_DATA_SOURCE_TAG);
        String string = null;
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            string = this.helper.getValue(element2);
            Element element3 = this.helper.createElement(NON_JTA_DATA_SOURCE_TAG, string);
            element.replaceChild(element3, element2);
        }
    }

    private void addEntityClasses(Collection<String> collection) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        Element element = this.helper.findElement(PERSISTENCE_UNIT_TAG);
        NodeList nodeList = element.getElementsByTagName(CLASS_TAG);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            arrayList.remove(this.helper.getValue((Element)nodeList.item(i)));
        }
        for (String string : arrayList) {
            element.insertBefore(this.helper.createElement(CLASS_TAG, string), this.helper.findElement(EXCLUDE_UNLISTED_CLASSES_TAG));
        }
    }

    private FileObject getPersistenceXML() {
        RestSupport restSupport = RestUtils.getRestSupport(this.project);
        if (restSupport != null) {
            return restSupport.getPersistenceXml();
        }
        return null;
    }

    public static class PersistenceUnit {
        private String name;
        private String provider;
        private Datasource datasource;

        public PersistenceUnit(String string, String string2, Datasource datasource) {
            this.name = string;
            this.provider = string2;
            this.datasource = datasource;
        }

        public String getName() {
            return this.name;
        }

        public String getProvider() {
            return this.provider;
        }

        public Datasource getDatasource() {
            return this.datasource;
        }
    }
}

