/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.maven.indexer.Bundle;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.util.Cancellable;

public class RemoteIndexTransferListener
implements TransferListener,
Cancellable {
    @NonNull
    private final ProgressHandle handle;
    private final RepositoryInfo info;
    private int lastunit;
    private int units;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private final AtomicBoolean unpacking = new AtomicBoolean();
    private static Map<Thread, Integer> transfers = new HashMap<Thread, Integer>();
    private static final Object TRANSFERS_LOCK = new Object();

    public RemoteIndexTransferListener(RepositoryInfo info) {
        this.info = info;
        Cancellation.register(this);
        this.handle = ProgressHandleFactory.createHandle((String)Bundle.LBL_Transfer(info.getName()), (Cancellable)this);
        this.handle.start();
    }

    public void transferInitiated(TransferEvent arg0) {
        this.checkCancel();
    }

    public void transferStarted(TransferEvent arg0) {
        this.checkCancel();
        long contentLength = arg0.getResource().getContentLength();
        this.units = (int)contentLength / 1024;
        this.handle.switchToDeterminate(this.units);
    }

    public boolean cancel() {
        return this.canceled.compareAndSet(false, true);
    }

    private void checkCancel() throws Cancellation {
        if (this.canceled.get()) {
            throw new Cancellation();
        }
    }

    public void transferProgress(TransferEvent arg0, byte[] arg1, int arg2) {
        this.checkCancel();
        int work = arg2 / 1024;
        this.handle.progress(arg0.getResource().getName(), Math.min(this.units, this.lastunit += work));
    }

    public void transferCompleted(TransferEvent arg0) {
        this.handle.switchToIndeterminate();
    }

    public void transferError(TransferEvent arg0) {
        this.handle.switchToIndeterminate();
    }

    public void debug(String arg0) {
        this.checkCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToActive(Thread t) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer count = transfers.get(t);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            transfers.put(t, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromActive(Thread t) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer count = transfers.get(t);
            if (count == null) {
                return;
            }
            if (count <= 1) {
                transfers.remove(t);
            } else {
                count = count - 1;
                transfers.put(t, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Thread> getActiveTransfersOrScans() {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            return transfers.keySet();
        }
    }

    void unpackingProgress(String label) {
        this.checkCancel();
        if (this.unpacking.compareAndSet(false, true)) {
            this.handle.setDisplayName(Bundle.LBL_unpacking(this.info.getName()));
        }
        this.handle.progress(label);
    }

    void close() {
        this.handle.finish();
    }
}

