/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.artifact;

import org.apache.maven.index.artifact.VersionUtils;

public class Gav {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String baseVersion;
    private final String classifier;
    private final String extension;
    private final Integer snapshotBuildNumber;
    private final Long snapshotTimeStamp;
    private final String name;
    private final boolean snapshot;
    private final boolean hash;
    private final HashType hashType;
    private final boolean signature;
    private final SignatureType signatureType;

    public Gav(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null, null, null, null, false, null, false, null);
    }

    public Gav(String groupId, String artifactId, String version, String classifier, String extension, Integer snapshotBuildNumber, Long snapshotTimeStamp, String name, boolean snapshot, boolean hash, HashType hashType, boolean signature, SignatureType signatureType) {
        this(groupId, artifactId, version, classifier, extension, snapshotBuildNumber, snapshotTimeStamp, name, hash, hashType, signature, signatureType);
    }

    public Gav(String groupId, String artifactId, String version, String classifier, String extension, Integer snapshotBuildNumber, Long snapshotTimeStamp, String name, boolean hash, HashType hashType, boolean signature, SignatureType signatureType) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.snapshot = VersionUtils.isSnapshot(version);
        if (!this.snapshot) {
            this.baseVersion = null;
        } else if (version.contains("SNAPSHOT")) {
            this.baseVersion = null;
        } else {
            String tempBaseVersion = version.substring(0, version.lastIndexOf(45));
            this.baseVersion = (tempBaseVersion = tempBaseVersion.substring(0, tempBaseVersion.length() - 15)).length() > 0 ? tempBaseVersion + "SNAPSHOT" : "SNAPSHOT";
        }
        this.classifier = classifier;
        this.extension = extension;
        this.snapshotBuildNumber = snapshotBuildNumber;
        this.snapshotTimeStamp = snapshotTimeStamp;
        this.name = name;
        this.hash = hash;
        this.hashType = hashType;
        this.signature = signature;
        this.signatureType = signatureType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBaseVersion() {
        if (this.baseVersion == null) {
            return this.getVersion();
        }
        return this.baseVersion;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public Integer getSnapshotBuildNumber() {
        return this.snapshotBuildNumber;
    }

    public Long getSnapshotTimeStamp() {
        return this.snapshotTimeStamp;
    }

    public boolean isHash() {
        return this.hash;
    }

    public HashType getHashType() {
        return this.hashType;
    }

    public boolean isSignature() {
        return this.signature;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.baseVersion == null ? 0 : this.baseVersion.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.snapshot ? 1231 : 1237);
        result = 31 * result + (this.snapshotBuildNumber == null ? 0 : this.snapshotBuildNumber.hashCode());
        result = 31 * result + (this.snapshotTimeStamp == null ? 0 : this.snapshotTimeStamp.hashCode());
        result = 31 * result + (this.hash ? 1231 : 1237);
        result = 31 * result + (this.hashType == null ? 0 : this.hashType.hashCode());
        result = 31 * result + (this.signature ? 1231 : 1237);
        result = 31 * result + (this.signatureType == null ? 0 : this.signatureType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Gav other = (Gav)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.baseVersion == null ? other.baseVersion != null : !this.baseVersion.equals(other.baseVersion)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.snapshot != other.snapshot) {
            return false;
        }
        if (this.snapshotBuildNumber == null ? other.snapshotBuildNumber != null : !this.snapshotBuildNumber.equals(other.snapshotBuildNumber)) {
            return false;
        }
        if (this.snapshotTimeStamp == null ? other.snapshotTimeStamp != null : !this.snapshotTimeStamp.equals(other.snapshotTimeStamp)) {
            return false;
        }
        if (this.hash != other.hash) {
            return false;
        }
        if (this.hashType == null ? other.hashType != null : !this.hashType.equals((Object)other.hashType)) {
            return false;
        }
        if (this.signature != other.signature) {
            return false;
        }
        return !(this.signatureType == null ? other.signatureType != null : !this.signatureType.equals((Object)other.signatureType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignatureType {
        gpg;


        public String toString() {
            switch (this) {
                case gpg: {
                    return "asc";
                }
            }
            return "unknown-signature-type";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HashType {
        sha1,
        md5;

    }
}

