/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.artifact;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactPackagingMapper.class)
public class DefaultArtifactPackagingMapper
extends AbstractLogEnabled
implements ArtifactPackagingMapper {
    public static final String MAPPING_PROPERTIES_FILE = "packaging2extension-mapping.properties";
    private File propertiesFile;
    private Map<String, String> packaging2extensionMapping;
    private static final Map<String, String> defaults = new HashMap<String, String>();

    @Override
    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
        this.packaging2extensionMapping = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, String> getPackaging2extensionMapping() {
        block6: {
            block7: {
                FileInputStream fis;
                block5: {
                    if (this.packaging2extensionMapping != null) break block6;
                    this.packaging2extensionMapping = new HashMap<String, String>();
                    this.packaging2extensionMapping.putAll(defaults);
                    if (this.propertiesFile == null || !this.propertiesFile.exists()) break block7;
                    this.getLogger().info("Found user artifact packaging mapping file, applying it...");
                    Properties userMappings = new Properties();
                    fis = null;
                    try {
                        fis = new FileInputStream(this.propertiesFile);
                        userMappings.load(fis);
                        if (userMappings.keySet().size() <= 0) break block5;
                        for (Object key : userMappings.keySet()) {
                            this.packaging2extensionMapping.put(key.toString(), userMappings.getProperty(key.toString()));
                        }
                        this.getLogger().info(this.propertiesFile.getAbsolutePath() + " user artifact packaging mapping file contained " + userMappings.keySet().size() + " mappings, applied them all succesfully.");
                    }
                    catch (IOException e) {
                        try {
                            this.getLogger().warn("Got IO exception during read of file: " + this.propertiesFile.getAbsolutePath());
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(fis);
                            throw throwable;
                        }
                        IOUtil.close((InputStream)fis);
                        break block6;
                    }
                }
                IOUtil.close((InputStream)fis);
                break block6;
            }
            this.getLogger().debug("User artifact packaging mappings file not found, will work with defaults...");
        }
        return this.packaging2extensionMapping;
    }

    public void setPackaging2extensionMapping(Map<String, String> packaging2extensionMapping) {
        this.packaging2extensionMapping = packaging2extensionMapping;
    }

    public Map<String, String> getDefaults() {
        return defaults;
    }

    @Override
    public String getExtensionForPackaging(String packaging) {
        if (packaging == null) {
            return "jar";
        }
        if (this.getPackaging2extensionMapping().containsKey(packaging)) {
            return this.getPackaging2extensionMapping().get(packaging);
        }
        return packaging;
    }

    static {
        defaults.put("ejb-client", "jar");
        defaults.put("ejb", "jar");
        defaults.put("rar", "jar");
        defaults.put("par", "jar");
        defaults.put("maven-plugin", "jar");
        defaults.put("maven-archetype", "jar");
        defaults.put("plexus-application", "jar");
        defaults.put("eclipse-plugin", "jar");
        defaults.put("eclipse-feature", "jar");
        defaults.put("eclipse-application", "zip");
        defaults.put("nexus-plugin", "jar");
        defaults.put("java-source", "jar");
        defaults.put("javadoc", "jar");
        defaults.put("test-jar", "jar");
    }
}

