/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryImplementation;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WLServerLibrarySupport {
    private static final Logger LOGGER = Logger.getLogger(WLServerLibrarySupport.class.getName());
    private static final FilenameFilter LIBRARY_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear");
        }
    };
    private static final FilenameFilter JAR_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };
    private final File domainPath;
    private final File serverRoot;

    public WLServerLibrarySupport(WLDeploymentManager dm) {
        String domainDir = dm.getInstanceProperties().getProperty("domainRoot");
        assert (domainDir != null);
        String serverDir = dm.getInstanceProperties().getProperty("serverRoot");
        assert (serverDir != null);
        this.domainPath = new File(domainDir);
        this.serverRoot = new File(serverDir);
    }

    public WLServerLibrarySupport(File serverRoot, File domainPath) {
        this.domainPath = domainPath;
        this.serverRoot = serverRoot;
    }

    public Map<ServerLibrary, List<File>> getClasspathEntries(Set<ServerLibraryDependency> libraries) throws ConfigurationException {
        Set<WLServerLibrary> deployed = this.getDeployedLibraries();
        HashSet<WLServerLibrary> classpath = new HashSet<WLServerLibrary>();
        block0: for (ServerLibraryDependency range : libraries) {
            for (WLServerLibrary lib : deployed) {
                if (!range.versionMatches(ServerLibraryFactory.createServerLibrary((ServerLibraryImplementation)lib))) continue;
                classpath.add(lib);
                continue block0;
            }
        }
        HashMap<ServerLibrary, List<File>> result = new HashMap<ServerLibrary, List<File>>();
        for (WLServerLibrary lib : classpath) {
            File[] subDirs;
            String server = lib.getServer();
            File tmpPath = new File(this.domainPath, "servers" + File.separator + server + File.separator + "tmp" + File.separator + "_WL_user" + File.separator + lib.getName());
            if (!tmpPath.exists() || !tmpPath.isDirectory() || (subDirs = tmpPath.listFiles()) == null) continue;
            for (File subdir : subDirs) {
                File[] children;
                File webInfLib;
                WLServerLibrary parsed = WLServerLibrarySupport.readFromFile(subdir);
                if (parsed == null || !WLServerLibrarySupport.sameLibraries(lib, parsed) || !(webInfLib = new File(subdir, "WEB-INF" + File.separator + "lib")).exists() || !webInfLib.isDirectory() || (children = webInfLib.listFiles(JAR_FILTER)) == null) continue;
                result.put(ServerLibraryFactory.createServerLibrary((ServerLibraryImplementation)lib), Arrays.asList(children));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<WLServerLibrary> getDeployedLibraries() {
        HashSet<WLServerLibrary> hashSet;
        FileObject domainConfig = WLPluginProperties.getDomainConfigFileObject(this.domainPath);
        if (domainConfig == null) {
            return Collections.emptySet();
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        LibraryHandler handler = new LibraryHandler(this.domainPath);
        BufferedInputStream is = new BufferedInputStream(domainConfig.getInputStream());
        try {
            parser.parse((InputStream)is, (DefaultHandler)handler);
            HashSet<WLServerLibrary> libs = new HashSet<WLServerLibrary>();
            for (Library library : handler.getLibraries()) {
                File file = library.resolveFile();
                WLServerLibrary parsed = WLServerLibrarySupport.readFromFile(file);
                if (parsed != null) {
                    if (!(parsed.getSpecificationVersion() == library.getSpecificationVersion() || parsed.getSpecificationVersion() != null && parsed.getSpecificationVersion().equals((Object)library.getSpecificationVersion()))) {
                        LOGGER.log(Level.INFO, "Inconsistent specification version for {0}", library.getName());
                        continue;
                    }
                    if (!(parsed.getImplementationVersion() == library.getImplementationVersion() || parsed.getImplementationVersion() != null && parsed.getImplementationVersion().equals((Object)library.getImplementationVersion()))) {
                        LOGGER.log(Level.INFO, "Inconsistent implementation version for {0}", library.getName());
                        continue;
                    }
                    libs.add(new WLServerLibrary(parsed.getSpecificationTitle(), parsed.getSpecificationVersion(), parsed.getImplementationTitle(), parsed.getImplementationVersion(), library.getTarget(), library.getName()));
                    continue;
                }
                LOGGER.log(Level.INFO, "Source path does not exists for {0}", library.getName());
                libs.add(new WLServerLibrary(null, library.getSpecificationVersion(), null, library.getImplementationVersion(), library.getTarget(), library.getName()));
            }
            hashSet = libs;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException ex) {
                return Collections.emptySet();
            }
            catch (ParserConfigurationException ex) {
                return Collections.emptySet();
            }
            catch (SAXException ex) {
                return Collections.emptySet();
            }
        }
        ((InputStream)is).close();
        return hashSet;
    }

    Map<ServerLibrary, File> getDeployableFiles() {
        File libPath = FileUtil.normalizeFile((File)new File(this.serverRoot, "common" + File.separator + "deployable-libraries"));
        if (!libPath.exists() || !libPath.isDirectory()) {
            return Collections.emptyMap();
        }
        HashMap<ServerLibrary, File> res = new HashMap<ServerLibrary, File>();
        for (File file : libPath.listFiles(LIBRARY_FILTER)) {
            WLServerLibrary lib = WLServerLibrarySupport.readFromFile(file);
            if (lib == null) continue;
            res.put(ServerLibraryFactory.createServerLibrary((ServerLibraryImplementation)lib), file);
        }
        return res;
    }

    public static boolean sameLibraries(WLServerLibrary first, WLServerLibrary second) {
        if (first.specTitle == null ? second.specTitle != null : !first.specTitle.equals(second.specTitle)) {
            return false;
        }
        if (!(first.specVersion == second.specVersion || first.specVersion != null && first.specVersion.equals((Object)second.specVersion))) {
            return false;
        }
        if (first.implTitle == null ? second.implTitle != null : !first.implTitle.equals(second.implTitle)) {
            return false;
        }
        if (!(first.implVersion == second.implVersion || first.implVersion != null && first.implVersion.equals((Object)second.implVersion))) {
            return false;
        }
        return !(first.name == null ? second.name != null : !first.name.equals(second.name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WLServerLibrary readFromFile(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        Attributes attributes = null;
        if (file.isDirectory()) {
            File manifestFile = new File(file, "META-INF" + File.separator + "MANIFEST.MF");
            if (manifestFile.exists() && manifestFile.isFile()) {
                Manifest manifest = new Manifest();
                try {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifestFile));
                    try {
                        manifest.read(is);
                        attributes = manifest.getMainAttributes();
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        } else {
            try {
                JarFileSystem jar = new JarFileSystem();
                jar.setJarFile(file);
                attributes = jar.getManifest().getMainAttributes();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (PropertyVetoException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        if (attributes == null) {
            return null;
        }
        String specVersionValue = attributes.getValue("Specification-Version");
        String implVersionValue = attributes.getValue("Implementation-Version");
        String specTitle = attributes.getValue("Specification-Title");
        String implTitle = attributes.getValue("Implementation-Title");
        String name = attributes.getValue("Extension-Name");
        Version specVersion = specVersionValue == null ? null : Version.fromJsr277NotationWithFallback((String)specVersionValue);
        Version implVersion = implVersionValue == null ? null : Version.fromJsr277NotationWithFallback((String)implVersionValue);
        return new WLServerLibrary(specTitle, specVersion, implTitle, implVersion, null, name);
    }

    private static class Library {
        private final File baseFile;
        private String name;
        private Version specVersion;
        private Version implVersion;
        private String file;
        private String target;

        public Library(File baseFile) {
            this.baseFile = baseFile;
        }

        @CheckForNull
        public File resolveFile() {
            if (this.file == null) {
                return null;
            }
            File config = new File(this.file);
            if (!config.isAbsolute()) {
                if (this.baseFile != null) {
                    config = new File(this.baseFile, this.file);
                } else {
                    return null;
                }
            }
            if (config.exists() && config.isFile() && config.canRead()) {
                return config;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Version getSpecificationVersion() {
            return this.specVersion;
        }

        public void setSpecificationVersion(Version specVersion) {
            this.specVersion = specVersion;
        }

        public Version getImplementationVersion() {
            return this.implVersion;
        }

        public void setImplementationVersion(Version implVersion) {
            this.implVersion = implVersion;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }

    private static class LibraryHandler
    extends DefaultHandler {
        private final List<Library> libraries = new ArrayList<Library>();
        private final File domainDir;
        private Library library;
        private String value;

        public LibraryHandler(File domainDir) {
            this.domainDir = domainDir;
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            this.value = null;
            if ("library".equals(qName)) {
                this.library = new Library(this.domainDir);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.library == null) {
                return;
            }
            if ("library".equals(qName)) {
                this.libraries.add(this.library);
                this.library = null;
            } else if ("name".equals(qName)) {
                String[] splitted = this.value.split("#");
                if (splitted.length > 1) {
                    this.library.setName(splitted[0]);
                    splitted = splitted[1].split("@");
                    this.library.setSpecificationVersion(Version.fromJsr277NotationWithFallback((String)splitted[0]));
                    if (splitted.length > 1) {
                        this.library.setImplementationVersion(Version.fromJsr277NotationWithFallback((String)splitted[1]));
                    }
                } else {
                    this.library.setName(this.value);
                }
            } else if ("target".equals(qName)) {
                this.library.setTarget(this.value);
            } else if ("source-path".equals(qName)) {
                this.library.setFile(this.value);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.value = new String(ch, start, length);
        }

        public List<Library> getLibraries() {
            return this.libraries;
        }
    }

    public static class WLServerLibrary
    implements ServerLibraryImplementation {
        private final String specTitle;
        private final Version specVersion;
        private final String implTitle;
        private final Version implVersion;
        private final String server;
        private final String name;

        public WLServerLibrary(String specTitle, Version specVersion, String implTitle, Version implVersion, String server, String name) {
            this.specTitle = specTitle;
            this.specVersion = specVersion;
            this.implTitle = implTitle;
            this.implVersion = implVersion;
            this.server = server;
            this.name = name;
        }

        public String getSpecificationTitle() {
            return this.specTitle;
        }

        public Version getSpecificationVersion() {
            return this.specVersion;
        }

        public String getImplementationTitle() {
            return this.implTitle;
        }

        public Version getImplementationVersion() {
            return this.implVersion;
        }

        public String getName() {
            return this.name;
        }

        public String getServer() {
            return this.server;
        }
    }
}

