/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasource;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasourceManager;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcDataSource;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcDataSourceParamsType;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcDriverParamsType;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcPropertiesType;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcPropertyType;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WLDatasourceSupport {
    private static final String JDBC_FILE = "-jdbc.xml";
    private static final String NAME_PATTERN = "datasource-";
    private static final FileFilter JDBC_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isDirectory() && pathname.getName().endsWith(WLDatasourceSupport.JDBC_FILE);
        }
    };
    private static final Logger LOGGER = Logger.getLogger(WLDatasourceSupport.class.getName());
    private File resourceDir;

    public WLDatasourceSupport(File resourceDir) {
        assert (resourceDir != null) : "Resource directory can't be null";
        this.resourceDir = FileUtil.normalizeFile((File)resourceDir);
    }

    static Set<WLDatasource> getDatasources(File domain, FileObject inputFile, boolean systemDefault) throws ConfigurationException {
        if (inputFile == null || !inputFile.isValid() || !inputFile.canRead()) {
            if (LOGGER.isLoggable(Level.INFO) && inputFile != null) {
                LOGGER.log(Level.INFO, NbBundle.getMessage(WLDatasourceManager.class, (String)"ERR_WRONG_CONFIG_DIR", (Object)inputFile));
            }
            return Collections.emptySet();
        }
        if (inputFile.isData() && inputFile.hasExt("xml")) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                JdbcHandler handler = new JdbcHandler(domain);
                parser.parse((InputStream)new BufferedInputStream(inputFile.getInputStream()), (DefaultHandler)handler);
                HashMap<File, Boolean> confs = new HashMap<File, Boolean>();
                HashSet<String> nameOnly = new HashSet<String>();
                for (JdbcResource resource : handler.getResources()) {
                    if (resource.getFile() != null) {
                        File config = resource.resolveFile();
                        if (config == null) continue;
                        confs.put(config, resource.isSystem());
                        continue;
                    }
                    if (resource.getName() == null || !resource.isSystem()) continue;
                    nameOnly.add(resource.getName());
                }
                HashSet<WLDatasource> result = new HashSet<WLDatasource>();
                result.addAll(WLDatasourceSupport.getDatasources(confs));
                if (!nameOnly.isEmpty()) {
                    Set<WLDatasource> configDatasources = WLDatasourceSupport.getDatasources(domain, inputFile.getParent().getFileObject("jdbc"), true);
                    for (WLDatasource ds : configDatasources) {
                        if (!nameOnly.contains(ds.getName())) continue;
                        result.add(ds);
                    }
                }
                return result;
            }
            catch (IOException ex) {
                return Collections.emptySet();
            }
            catch (ParserConfigurationException ex) {
                return Collections.emptySet();
            }
            catch (SAXException ex) {
                return Collections.emptySet();
            }
        }
        if (inputFile.isFolder()) {
            File file = FileUtil.toFile((FileObject)inputFile);
            HashMap<File, Boolean> confs = new HashMap<File, Boolean>();
            for (File jdbcFile : file.listFiles(JDBC_FILE_FILTER)) {
                confs.put(jdbcFile, systemDefault);
            }
            if (confs.isEmpty()) {
                return Collections.emptySet();
            }
            return WLDatasourceSupport.getDatasources(confs);
        }
        return Collections.emptySet();
    }

    private static Set<WLDatasource> getDatasources(Map<File, Boolean> confs) throws ConfigurationException {
        HashSet<WLDatasource> datasources = new HashSet<WLDatasource>();
        for (Map.Entry<File, Boolean> entry : confs.entrySet()) {
            String msg;
            File dsFile = entry.getKey();
            try {
                JdbcDataSource ds = null;
                try {
                    ds = JdbcDataSource.createGraph(dsFile);
                }
                catch (RuntimeException re) {
                    String msg2 = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_NotParseableDatasources", (Object)dsFile.getAbsolutePath());
                    LOGGER.log(Level.INFO, msg2);
                    continue;
                }
                String[] names = WLDatasourceSupport.getJndiNames(ds);
                if (names == null) continue;
                String name = WLDatasourceSupport.getName(ds);
                String connectionURl = WLDatasourceSupport.getConnectionUrl(ds);
                String userName = WLDatasourceSupport.getUserName(ds);
                String driverClass = WLDatasourceSupport.getDriverClass(ds);
                String password = WLDatasourceSupport.getPassword(ds);
                if (names.length == 0) {
                    names = new String[]{name};
                }
                for (String jndiName : names) {
                    datasources.add(new WLDatasource(name, connectionURl, jndiName, userName, password, driverClass, dsFile, entry.getValue()));
                }
            }
            catch (IOException ioe) {
                msg = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_CannotReadDatasources", (Object)dsFile.getAbsolutePath());
                LOGGER.log(Level.FINE, null, ioe);
                throw new ConfigurationException(msg, (Throwable)ioe);
            }
            catch (RuntimeException re) {
                msg = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_NotParseableDatasources", (Object)dsFile.getAbsolutePath());
                LOGGER.log(Level.FINE, null, re);
                throw new ConfigurationException(msg, (Throwable)re);
            }
        }
        return datasources;
    }

    public Set<WLDatasource> getDatasources() throws ConfigurationException {
        FileObject resource = FileUtil.toFileObject((File)this.resourceDir);
        return WLDatasourceSupport.getDatasources(null, resource, false);
    }

    public Datasource createDatasource(final String jndiName, final String url, final String username, final String password, final String driver) throws UnsupportedOperationException, ConfigurationException, DatasourceAlreadyExistsException {
        WLDatasource ds = this.modifyDatasource(new DatasourceModifier(){

            @Override
            public ModifiedDatasource modify(Set<JdbcDataSource> datasources) throws DatasourceAlreadyExistsException {
                File candidate;
                for (JdbcDataSource ds : datasources) {
                    String[] names = WLDatasourceSupport.getJndiNames(ds);
                    if (names == null) continue;
                    for (String name : names) {
                        if (!name.equals(jndiName)) continue;
                        WLDatasource existing = new WLDatasource(WLDatasourceSupport.getName(ds), WLDatasourceSupport.getConnectionUrl(ds), name, WLDatasourceSupport.getUserName(ds), WLDatasourceSupport.getPassword(ds), WLDatasourceSupport.getDriverClass(ds), null, false);
                        throw new DatasourceAlreadyExistsException((Datasource)existing);
                    }
                }
                WLDatasourceSupport.this.ensureResourceDirExists();
                int counter = 1;
                do {
                    candidate = new File(WLDatasourceSupport.this.resourceDir, WLDatasourceSupport.NAME_PATTERN + counter + WLDatasourceSupport.JDBC_FILE);
                    ++counter;
                } while (candidate.exists());
                JdbcDataSource ds = new JdbcDataSource();
                WLDatasourceSupport.setName(ds, jndiName);
                WLDatasourceSupport.setConnectionUrl(ds, url);
                WLDatasourceSupport.addJndiName(ds, jndiName);
                WLDatasourceSupport.setUserName(ds, username);
                WLDatasourceSupport.setPassword(ds, password);
                WLDatasourceSupport.setDriverClass(ds, driver);
                try {
                    WLDatasourceSupport.this.writeFile(candidate, ds);
                }
                catch (ConfigurationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return new ModifiedDatasource(candidate, ds);
            }
        });
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WLDatasource modifyDatasource(DatasourceModifier modifier) throws ConfigurationException, DatasourceAlreadyExistsException {
        try {
            String[] names;
            this.ensureResourceDirExists();
            FileObject resourceDirObject = FileUtil.toFileObject((File)this.resourceDir);
            assert (resourceDirObject != null);
            LinkedHashMap<JdbcDataSource, DataObject> datasources = new LinkedHashMap<JdbcDataSource, DataObject>();
            for (FileObject dsFileObject : resourceDirObject.getChildren()) {
                if (!dsFileObject.isData() || !dsFileObject.getNameExt().endsWith(JDBC_FILE)) continue;
                DataObject datasourceDO = DataObject.find((FileObject)dsFileObject);
                EditorCookie editor = (EditorCookie)datasourceDO.getCookie(EditorCookie.class);
                StyledDocument doc = editor.getDocument();
                if (doc == null) {
                    doc = editor.openDocument();
                }
                JdbcDataSource source = null;
                try {
                    byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                    source = JdbcDataSource.createGraph(new ByteArrayInputStream(docString));
                }
                catch (RuntimeException e) {
                    BufferedInputStream is = new BufferedInputStream(dsFileObject.getInputStream());
                    try {
                        source = JdbcDataSource.createGraph(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                    if (source == null) {
                        throw new ConfigurationException(NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_datasourcesXmlCannotParse", (Object)dsFileObject.getNameExt()));
                    }
                    NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_datasourcesXmlNotValid", (Object)dsFileObject.getNameExt()), 0);
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                    if (result == NotifyDescriptor.NO_OPTION) {
                        return null;
                    }
                    datasources.put(source, datasourceDO);
                }
            }
            ModifiedDatasource modifiedSource = modifier.modify(datasources.keySet());
            DataObject datasourceDO = (DataObject)datasources.get((Object)modifiedSource.getDatasource());
            if (datasourceDO != null) {
                boolean modified = datasourceDO.isModified();
                EditorCookie editor = (EditorCookie)datasourceDO.getCookie(EditorCookie.class);
                StyledDocument doc = editor.getDocument();
                if (doc == null) {
                    doc = editor.openDocument();
                }
                this.replaceDocument(doc, modifiedSource.getDatasource());
                if (!modified) {
                    SaveCookie cookie = (SaveCookie)datasourceDO.getCookie(SaveCookie.class);
                    cookie.save();
                }
            }
            if ((names = WLDatasourceSupport.getJndiNames(modifiedSource.getDatasource())) != null && names.length > 0) {
                String name = WLDatasourceSupport.getName(modifiedSource.getDatasource());
                String connectionURl = WLDatasourceSupport.getConnectionUrl(modifiedSource.getDatasource());
                String userName = WLDatasourceSupport.getUserName(modifiedSource.getDatasource());
                String driverClass = WLDatasourceSupport.getDriverClass(modifiedSource.getDatasource());
                String password = WLDatasourceSupport.getPassword(modifiedSource.getDatasource());
                return new WLDatasource(name, connectionURl, names[0], userName, password, driverClass, modifiedSource.getFile(), false);
            }
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_CannotUpdateFile");
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
        return null;
    }

    private void writeFile(final File file, final BaseBean bean) throws ConfigurationException {
        assert (file != null) : "File to write can't be null";
        assert (file.getParentFile() != null) : "File parent folder can't be null";
        try {
            FileObject cfolder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getParentFile()));
            if (cfolder == null) {
                try {
                    cfolder = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file.getParentFile()));
                }
                catch (IOException ex) {
                    throw new ConfigurationException(NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_FailedToCreateConfigFolder", (Object)file.getParentFile().getAbsolutePath()));
                }
            }
            final FileObject folder = cfolder;
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = folder.getFileObject(name);
                        if (configFO == null) {
                            configFO = folder.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4086);
                        if (bean != null) {
                            bean.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException ioe) {
                                LOGGER.log(Level.FINE, null, ioe);
                            }
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
            FileUtil.refreshFor((File[])new File[]{file});
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }

    private void replaceDocument(final StyledDocument doc, BaseBean graph) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            graph.write((OutputStream)out);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
        });
    }

    private void ensureResourceDirExists() {
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
            FileUtil.refreshFor((File[])new File[]{this.resourceDir});
        }
    }

    private static String getName(JdbcDataSource ds) {
        return ds.getName();
    }

    private static void setName(JdbcDataSource ds, String name) {
        ds.setName(name);
    }

    private static String[] getJndiNames(JdbcDataSource ds) {
        JdbcDataSourceParamsType params = ds.getJdbcDataSourceParams();
        if (params != null) {
            return params.getJndiName();
        }
        return null;
    }

    private static void addJndiName(JdbcDataSource ds, String name) {
        String[] oldNames;
        JdbcDataSourceParamsType params = ds.getJdbcDataSourceParams();
        if (params == null) {
            params = new JdbcDataSourceParamsType();
            ds.setJdbcDataSourceParams(params);
        }
        if ((oldNames = params.getJndiName()) != null) {
            String[] newNames = new String[oldNames.length + 1];
            System.arraycopy(oldNames, 0, newNames, 0, oldNames.length);
            newNames[newNames.length - 1] = name;
            params.setJndiName(newNames);
        } else {
            params.setJndiName(new String[]{name});
        }
    }

    private static String getConnectionUrl(JdbcDataSource ds) {
        JdbcDriverParamsType params = ds.getJdbcDriverParams();
        if (params != null) {
            return params.getUrl();
        }
        return null;
    }

    private static void setConnectionUrl(JdbcDataSource ds, String url) {
        JdbcDriverParamsType params = ds.getJdbcDriverParams();
        if (params == null) {
            params = new JdbcDriverParamsType();
            ds.setJdbcDriverParams(params);
        }
        params.setUrl(url);
    }

    private static String getDriverClass(JdbcDataSource ds) {
        JdbcDriverParamsType params = ds.getJdbcDriverParams();
        if (params != null) {
            return params.getDriverName();
        }
        return null;
    }

    private static void setDriverClass(JdbcDataSource ds, String driver) {
        JdbcDriverParamsType params = ds.getJdbcDriverParams();
        if (params == null) {
            params = new JdbcDriverParamsType();
            ds.setJdbcDriverParams(params);
        }
        params.setDriverName(driver);
    }

    private static String getUserName(JdbcDataSource ds) {
        JdbcPropertiesType props;
        JdbcDriverParamsType params = ds.getJdbcDriverParams();
        if (params != null && (props = params.getProperties()) != null) {
            for (JdbcPropertyType item : props.getProperty2()) {
                if (!"user".equals(item.getName())) continue;
                return item.getValue();
            }
        }
        return null;
    }

    private static void setUserName(JdbcDataSource ds, String username) {
        WLDatasourceSupport.setProperty(ds, "user", username);
    }

    private static String getPassword(JdbcDataSource ds) {
        JdbcDriverParamsType params = ds.getJdbcDriverParams();
        if (params != null) {
            String encrypted = params.getPasswordEncrypted();
            if (encrypted != null) {
                return "";
            }
            JdbcPropertiesType props = params.getProperties();
            if (props != null) {
                for (JdbcPropertyType item : props.getProperty2()) {
                    if (!"password".equals(item.getName())) continue;
                    return item.getValue();
                }
            }
        }
        return null;
    }

    private static void setPassword(JdbcDataSource ds, String password) {
        WLDatasourceSupport.setProperty(ds, "password", password);
    }

    private static void setProperty(JdbcDataSource ds, String key, String value) {
        JdbcPropertiesType props;
        JdbcDriverParamsType params = ds.getJdbcDriverParams();
        if (params == null) {
            params = new JdbcDriverParamsType();
            ds.setJdbcDriverParams(params);
        }
        if ((props = params.getProperties()) == null) {
            props = new JdbcPropertiesType();
            params.setProperties(props);
        }
        for (JdbcPropertyType item : props.getProperty2()) {
            if (!key.equals(item.getName())) continue;
            item.setValue(value);
            return;
        }
        JdbcPropertyType item = new JdbcPropertyType();
        item.setName(key);
        item.setValue(value);
        props.addProperty2(item);
    }

    private static class JdbcResource {
        private final File baseFile;
        private final boolean system;
        private String name;
        private String target;
        private String file;

        public JdbcResource(File baseFile, boolean system) {
            this.baseFile = baseFile;
            this.system = system;
        }

        @CheckForNull
        public File resolveFile() {
            if (this.file == null) {
                return null;
            }
            File config = new File(this.file);
            if (!config.isAbsolute()) {
                if (this.baseFile != null) {
                    config = new File(this.baseFile, this.file);
                } else {
                    return null;
                }
            }
            if (config.exists() && config.isFile() && config.canRead()) {
                return config;
            }
            return null;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public boolean isSystem() {
            return this.system;
        }
    }

    private static class JdbcHandler
    extends DefaultHandler {
        private final JdbcSystemResourceHandler system;
        private final JdbcApplicationHandler application;

        public JdbcHandler(File domainDir) {
            File configDir = domainDir != null ? new File(domainDir, "config") : null;
            this.system = new JdbcSystemResourceHandler(configDir);
            this.application = new JdbcApplicationHandler(domainDir);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.system.startElement(uri, localName, qName, attributes);
            this.application.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.system.endElement(uri, localName, qName);
            this.application.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.system.characters(ch, start, length);
            this.application.characters(ch, start, length);
        }

        public List<JdbcResource> getResources() {
            ArrayList<JdbcResource> resources = new ArrayList<JdbcResource>();
            resources.addAll(this.system.getResources());
            resources.addAll(this.application.getResources());
            return resources;
        }
    }

    private static class JdbcApplicationHandler
    extends DefaultHandler {
        private final List<JdbcResource> resources = new ArrayList<JdbcResource>();
        private final File domainDir;
        private JdbcResource resource;
        private String value;
        private boolean isJdbc;

        public JdbcApplicationHandler(File domainDir) {
            this.domainDir = domainDir;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.value = null;
            if ("app-deployment".equals(qName)) {
                this.resource = new JdbcResource(this.domainDir, false);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.resource == null) {
                return;
            }
            if ("app-deployment".equals(qName)) {
                if (this.isJdbc) {
                    this.resources.add(this.resource);
                }
                this.isJdbc = false;
                this.resource = null;
            } else if ("name".equals(qName)) {
                this.resource.setName(this.value);
            } else if ("taget".equals(qName)) {
                this.resource.setTarget(this.value);
            } else if ("source-path".equals(qName)) {
                this.resource.setFile(this.value);
            } else if ("module-type".equals(qName) && "jdbc".equals(this.value)) {
                this.isJdbc = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.value = new String(ch, start, length);
        }

        public List<JdbcResource> getResources() {
            return this.resources;
        }
    }

    private static class JdbcSystemResourceHandler
    extends DefaultHandler {
        private final List<JdbcResource> resources = new ArrayList<JdbcResource>();
        private final File configDir;
        private JdbcResource resource;
        private String value;

        public JdbcSystemResourceHandler(File configDir) {
            this.configDir = configDir;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.value = null;
            if ("jdbc-system-resource".equals(qName)) {
                this.resource = new JdbcResource(this.configDir, true);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.resource == null) {
                return;
            }
            if ("jdbc-system-resource".equals(qName)) {
                this.resources.add(this.resource);
                this.resource = null;
            } else if ("name".equals(qName)) {
                this.resource.setName(this.value);
            } else if ("taget".equals(qName)) {
                this.resource.setTarget(this.value);
            } else if ("descriptor-file-name".equals(qName)) {
                this.resource.setFile(this.value);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.value = new String(ch, start, length);
        }

        public List<JdbcResource> getResources() {
            return this.resources;
        }
    }

    private static class ModifiedDatasource {
        private final File file;
        private final JdbcDataSource datasource;

        public ModifiedDatasource(File file, JdbcDataSource datasource) {
            this.file = file;
            this.datasource = datasource;
        }

        public JdbcDataSource getDatasource() {
            return this.datasource;
        }

        public File getFile() {
            return this.file;
        }
    }

    private static interface DatasourceModifier {
        @NonNull
        public ModifiedDatasource modify(Set<JdbcDataSource> var1) throws DatasourceAlreadyExistsException;
    }
}

