/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentDescriptorConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.dd.model.EarApplicationModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class EarDeploymentConfiguration
extends WLDeploymentConfiguration
implements ModuleConfiguration,
DeploymentPlanConfiguration,
DeploymentDescriptorConfiguration {
    private final File file;
    private final J2eeModule j2eeModule;
    private final DataObject dataObject;
    private final Version serverVersion;
    private final boolean isWebProfile;
    private EarApplicationModel weblogicApplication;

    public EarDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null, false);
    }

    public EarDeploymentConfiguration(J2eeModule j2eeModule, Version serverVersion, boolean isWebProfile) {
        super(j2eeModule);
        this.j2eeModule = j2eeModule;
        this.serverVersion = serverVersion;
        this.isWebProfile = isWebProfile;
        this.file = j2eeModule.getDeploymentConfigurationFile("META-INF/weblogic-application.xml");
        this.getWeblogicApplication();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.file));
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        this.dataObject = dataObject;
    }

    public synchronized EarApplicationModel getWeblogicApplication() {
        if (this.weblogicApplication == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.weblogicApplication = EarApplicationModel.forFile(this.file);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.weblogicApplication = this.genereateWeblogicApplication();
                    this.weblogicApplication.write(this.file);
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.weblogicApplication;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void dispose() {
    }

    public boolean isDescriptorRequired() {
        return true;
    }

    public void save(OutputStream os) throws ConfigurationException {
        EarApplicationModel weblogicApplication = this.getWeblogicApplication();
        if (weblogicApplication == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        try {
            weblogicApplication.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private EarApplicationModel genereateWeblogicApplication() {
        return EarApplicationModel.generate(this.serverVersion);
    }
}

