/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.util.prefs.Preferences;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbPreferences;

public final class Authentication {
    private static final Preferences prefs = NbPreferences.forModule(Authentication.class);
    private static final boolean isUnitTest = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final String knownHostsFile;
    private static String lastSSHKeyFile;
    private final ExecutionEnvironment env;
    private final String pref_key;
    private String sshKeyFile;
    private Type type = Type.UNDEFINED;

    private Authentication(ExecutionEnvironment env) {
        this.pref_key = env == null ? null : Authentication.class.getName() + '_' + ExecutionEnvironmentFactory.toUniqueID(env);
        this.env = env;
    }

    public static Authentication getFor(ExecutionEnvironment env) {
        Authentication result = new Authentication(env);
        result.restore();
        if (isUnitTest) {
            result.setPassword();
        } else if (result.sshKeyFile == null || result.sshKeyFile.trim().length() == 0) {
            result.sshKeyFile = lastSSHKeyFile;
        }
        return result;
    }

    public boolean isDefined() {
        return this.type != Type.UNDEFINED;
    }

    public void setPassword() {
        if (this.type == Type.PASSWORD) {
            return;
        }
        this.type = Type.PASSWORD;
    }

    public String getKnownHostsFile() {
        return knownHostsFile;
    }

    public void setSSHKeyFile(String filename) throws IllegalArgumentException {
        if (!Authentication.isValidSSHKeyFile(filename)) {
            throw new IllegalArgumentException("Invalid ssh key file " + filename);
        }
        this.type = Type.SSH_KEY;
        this.sshKeyFile = filename;
    }

    public static boolean isValidSSHKeyFile(String filename) {
        JSch test = new JSch();
        try {
            test.addIdentity(filename);
        }
        catch (JSchException ex) {
            return false;
        }
        return true;
    }

    private static boolean isValidKnownHostsFile(String knownHostsFile) {
        JSch test = new JSch();
        try {
            test.setKnownHosts(knownHostsFile);
        }
        catch (JSchException ex) {
            return false;
        }
        return true;
    }

    public Type getType() {
        return this.type;
    }

    public void store() {
        if (this.env == null) {
            return;
        }
        if (this.type == Type.SSH_KEY) {
            prefs.put(this.pref_key, this.sshKeyFile);
            lastSSHKeyFile = this.sshKeyFile;
        } else {
            prefs.put(this.pref_key, this.type.name());
        }
    }

    private void restore() {
        if (this.env == null) {
            return;
        }
        String typeOrKey = prefs.get(this.pref_key, Type.UNDEFINED.name());
        if (Type.UNDEFINED.name().equals(typeOrKey)) {
            this.type = Type.UNDEFINED;
        } else if (Type.PASSWORD.name().equals(typeOrKey)) {
            this.type = Type.PASSWORD;
        } else if (Authentication.isValidSSHKeyFile(typeOrKey)) {
            this.type = Type.SSH_KEY;
            this.sshKeyFile = typeOrKey;
        } else {
            this.type = Type.UNDEFINED;
        }
    }

    public ExecutionEnvironment getEnv() {
        return this.env;
    }

    public void remove() {
        if (this.pref_key != null) {
            prefs.remove(this.pref_key);
        }
    }

    public void apply() {
        if (this.env == null) {
            return;
        }
        this.store();
        ConnectionManagerAccessor access = ConnectionManagerAccessor.getDefault();
        access.changeAuth(this.env, this);
    }

    public String getKey() {
        return this.getSSHKeyFile();
    }

    public String getSSHKeyFile() {
        return this.sshKeyFile;
    }

    static {
        String hosts = System.getProperty("ssh.knonwhosts.file", null);
        if (!(hosts != null && Authentication.isValidKnownHostsFile(hosts) || Authentication.isValidKnownHostsFile(hosts = System.getProperty("user.home") + "/.ssh/known_hosts") || Authentication.isValidKnownHostsFile(hosts = System.getProperty("netbeans.user") + "/.ssh/known_hosts"))) {
            hosts = null;
        }
        knownHostsFile = hosts;
        String key = System.getProperty("user.home") + "/.ssh/id_dsa";
        if (!Authentication.isValidSSHKeyFile(key) && !Authentication.isValidSSHKeyFile(key = System.getProperty("user.home") + "/.ssh/id_rsa")) {
            key = null;
        }
        lastSSHKeyFile = key;
    }

    public static enum Type {
        UNDEFINED,
        PASSWORD,
        SSH_KEY;

    }
}

