/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.pty;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.modules.nativeexecution.PtyNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.pty.SttySupport;
import org.netbeans.modules.terminal.api.IONotifier;
import org.netbeans.modules.terminal.api.IOResizable;
import org.netbeans.modules.terminal.api.IOTerm;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public final class IOConnector {
    private static final RequestProcessor rp = new RequestProcessor("IOConnectorImpl", 2);
    private static final IOConnector instance = new IOConnector();

    private IOConnector() {
    }

    public static IOConnector getInstance() {
        return instance;
    }

    public boolean connect(InputOutput io, NativeProcess process) {
        PtyNativeProcess p;
        String tty;
        if (!IOTerm.isSupported((InputOutput)io)) {
            return false;
        }
        if (IOResizable.isSupported((InputOutput)io) && process instanceof PtyNativeProcess && (tty = (p = (PtyNativeProcess)process).getTTY()) != null) {
            try {
                IONotifier.addPropertyChangeListener((InputOutput)io, (PropertyChangeListener)new ResizeListener(p.getExecutionEnvironment(), tty));
            }
            catch (ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        IOTerm.connect((InputOutput)io, (OutputStream)process.getOutputStream(), (InputStream)process.getInputStream(), (InputStream)process.getErrorStream());
        return true;
    }

    public boolean connect(InputOutput io, Pty pty) {
        if (pty == null || io == null) {
            throw new NullPointerException();
        }
        if (!IOTerm.isSupported((InputOutput)io)) {
            return false;
        }
        IOTerm.connect((InputOutput)io, (OutputStream)pty.getOutputStream(), (InputStream)pty.getInputStream(), (InputStream)pty.getErrorStream());
        if (IOResizable.isSupported((InputOutput)io)) {
            try {
                IONotifier.addPropertyChangeListener((InputOutput)io, (PropertyChangeListener)new ResizeListener(pty.getEnv(), pty.getSlaveName()));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return true;
    }

    private static class ResizeListener
    implements PropertyChangeListener {
        private RequestProcessor.Task task = null;
        private Dimension cells;
        private Dimension pixels;
        private final boolean pxlsAware;

        ResizeListener(final ExecutionEnvironment env, final String tty) throws IOException, ConnectionManager.CancellationException {
            HostInfo hinfo = HostInfoUtils.getHostInfo(env);
            if (HostInfo.OSFamily.SUNOS.equals((Object)hinfo.getOSFamily())) {
                this.pxlsAware = true;
                String version = hinfo.getOS().getVersion();
                if (version.contains("OpenSolaris") || version.contains("Solaris 11")) {
                    return;
                }
            } else {
                this.pxlsAware = false;
            }
            this.task = rp.create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Dimension p;
                    Dimension c;
                    ResizeListener resizeListener = ResizeListener.this;
                    synchronized (resizeListener) {
                        c = new Dimension(ResizeListener.this.cells);
                        p = new Dimension(ResizeListener.this.pixels);
                    }
                    String cmd = ResizeListener.this.pxlsAware ? String.format("cols %d rows %d xpixels %d ypixels %d", c.width, c.height, p.width, p.height) : String.format("cols %d rows %d", c.width, c.height);
                    SttySupport.apply(env, tty, cmd);
                }
            }, true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IOResizable.Size newVal;
            if (this.task != null && "IOResizable.PROP_SIZE".equals(evt.getPropertyName()) && (newVal = (IOResizable.Size)evt.getNewValue()) != null) {
                Dimension newCells = newVal.cells;
                Dimension newPixels = newVal.pixels;
                if (newCells == null || newPixels == null) {
                    throw new NullPointerException();
                }
                if (newCells.equals(this.cells) && newPixels.equals(this.pixels)) {
                    return;
                }
                this.cells = new Dimension(newCells);
                this.pixels = new Dimension(newPixels);
                this.task.schedule(1000);
            }
        }
    }
}

