/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.nativeexecution.ExecutionEnvironmentFactoryServiceImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.spi.ExecutionEnvironmentFactoryService;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ExecutionEnvironmentFactory {
    private static final ExecutionEnvironmentFactoryService defaultFactory = new ExecutionEnvironmentFactoryServiceImpl();
    private static final Collection<ExecutionEnvironmentFactoryService> allFactories = new CopyOnWriteArrayList<ExecutionEnvironmentFactoryService>();
    private static final Lookup.Result<ExecutionEnvironmentFactoryService> lookupResult = Lookup.getDefault().lookupResult(ExecutionEnvironmentFactoryService.class);
    private static final LookupListener ll = new LookupListener(){

        public synchronized void resultChanged(LookupEvent ev) {
            Collection newSet = lookupResult.allInstances();
            allFactories.retainAll(newSet);
            for (ExecutionEnvironmentFactoryService impl : newSet) {
                if (allFactories.contains(impl)) continue;
                allFactories.add(impl);
            }
        }
    };

    private ExecutionEnvironmentFactory() {
    }

    public static ExecutionEnvironmentFactoryService getDefault() {
        return defaultFactory;
    }

    public static ExecutionEnvironment getLocal() {
        for (ExecutionEnvironmentFactoryService f : allFactories) {
            ExecutionEnvironment result = f.getLocal();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static ExecutionEnvironment createNew(String user, String host) {
        Logger.assertTrue(user != null && !user.isEmpty());
        Logger.assertTrue(host != null && !host.isEmpty());
        for (ExecutionEnvironmentFactoryService f : allFactories) {
            ExecutionEnvironment result = f.createNew(user, host);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static ExecutionEnvironment createNew(String user, String host, int port) {
        Logger.assertTrue(user != null && !user.isEmpty());
        Logger.assertTrue(host != null && !host.isEmpty());
        for (ExecutionEnvironmentFactoryService f : allFactories) {
            ExecutionEnvironment result = f.createNew(user, host, port);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String toUniqueID(ExecutionEnvironment executionEnvironment) {
        for (ExecutionEnvironmentFactoryService f : allFactories) {
            String result = f.toUniqueID(executionEnvironment);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static ExecutionEnvironment fromUniqueID(String hostKey) {
        for (ExecutionEnvironmentFactoryService f : allFactories) {
            ExecutionEnvironment result = f.fromUniqueID(hostKey);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static {
        lookupResult.addLookupListener(ll);
        ll.resultChanged(null);
    }
}

