/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import org.netbeans.modules.nativeexecution.ExecutionEnvironmentImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.spi.ExecutionEnvironmentFactoryService;
import org.openide.util.Exceptions;

public class ExecutionEnvironmentFactoryServiceImpl
implements ExecutionEnvironmentFactoryService {
    private static final ExecutionEnvironment LOCAL = new ExecutionEnvironmentImpl();
    public static final int DEFAULT_PORT = Integer.getInteger("cnd.remote.port", 22);

    @Override
    public ExecutionEnvironment getLocal() {
        return LOCAL;
    }

    @Override
    public ExecutionEnvironment createNew(String user, String host) {
        return this.createNew(user, host, DEFAULT_PORT);
    }

    @Override
    public ExecutionEnvironment createNew(String user, String host, int port) {
        return new ExecutionEnvironmentImpl(user, host, port);
    }

    @Override
    public String toUniqueID(ExecutionEnvironment executionEnvironment) {
        if (!(executionEnvironment instanceof ExecutionEnvironmentImpl)) {
            return null;
        }
        if (executionEnvironment.isLocal()) {
            return "localhost";
        }
        String hostAndPort = executionEnvironment.getHost() + ':' + executionEnvironment.getSSHPort();
        if (executionEnvironment.getUser() == null || executionEnvironment.getUser().length() == 0) {
            return hostAndPort;
        }
        return executionEnvironment.getUser() + '@' + hostAndPort;
    }

    @Override
    public ExecutionEnvironment fromUniqueID(String hostKey) {
        String host;
        String user;
        if ("localhost".equals(hostKey) || "127.0.0.1".equals(hostKey)) {
            return LOCAL;
        }
        int pos = hostKey.indexOf(64, 0);
        if (pos < 0) {
            user = "";
            host = hostKey;
        } else {
            user = hostKey.substring(0, pos);
            host = hostKey.substring(pos + 1);
        }
        int colonPos = host.indexOf(58);
        if (colonPos > 0) {
            String strPort = host.substring(colonPos + 1);
            host = host.substring(0, colonPos);
            try {
                int port = Integer.parseInt(strPort);
                return this.createNew(user, host, port);
            }
            catch (NumberFormatException e) {
                Exceptions.printStackTrace((Throwable)e);
                return this.createNew(user, host);
            }
        }
        return this.createNew(user, host);
    }

    @Override
    public ExecutionEnvironment createNew(String schema) {
        return null;
    }
}

