/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_cup.runtime.Symbol;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.php.editor.parser.ASTPHP5Parser;
import org.netbeans.modules.php.editor.parser.ASTPHP5Scanner;
import org.netbeans.modules.php.editor.parser.PHP5ErrorHandler;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class GSFPHPParser
extends Parser
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(GSFPHPParser.class.getName());
    private boolean shortTags = true;
    private boolean aspTags = false;
    private ParserResult result = null;
    private boolean projectPropertiesListenerAdded = false;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public Parser.Result getResult(Task task) throws ParseException {
        return this.result;
    }

    public void cancel() {
        LOGGER.finest("ParserTask canceled without a reason");
    }

    public void cancel(Parser.CancelReason reason, SourceModificationEvent event) {
        super.cancel(reason, event);
        LOGGER.fine("ParserTask cancel: " + reason.name());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        long startTime = System.currentTimeMillis();
        FileObject file = snapshot.getSource().getFileObject();
        PhpLanguageOptions.Properties languageProperties = PhpLanguageOptions.getDefault().getProperties(file);
        if (!this.projectPropertiesListenerAdded) {
            PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)languageProperties);
            PhpLanguageOptions.getDefault().addPropertyChangeListener(weakListener);
            this.projectPropertiesListenerAdded = true;
        }
        this.shortTags = languageProperties.areShortTagsEnabled();
        this.aspTags = languageProperties.areAspTagsEnabled();
        int end = 0;
        try {
            String source = ((Object)snapshot.getText()).toString();
            end = source.length();
            int caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)event);
            LOGGER.log(Level.FINE, "caretOffset: {0}", caretOffset);
            Context context = new Context(snapshot, source, caretOffset);
            this.result = this.parseBuffer(context, Sanitize.NONE, null);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Exception during parsing: {0}", exception);
            ASTError error = new ASTError(0, end);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add(error);
            Program emptyProgram = new Program(0, end, statements, Collections.<Comment>emptyList());
            this.result = new PHPParseResult(snapshot, emptyProgram);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Parsing took: {0}ms source: {1}", new Object[]{endTime - startTime, System.identityHashCode(snapshot.getSource())});
    }

    protected PHPParseResult parseBuffer(Context context, Sanitize sanitizing, PHP5ErrorHandler errorHandler) throws Exception {
        PHPParseResult result;
        boolean sanitizedSource = false;
        String source = context.source;
        if (errorHandler == null) {
            errorHandler = new PHP5ErrorHandler(context, this);
        }
        if (sanitizing != Sanitize.NONE && sanitizing != Sanitize.NEVER) {
            boolean ok = this.sanitizeSource(context, sanitizing, errorHandler);
            if (ok) {
                assert (context.sanitizedSource != null);
                sanitizedSource = true;
                source = context.sanitizedSource;
            } else {
                return this.sanitize(context, sanitizing, errorHandler);
            }
        }
        ASTPHP5Scanner scanner = new ASTPHP5Scanner(new StringReader(source), this.shortTags, this.aspTags);
        ASTPHP5Parser parser = new ASTPHP5Parser(scanner);
        parser.setErrorHandler(errorHandler);
        Symbol rootSymbol = parser.parse();
        if (scanner.getCurlyBalance() != 0 && !sanitizedSource) {
            this.sanitizeSource(context, Sanitize.MISSING_CURLY, null);
            if (context.sanitizedSource != null) {
                context.source = context.getSanitizedSource();
                source = context.source;
                scanner = new ASTPHP5Scanner(new StringReader(source), this.shortTags, this.aspTags);
                parser = new ASTPHP5Parser(scanner);
                rootSymbol = parser.parse();
            }
        }
        if (rootSymbol != null) {
            Program program = null;
            if (rootSymbol.value instanceof Program) {
                program = (Program)rootSymbol.value;
                List<Statement> statements = program.getStatements();
                boolean ok = true;
                for (Statement statement : statements) {
                    if (!(statement instanceof ASTError)) continue;
                    String errorCode = "<?" + source.substring(statement.getStartOffset(), statement.getEndOffset()) + "?>";
                    ASTPHP5Scanner fcScanner = new ASTPHP5Scanner(new StringReader(errorCode), this.shortTags, this.aspTags);
                    Symbol token = fcScanner.next_token();
                    while (token.sym != 0) {
                        if (token.sym == 47 || token.sym == 34 || this.isRequireFunction(token)) {
                            ok = false;
                            break;
                        }
                        token = fcScanner.next_token();
                    }
                    if (ok) continue;
                    break;
                }
                result = ok ? new PHPParseResult(context.getSnapshot(), program) : this.sanitize(context, sanitizing, errorHandler);
            } else {
                LOGGER.fine("The parser value is not a Program: " + rootSymbol.value);
                result = this.sanitize(context, sanitizing, errorHandler);
            }
            result.setErrors(errorHandler.displaySyntaxErrors(program));
        } else {
            result = this.sanitize(context, sanitizing, errorHandler);
            result.setErrors(errorHandler.displayFatalError());
        }
        return result;
    }

    private boolean sanitizeSource(Context context, Sanitize sanitizing, PHP5ErrorHandler errorHandler) {
        List<PHP5ErrorHandler.SyntaxError> syntaxErrors;
        if (sanitizing == Sanitize.SYNTAX_ERROR_CURRENT && (syntaxErrors = errorHandler.getSyntaxErrors()).size() > 0) {
            int end;
            int start;
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            String source = context.sanitized == Sanitize.NONE ? context.source : context.sanitizedSource;
            String replace = source.substring(start = error.getCurrentToken().left, end = error.getCurrentToken().right);
            if ("}".equals(replace)) {
                return false;
            }
            context.sanitizedSource = source.substring(0, start) + Utils.getSpaces(end - start) + source.substring(end);
            context.sanitizedRange = new OffsetRange(start, end);
            return true;
        }
        if (sanitizing == Sanitize.SYNTAX_ERROR_PREVIOUS && (syntaxErrors = errorHandler.getSyntaxErrors()).size() > 0) {
            int end;
            int start;
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            String source = context.source;
            if (source.substring(start = error.getPreviousToken().left, end = error.getPreviousToken().right).equals("}")) {
                return false;
            }
            context.sanitizedSource = source.substring(0, start) + Utils.getSpaces(end - start) + source.substring(end);
            context.sanitizedRange = new OffsetRange(start, end);
            return true;
        }
        if (sanitizing == Sanitize.SYNTAX_ERROR_PREVIOUS_LINE && (syntaxErrors = errorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            String source = context.source;
            int end = Utils.getRowEnd(source, error.getPreviousToken().right);
            int start = Utils.getRowStart(source, error.getPreviousToken().left);
            StringBuffer sb = new StringBuffer(end - start);
            for (int index = start; index < end; ++index) {
                if (source.charAt(index) == ' ' || source.charAt(index) == '}' || source.charAt(index) == '\n' || source.charAt(index) == '\r') {
                    sb.append(source.charAt(index));
                    continue;
                }
                sb.append(' ');
            }
            context.sanitizedSource = source.substring(0, start) + sb.toString() + source.substring(end);
            context.sanitizedRange = new OffsetRange(start, end);
            return true;
        }
        if (sanitizing == Sanitize.EDITED_LINE && context.caretOffset > -1) {
            String source = context.getSource();
            int start = context.caretOffset - 1;
            int end = context.caretOffset;
            char c = source.charAt(start);
            while (start > 0 && c != '\n' && c != '\r' && c != '{' && c != '}') {
                c = source.charAt(--start);
            }
            ++start;
            if (end < source.length()) {
                c = source.charAt(end);
                while (end < source.length() && c != '\n' && c != '\r' && c != '{' && c != '}') {
                    c = source.charAt(end++);
                }
            }
            context.sanitizedSource = source.substring(0, start) + Utils.getSpaces(end - start) + source.substring(end);
            context.sanitizedRange = new OffsetRange(start, end);
            return true;
        }
        if (sanitizing == Sanitize.MISSING_CURLY) {
            return this.sanitizeCurly(context);
        }
        if (sanitizing == Sanitize.SYNTAX_ERROR_BLOCK && (syntaxErrors = errorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            return this.sanitizeRemoveBlock(context, error.getCurrentToken().left);
        }
        if (sanitizing == Sanitize.REQUIRE_FUNCTION_INCOMPLETE && (syntaxErrors = errorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError error = syntaxErrors.get(0);
            int start = Utils.getRowStart(context.getSource(), error.getPreviousToken().left);
            int end = Utils.getRowEnd(context.getSource(), error.getCurrentToken().left);
            return this.sanitizeRequireAndInclude(context, start, end);
        }
        return false;
    }

    protected boolean sanitizeRequireAndInclude(Context context, int start, int end) {
        try {
            String source = context.getSource();
            String phpOpenDelimiter = "<?";
            String actualSource = phpOpenDelimiter + source.substring(start, end) + "?>";
            ASTPHP5Scanner scanner = new ASTPHP5Scanner(new StringReader(actualSource), this.shortTags, this.aspTags);
            char delimiter = '0';
            Symbol token = scanner.next_token();
            while (token.sym != 0) {
                if (this.isRequireFunction(token)) {
                    boolean containsOpenParenthese = false;
                    int currentLeftOffset = token.right;
                    char c = actualSource.charAt(currentLeftOffset);
                    if (this.isStringDelimiter(c)) {
                        delimiter = c;
                    } else {
                        ++currentLeftOffset;
                        if (Character.isWhitespace(c)) {
                            while (Character.isWhitespace(actualSource.charAt(currentLeftOffset))) {
                                ++currentLeftOffset;
                            }
                            char cc = actualSource.charAt(currentLeftOffset);
                            if (this.isStringDelimiter(cc)) {
                                delimiter = cc;
                            } else if (cc == '(') {
                                containsOpenParenthese = true;
                                delimiter = actualSource.charAt(++currentLeftOffset);
                            }
                        } else if (c == '(') {
                            containsOpenParenthese = true;
                            delimiter = actualSource.charAt(currentLeftOffset);
                        }
                    }
                    if (this.isStringDelimiter(delimiter)) {
                        char expectedCloseDelimiter = actualSource.charAt(currentLeftOffset + 1);
                        boolean hasCloseDelimiter = false;
                        boolean hasCloseParenthese = false;
                        if (expectedCloseDelimiter == delimiter) {
                            char expectedCloseParenthese;
                            hasCloseDelimiter = true;
                            if ((expectedCloseParenthese = actualSource.charAt(++currentLeftOffset + 1)) == ')') {
                                hasCloseParenthese = true;
                                ++currentLeftOffset;
                            }
                        }
                        boolean canBeSanitized = true;
                        for (int i = 1; i <= this.numberOfSanitizedChars(containsOpenParenthese, hasCloseDelimiter, hasCloseParenthese); ++i) {
                            if (Character.isWhitespace(actualSource.charAt(currentLeftOffset + i))) continue;
                            canBeSanitized = false;
                            break;
                        }
                        if (canBeSanitized) {
                            int sanitizedChars = this.numberOfSanitizedChars(containsOpenParenthese, hasCloseDelimiter, hasCloseParenthese);
                            context.sanitizedSource = source.substring(0, start + currentLeftOffset - 1) + this.sanitizationString(delimiter, containsOpenParenthese, hasCloseDelimiter, hasCloseParenthese) + source.substring(start + currentLeftOffset + sanitizedChars - phpOpenDelimiter.length() + 1);
                            System.out.println(context.sanitizedSource);
                            return true;
                        }
                        break;
                    }
                }
                token = scanner.next_token();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Exception during 'require' sanitization.", ex);
        }
        return false;
    }

    private boolean isRequireFunction(Symbol token) {
        return token.sym == 76 || token.sym == 77 || token.sym == 73 || token.sym == 74;
    }

    private boolean isStringDelimiter(char c) {
        return c == '\"' || c == '\'';
    }

    private String sanitizationString(char delimiter, boolean containsOpenParenthese, boolean containsCloseDelimiter, boolean containsCloseParenthese) {
        if (containsCloseDelimiter) {
            if (containsOpenParenthese) {
                if (containsCloseParenthese) {
                    return ";";
                }
                return ");";
            }
            return ";";
        }
        if (containsOpenParenthese) {
            return delimiter + ");";
        }
        return delimiter + ";";
    }

    private int numberOfSanitizedChars(boolean containsOpenParenthese, boolean containsCloseDelimiter, boolean containsCloseParenthese) {
        int chars = 1;
        if (containsOpenParenthese) {
            chars += containsCloseParenthese ? 0 : 1;
        }
        return chars += containsCloseDelimiter ? 0 : 1;
    }

    protected boolean sanitizeCurly(Context context) {
        String source = context.getSource();
        ASTPHP5Scanner scanner = new ASTPHP5Scanner(new StringReader(source), this.shortTags, this.aspTags);
        Symbol lastPHPToken = null;
        Symbol token = null;
        int bracketCounter = 0;
        int bracketClassCounter = 0;
        try {
            token = scanner.next_token();
            boolean inClass = false;
            int lastOpenInClass = -1;
            while (token.sym != 0) {
                switch (token.sym) {
                    case 47: {
                        char c;
                        if (!inClass) {
                            inClass = true;
                            break;
                        }
                        int index = token.left;
                        int max = bracketClassCounter;
                        for (int i = 0; i < max; ++i) {
                            c = source.charAt(--index);
                            while (index > lastOpenInClass && c != '}' && c != '\n' && c != '\r' && c != '\t' && c != ' ') {
                                c = source.charAt(--index);
                            }
                            if (c == '}' || c == '{') continue;
                            source = source.substring(0, index) + '}' + source.substring(index + 1);
                            --bracketClassCounter;
                        }
                        if (bracketClassCounter > 0) {
                            c = source.charAt(--index);
                            while (index > 0 && c != '}' && c != '\n' && c != '\r') {
                                c = source.charAt(--index);
                            }
                            if (c == '}') {
                                c = source.charAt(--index);
                            }
                            while (index < source.length() && bracketClassCounter > 0 && (c == '\n' || c == '\r' || c == '\t' || c == ' ')) {
                                source = source.substring(0, index) + '}' + source.substring(index + 1);
                                --bracketClassCounter;
                                c = source.charAt(--index);
                            }
                        }
                        context.sanitizedSource = source;
                        break;
                    }
                    case 63: 
                    case 64: {
                        if (inClass) {
                            ++bracketClassCounter;
                            lastOpenInClass = token.left;
                            break;
                        }
                        ++bracketCounter;
                        break;
                    }
                    case 65: {
                        if (inClass) {
                            if (--bracketClassCounter != 0) break;
                            inClass = false;
                            break;
                        }
                        --bracketCounter;
                    }
                }
                if (token.sym != 10) {
                    lastPHPToken = token;
                }
                token = scanner.next_token();
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.INFO, "Exception during calculating missing }", exception);
        }
        int count = bracketCounter + bracketClassCounter;
        if (count > 0 && lastPHPToken != null) {
            String lastTokenText = source.substring(lastPHPToken.left, lastPHPToken.right).trim();
            if ("?>".equals(lastTokenText)) {
                context.sanitizedSource = source.substring(0, lastPHPToken.left) + Utils.getRepeatingChars('}', count) + source.substring(lastPHPToken.left);
                context.sanitizedRange = new OffsetRange(lastPHPToken.left, lastPHPToken.left + count);
                return true;
            }
            if (token.sym == 0) {
                context.sanitizedSource = source.substring(0, token.left) + Utils.getRepeatingChars('}', count) + source.substring(token.left);
                context.sanitizedRange = new OffsetRange(token.left, token.left + count);
                return true;
            }
        }
        return false;
    }

    private boolean sanitizeRemoveBlock(Context context, int index) {
        String source = context.getSource();
        ASTPHP5Scanner scanner = new ASTPHP5Scanner(new StringReader(source), this.shortTags, this.aspTags);
        Symbol token = null;
        int start = -1;
        int end = -1;
        try {
            token = scanner.next_token();
            while (token.sym != 0 && end == -1) {
                if (token.sym == 64 && token.left <= index) {
                    start = token.right;
                }
                if (token.sym == 65 && token.left >= index) {
                    end = token.right - 1;
                }
                token = scanner.next_token();
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.INFO, "Exception during removing block", exception);
        }
        if (start > -1 && start < end) {
            context.sanitizedSource = source.substring(0, start) + Utils.getSpaces(end - start) + source.substring(end);
            context.sanitizedRange = new OffsetRange(start, end);
            return true;
        }
        return false;
    }

    private PHPParseResult sanitize(Context context, Sanitize sanitizing, PHP5ErrorHandler errorHandler) throws Exception {
        switch (sanitizing) {
            case NONE: 
            case MISSING_CURLY: {
                return this.parseBuffer(context, Sanitize.REQUIRE_FUNCTION_INCOMPLETE, errorHandler);
            }
            case REQUIRE_FUNCTION_INCOMPLETE: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_CURRENT, errorHandler);
            }
            case SYNTAX_ERROR_CURRENT: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS, errorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS_LINE, errorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS_LINE: {
                return this.parseBuffer(context, Sanitize.EDITED_LINE, errorHandler);
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_BLOCK, errorHandler);
            }
        }
        int end = context.getSource().length();
        ASTError error = new ASTError(0, end);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(error);
        Program emptyProgram = new Program(0, end, statements, Collections.<Comment>emptyList());
        return new PHPParseResult(context.getSnapshot(), emptyProgram);
    }

    private static String asString(CharSequence sequence) {
        if (sequence instanceof String) {
            return (String)sequence;
        }
        return ((Object)sequence).toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PhpLanguageOptions.PROP_PHP_VERSION.equals(evt.getPropertyName())) {
            this.forceReparsing();
        }
    }

    private void forceReparsing() {
        this.changeSupport.fireChange();
    }

    public static class Context {
        private final Snapshot snapshot;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;

        public Context(Snapshot snapshot, String source, int caretOffset) {
            this.snapshot = snapshot;
            this.source = source;
            this.caretOffset = caretOffset;
        }

        public String toString() {
            return "PHPParser.Context(" + this.snapshot.getSource().getFileObject() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public String getSource() {
            return this.source;
        }
    }

    public static enum Sanitize {
        NEVER,
        NONE,
        SYNTAX_ERROR_CURRENT,
        SYNTAX_ERROR_PREVIOUS,
        SYNTAX_ERROR_PREVIOUS_LINE,
        SYNTAX_ERROR_BLOCK,
        EDITED_DOT,
        ERROR_DOT,
        BLOCK_START,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_CURLY,
        REQUIRE_FUNCTION_INCOMPLETE;

    }
}

