/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;

public class MagicMethodDeclarationInfo
extends ASTNodeInfo<PHPDocTag> {
    private String returnType;
    private String methodName;
    private int offset;
    private int typeOffset;

    MagicMethodDeclarationInfo(PHPDocTag node) {
        super(node);
        String[] parts = node.getValue().trim().split("\\s+", 3);
        if (parts.length == 1 || parts.length > 0 && parts[0].trim().indexOf("(") > 0) {
            this.returnType = "void";
            String[] methodNames = parts[0].split("[(, ]", 2);
            if (methodNames.length > 0) {
                this.methodName = methodNames[0];
                this.offset = ((PHPDocTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.methodName);
            }
        } else if (parts.length >= 2) {
            String[] typeNames = parts[0].split("\\|", 2);
            String[] methodNames = parts[1].split("[(, ]", 2);
            if (typeNames.length > 0 && methodNames.length > 0) {
                this.returnType = typeNames[0];
                this.methodName = methodNames[0];
                this.offset = ((PHPDocTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.methodName);
                this.typeOffset = ((PHPDocTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.returnType);
            }
        }
    }

    @CheckForNull
    public static MagicMethodDeclarationInfo create(PHPDocTag node) {
        MagicMethodDeclarationInfo retval = new MagicMethodDeclarationInfo(node);
        return retval.methodName != null && retval.returnType != null ? retval : null;
    }

    public ASTNodeInfo<PHPDocTag> getClassInfo() {
        return new ASTNodeInfo<PHPDocTag>((PHPDocTag)this.getOriginalNode()){

            @Override
            public String getName() {
                return MagicMethodDeclarationInfo.this.getReturnType();
            }

            @Override
            public OffsetRange getRange() {
                return MagicMethodDeclarationInfo.this.getTypeRange();
            }

            @Override
            public ASTNodeInfo.Kind getKind() {
                return ASTNodeInfo.Kind.CLASS;
            }

            @Override
            public QualifiedName getQualifiedName() {
                return QualifiedName.create(this.getName());
            }

            @Override
            public PhpElementKind getPhpElementKind() {
                return PhpElementKind.CLASS;
            }
        };
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.METHOD;
    }

    @Override
    public String getName() {
        return this.getQualifiedName().toName().toString();
    }

    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.create(this.methodName).toName();
    }

    @Override
    public OffsetRange getRange() {
        return new OffsetRange(this.offset, this.offset + this.getName().length());
    }

    public OffsetRange getTypeRange() {
        return new OffsetRange(this.typeOffset, this.typeOffset + this.getReturnType().length());
    }

    public List<? extends ParameterElement> getParameters() {
        return Collections.emptyList();
    }

    public PhpModifiers getAccessModifiers() {
        return PhpModifiers.fromBitMask(1);
    }
}

