/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Arrays;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.util.Exceptions;

public class PHPNewLineIndenter {
    private Context context;
    private static final Collection<PHPTokenId> CONTROL_STATEMENT_TOKENS = Arrays.asList(PHPTokenId.PHP_DO, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE);
    private Collection<ScopeDelimiter> scopeDelimiters = null;
    private int indentSize;
    private int continuationSize;
    private int itemsArrayDeclararionSize;

    public PHPNewLineIndenter(Context context) {
        this.context = context;
        this.indentSize = CodeStyle.get(context.document()).getIndentSize();
        this.continuationSize = CodeStyle.get(context.document()).getContinuationIndentSize();
        this.itemsArrayDeclararionSize = CodeStyle.get(context.document()).getItemsInArrayDeclarationIndentSize();
        int initialIndentSize = CodeStyle.get(context.document()).getInitialIndent();
        this.scopeDelimiters = Arrays.asList(new ScopeDelimiter(PHPTokenId.PHP_SEMICOLON, 0), new ScopeDelimiter(PHPTokenId.PHP_OPENTAG, initialIndentSize), new ScopeDelimiter(PHPTokenId.PHP_CURLY_CLOSE, 0), new ScopeDelimiter(PHPTokenId.PHP_CURLY_OPEN, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_CASE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_IF, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_ELSE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_ELSEIF, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_WHILE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_DO, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_FOR, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_FOREACH, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_DEFAULT, this.indentSize));
    }

    public void process() {
        final BaseDocument doc = (BaseDocument)this.context.document();
        final int offset = this.context.caretOffset();
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    int newIndent = 0;
                    boolean insideString = false;
                    TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
                    int caretLineStart = Utilities.getRowStart((BaseDocument)doc, (int)(Utilities.getRowStart((BaseDocument)doc, (int)offset) - 1));
                    ts.move(offset);
                    ts.moveNext();
                    boolean indentStartComment = false;
                    boolean movePrevious = false;
                    if (ts.token() == null) {
                        return;
                    }
                    if (ts.token().id() == PHPTokenId.WHITESPACE && ts.moveNext()) {
                        movePrevious = true;
                    }
                    if (ts.token().id() == PHPTokenId.PHP_COMMENT || ts.token().id() == PHPTokenId.PHP_LINE_COMMENT || ts.token().id() == PHPTokenId.PHP_COMMENT_START || ts.token().id() == PHPTokenId.PHP_COMMENT_END) {
                        if (ts.token().id() == PHPTokenId.PHP_COMMENT_START && ts.offset() >= offset) {
                            indentStartComment = true;
                        } else {
                            if (!movePrevious) {
                                return;
                            }
                            if (ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                                ts.movePrevious();
                                CharSequence whitespace = ts.token().text();
                                if (ts.movePrevious() && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                                    int index;
                                    for (index = 0; index < whitespace.length() && whitespace.charAt(index) != '\n'; ++index) {
                                    }
                                    if (index == whitespace.length()) {
                                        return;
                                    }
                                }
                                ts.moveNext();
                                movePrevious = false;
                            }
                        }
                    }
                    if (movePrevious) {
                        ts.movePrevious();
                    }
                    if (ts.token().id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && offset > ts.offset()) {
                        int stringLineStart = Utilities.getRowStart((BaseDocument)doc, (int)ts.offset());
                        newIndent = stringLineStart >= caretLineStart ? Utilities.getRowIndent((BaseDocument)doc, (int)stringLineStart) + PHPNewLineIndenter.this.indentSize : Utilities.getRowIndent((BaseDocument)doc, (int)caretLineStart);
                        insideString = true;
                    }
                    int bracketBalance = 0;
                    while (!insideString && ts.movePrevious()) {
                        int startExpression;
                        Token token = ts.token();
                        ScopeDelimiter delimiter = PHPNewLineIndenter.this.getScopeDelimiter(token);
                        int anchor = ts.offset();
                        int shiftAtAncor = 0;
                        if (delimiter != null) {
                            if (delimiter.tokenId == PHPTokenId.PHP_SEMICOLON) {
                                int casePosition = PHPNewLineIndenter.this.breakProceededByCase(ts);
                                if (casePosition > -1) {
                                    newIndent = Utilities.getRowIndent((BaseDocument)doc, (int)anchor);
                                    if (Utilities.getRowStart((BaseDocument)doc, (int)casePosition) == caretLineStart) break;
                                    newIndent -= PHPNewLineIndenter.this.indentSize;
                                    System.out.println("odecitam");
                                    break;
                                }
                                CodeB4BreakData codeB4BreakData = PHPNewLineIndenter.this.processCodeBeforeBreak(ts, indentStartComment);
                                anchor = codeB4BreakData.expressionStartOffset;
                                shiftAtAncor = codeB4BreakData.indentDelta;
                                if (codeB4BreakData.processedByControlStmt) {
                                    newIndent = Utilities.getRowIndent((BaseDocument)doc, (int)anchor) - PHPNewLineIndenter.this.indentSize;
                                    break;
                                }
                                newIndent = Utilities.getRowIndent((BaseDocument)doc, (int)anchor) + delimiter.indentDelta + shiftAtAncor;
                                break;
                            }
                            if (delimiter.tokenId == PHPTokenId.PHP_CURLY_OPEN && ts.movePrevious()) {
                                startExpression = PHPNewLineIndenter.findStartTokenOfExpression(ts);
                                newIndent = Utilities.getRowIndent((BaseDocument)doc, (int)startExpression) + PHPNewLineIndenter.this.indentSize;
                                break;
                            }
                            newIndent = Utilities.getRowIndent((BaseDocument)doc, (int)anchor) + delimiter.indentDelta + shiftAtAncor;
                            break;
                        }
                        if (ts.token().id() == PHPTokenId.PHP_TOKEN) {
                            char ch = ts.token().text().charAt(0);
                            boolean continualIndent = false;
                            boolean indent = false;
                            switch (ch) {
                                case ')': {
                                    ++bracketBalance;
                                    break;
                                }
                                case '(': {
                                    if (bracketBalance == 0) {
                                        continualIndent = true;
                                    }
                                    --bracketBalance;
                                    break;
                                }
                                case ',': {
                                    continualIndent = true;
                                    break;
                                }
                                case '.': {
                                    continualIndent = true;
                                    break;
                                }
                                case ':': {
                                    indent = true;
                                }
                            }
                            if (!continualIndent && !indent) continue;
                            ts.move(offset);
                            ts.moveNext();
                            int startExpression2 = PHPNewLineIndenter.findStartTokenOfExpression(ts);
                            if (startExpression2 == -1) break;
                            if (continualIndent) {
                                int offsetArrayDeclaration = PHPNewLineIndenter.this.offsetArrayDeclaration(startExpression2, ts);
                                newIndent = offsetArrayDeclaration > -1 ? Utilities.getRowIndent((BaseDocument)doc, (int)offsetArrayDeclaration) + PHPNewLineIndenter.this.itemsArrayDeclararionSize : Utilities.getRowIndent((BaseDocument)doc, (int)startExpression2) + PHPNewLineIndenter.this.continuationSize;
                            }
                            if (!indent) break;
                            newIndent = Utilities.getRowIndent((BaseDocument)doc, (int)startExpression2) + PHPNewLineIndenter.this.indentSize;
                            break;
                        }
                        if (ts.token().id() != PHPTokenId.PHP_OBJECT_OPERATOR && ts.token().id() != PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM || (startExpression = PHPNewLineIndenter.findStartTokenOfExpression(ts)) == -1) continue;
                        int rememberOffset = ts.offset();
                        ts.move(startExpression);
                        ts.moveNext();
                        if (ts.token().id() != PHPTokenId.PHP_IF && ts.token().id() != PHPTokenId.PHP_WHILE && ts.token().id() != PHPTokenId.PHP_FOR && ts.token().id() != PHPTokenId.PHP_FOREACH) {
                            newIndent = Utilities.getRowIndent((BaseDocument)doc, (int)startExpression) + PHPNewLineIndenter.this.continuationSize;
                            break;
                        }
                        ts.move(rememberOffset);
                        ts.moveNext();
                    }
                    if (newIndent < 0) {
                        newIndent = 0;
                    }
                    PHPNewLineIndenter.this.context.modifyIndent(Utilities.getRowStart((BaseDocument)doc, (int)offset), newIndent);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private CodeB4BreakData processCodeBeforeBreak(TokenSequence ts, boolean indentComment) {
        CodeB4BreakData retunValue = new CodeB4BreakData();
        int origOffset = ts.offset();
        Token token = ts.token();
        if (token.id() == PHPTokenId.PHP_SEMICOLON && ts.movePrevious()) {
            retunValue.expressionStartOffset = PHPNewLineIndenter.findStartTokenOfExpression(ts);
            ts.move(retunValue.expressionStartOffset);
            ts.moveNext();
            retunValue.indentDelta = ts.token().id() == PHPTokenId.PHP_CASE || ts.token().id() == PHPTokenId.PHP_DEFAULT ? this.indentSize : 0;
            retunValue.processedByControlStmt = false;
            ts.move(origOffset);
            ts.moveNext();
            return retunValue;
        }
        while (ts.movePrevious()) {
            token = ts.token();
            ScopeDelimiter delimiter = this.getScopeDelimiter(token);
            if (delimiter != null) {
                retunValue.expressionStartOffset = ts.offset();
                retunValue.indentDelta = delimiter.indentDelta;
                if (!CONTROL_STATEMENT_TOKENS.contains(delimiter.tokenId)) break;
                retunValue.indentDelta = 0;
                break;
            }
            if (!indentComment || token.id() != PHPTokenId.WHITESPACE || ((Object)token.text()).toString().indexOf(10) == -1 || !ts.moveNext()) continue;
            retunValue.expressionStartOffset = ts.offset();
            retunValue.indentDelta = 0;
            break;
        }
        if (token.id() == PHPTokenId.PHP_OPENTAG && ts.moveNext()) {
            token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
            retunValue.expressionStartOffset = ts.offset();
            retunValue.indentDelta = 0;
        }
        ts.move(origOffset);
        ts.moveNext();
        return retunValue;
    }

    private int offsetArrayDeclaration(int startExpression, TokenSequence ts) {
        Token token;
        int result = -1;
        int origOffset = ts.offset();
        int balance = 0;
        do {
            if ((token = ts.token()).id() != PHPTokenId.PHP_TOKEN) continue;
            switch (token.text().charAt(0)) {
                case ')': {
                    --balance;
                    break;
                }
                case '(': {
                    ++balance;
                }
            }
        } while (ts.offset() > startExpression && (token.id() != PHPTokenId.PHP_ARRAY || balance != 1) && ts.movePrevious());
        if (token.id() == PHPTokenId.PHP_ARRAY && balance == 1) {
            result = ts.offset();
        }
        ts.move(origOffset);
        ts.moveNext();
        return result;
    }

    protected static int findStartTokenOfExpression(TokenSequence ts) {
        Token<? extends PHPTokenId> token;
        int start = -1;
        int origOffset = ts.offset();
        int balance = 0;
        int curlyBalance = 0;
        do {
            if ((token = ts.token()).id() == PHPTokenId.PHP_TOKEN) {
                switch (token.text().charAt(0)) {
                    case ')': {
                        --balance;
                        break;
                    }
                    case '(': {
                        ++balance;
                    }
                }
                continue;
            }
            if ((token.id() == PHPTokenId.PHP_SEMICOLON || token.id() == PHPTokenId.PHP_OPENTAG) && ts.moveNext()) {
                token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                start = ts.offset();
                break;
            }
            if (token.id() == PHPTokenId.PHP_IF) {
                int offsetIf = ts.offset();
                token = LexUtilities.findNextToken((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.PHP_TOKEN));
                if (ts.offset() < origOffset && token.text().charAt(0) == '(') {
                    int parentBalance = 1;
                    while (start == -1 && parentBalance > 0 && ts.offset() < origOffset && ts.moveNext()) {
                        token = LexUtilities.findNextToken((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.PHP_TOKEN));
                        if (token.text().charAt(0) == '(') {
                            ++parentBalance;
                            continue;
                        }
                        if (token.text().charAt(0) != ')') continue;
                        --parentBalance;
                    }
                    if (parentBalance == 0 && ts.moveNext() && ts.offset() < origOffset) {
                        start = offsetIf;
                        break;
                    }
                    if (parentBalance > 0) {
                        parentBalance = 0;
                        while (parentBalance < 1 && ts.offset() > offsetIf && ts.movePrevious()) {
                            token = LexUtilities.findPreviousToken((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.PHP_TOKEN));
                            if (token.text().charAt(0) == '(') {
                                ++parentBalance;
                                continue;
                            }
                            if (token.text().charAt(0) != ')') continue;
                            --parentBalance;
                        }
                        if (parentBalance != 1 || !ts.movePrevious()) break;
                        token = LexUtilities.findPrevious((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                        start = ts.offset();
                        break;
                    }
                    if (parentBalance != 0) continue;
                    start = offsetIf;
                    break;
                }
                ts.move(offsetIf);
                ts.movePrevious();
                continue;
            }
            if (token.id() == PHPTokenId.PHP_CASE || token.id() == PHPTokenId.PHP_DEFAULT) {
                start = ts.offset();
                break;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                if (--curlyBalance != -1 || !ts.moveNext()) continue;
                token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                if (ts.offset() <= origOffset) {
                    start = ts.offset();
                    break;
                }
                start = origOffset;
                break;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                if (++curlyBalance != 1 || !ts.moveNext()) continue;
                token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                if (ts.offset() <= origOffset) {
                    start = ts.offset();
                    break;
                }
                start = origOffset;
                break;
            }
            if (balance != 1 || token.id() != PHPTokenId.PHP_STRING) continue;
            start = ts.offset();
            break;
        } while (ts.movePrevious());
        if (!ts.movePrevious()) {
            token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_OPENTAG));
            start = ts.offset();
        }
        ts.move(origOffset);
        ts.moveNext();
        return start;
    }

    private int breakProceededByCase(TokenSequence ts) {
        int retunValue = -1;
        int origOffset = ts.offset();
        if (ts.movePrevious() && this.semicolonProceededByBreak(ts)) {
            while (ts.movePrevious()) {
                TokenId tid = ts.token().id();
                if (tid == PHPTokenId.PHP_CASE) {
                    retunValue = ts.offset();
                    break;
                }
                if (!CONTROL_STATEMENT_TOKENS.contains(tid)) continue;
                break;
            }
        }
        ts.move(origOffset);
        ts.moveNext();
        return retunValue;
    }

    private boolean semicolonProceededByBreak(TokenSequence ts) {
        boolean retunValue = false;
        if (ts.token().id() == PHPTokenId.PHP_BREAK) {
            retunValue = true;
        } else if (ts.token().id() == PHPTokenId.PHP_NUMBER) {
            int origOffset = ts.offset();
            if (ts.movePrevious() && ts.token().id() == PHPTokenId.WHITESPACE && ts.movePrevious() && ts.token().id() == PHPTokenId.PHP_BREAK) {
                retunValue = true;
            }
            ts.move(origOffset);
            ts.moveNext();
        }
        return retunValue;
    }

    private ScopeDelimiter getScopeDelimiter(Token token) {
        for (ScopeDelimiter scopeDelimiter : this.scopeDelimiters) {
            if (!scopeDelimiter.matches(token)) continue;
            return scopeDelimiter;
        }
        return null;
    }

    private static class ScopeDelimiter {
        private TokenId tokenId;
        private String tokenContent;
        private int indentDelta;

        public ScopeDelimiter(TokenId tokenId, int indentDelta) {
            this(tokenId, null, indentDelta);
        }

        public ScopeDelimiter(TokenId tokenId, String tokenContent, int indentDelta) {
            this.tokenId = tokenId;
            this.tokenContent = tokenContent;
            this.indentDelta = indentDelta;
        }

        public boolean matches(Token token) {
            if (this.tokenId != token.id()) {
                return false;
            }
            return this.tokenContent == null || !TokenUtilities.equals((CharSequence)token.text(), (Object)this.tokenContent);
        }
    }

    private static class CodeB4BreakData {
        int expressionStartOffset;
        boolean processedByControlStmt;
        int indentDelta;

        private CodeB4BreakData() {
        }
    }
}

