/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.FileElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleFieldDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.openide.util.Parameters;

public class FieldElementImpl
extends PhpElementImpl
implements FieldElement {
    public static final String IDX_FIELD = "field";
    private final PhpModifiers modifiers;
    private final TypeElement enclosingType;
    private final Set<TypeResolver> instanceTypes;

    private FieldElementImpl(TypeElement enclosingType, String fieldName, int offset, int flags, String fileUrl, ElementQuery elementQuery, Set<TypeResolver> instanceTypes) {
        super(FieldElementImpl.getName(fieldName, true), enclosingType.getName(), fileUrl, offset, elementQuery);
        this.modifiers = PhpModifiers.fromBitMask(flags);
        this.enclosingType = enclosingType;
        this.instanceTypes = instanceTypes;
    }

    public static Set<FieldElement> fromSignature(TypeElement type, IndexQueryImpl indexQuery, IndexResult indexResult) {
        return FieldElementImpl.fromSignature(type, NameKind.empty(), indexQuery, indexResult);
    }

    public static Set<FieldElement> fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<FieldElement> retval = values.length > 0 ? new HashSet<FieldElement>() : Collections.emptySet();
        for (String val : values) {
            FieldElement field = FieldElementImpl.fromSignature(type, query, indexQuery, indexResult, Signature.get(val));
            if (field == null) continue;
            retval.add(field);
        }
        return retval;
    }

    public static FieldElement fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature sig) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        FieldSignatureParser signParser = new FieldSignatureParser(sig);
        FieldElementImpl retval = null;
        if (FieldElementImpl.matchesQuery(query, signParser)) {
            retval = new FieldElementImpl(type, signParser.getFieldName(), signParser.getOffset(), signParser.getFlags(), indexResult.getUrl().toString(), indexScopeQuery, signParser.getTypes());
        }
        return retval;
    }

    public static Set<FieldElement> fromNode(TypeElement type, FieldsDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        List<? extends SingleFieldDeclarationInfo> fields = SingleFieldDeclarationInfo.create(node);
        HashSet<FieldElement> retval = new HashSet<FieldElement>();
        for (SingleFieldDeclarationInfo singleFieldDeclarationInfo : fields) {
            String returnType = VariousUtils.getFieldTypeFromPHPDoc(fileQuery.getResult().getProgram(), (SingleFieldDeclaration)singleFieldDeclarationInfo.getOriginalNode());
            retval.add(new FieldElementImpl(type, singleFieldDeclarationInfo.getName(), singleFieldDeclarationInfo.getRange().getStart(), singleFieldDeclarationInfo.getAccessModifiers().toFlags(), fileQuery.getURL().toString(), fileQuery, returnType != null ? TypeResolverImpl.parseTypes(returnType) : null));
        }
        return retval;
    }

    public static FieldElement fromNode(TypeElement type, FieldAccess node, Set<TypeResolver> resolvers, FileElementQuery fileQuery) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"resolvers", resolvers);
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        ASTNodeInfo<FieldAccess> info = ASTNodeInfo.create(node);
        return new FieldElementImpl(type, info.getName(), info.getRange().getStart(), 1, fileQuery.getURL().toString(), fileQuery, resolvers);
    }

    static FieldElement fromFrameworks(TypeElement type, PhpClass.Field field, ElementQuery elementQuery) {
        Parameters.notNull((CharSequence)IDX_FIELD, (Object)field);
        Parameters.notNull((CharSequence)"elementQuery", (Object)elementQuery);
        PhpClass fldType = field.getType();
        Set<TypeResolver> typeResolvers = fldType != null ? Collections.singleton(new TypeResolverImpl(fldType.getFullyQualifiedName())) : Collections.emptySet();
        FieldElementImpl retval = new FieldElementImpl(type, field.getName(), field.getOffset(), 0, null, elementQuery, typeResolvers);
        retval.fileObject = field.getFile();
        return retval;
    }

    private static boolean matchesQuery(NameKind query, FieldSignatureParser signParser) {
        Parameters.notNull((CharSequence)"NameKind query: can't be null", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(FieldElement.KIND, signParser.getFieldName());
    }

    @Override
    public final String getSignature() {
        StringBuilder sb = new StringBuilder();
        String noDollarName = this.getName().substring(1);
        sb.append(noDollarName.toLowerCase()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(noDollarName).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        for (TypeResolver typeResolver : this.getInstanceTypes()) {
            TypeResolverImpl resolverImpl = (TypeResolverImpl)typeResolver;
            sb.append(resolverImpl.getSignature());
        }
        sb.append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        this.checkSignature(sb);
        return sb.toString();
    }

    @Override
    public final PhpElementKind getPhpElementKind() {
        return FieldElement.KIND;
    }

    @Override
    public final PhpModifiers getPhpModifiers() {
        return this.modifiers;
    }

    @Override
    public final TypeElement getType() {
        return this.enclosingType;
    }

    @Override
    public final Set<TypeResolver> getInstanceTypes() {
        return this.instanceTypes;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            FieldSignatureParser parser = new FieldSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getFieldName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            assert (this.getInstanceTypes().size() == parser.getTypes().size());
        }
    }

    @Override
    public final String getName(boolean dollared) {
        return FieldElementImpl.getName(this.getName(), dollared);
    }

    private static String getName(String name, boolean dollared) {
        boolean startsWithDollar = name.startsWith("$");
        if (startsWithDollar == dollared) {
            return name;
        }
        return dollared ? String.format("%s%s", "$", name) : name.substring(1);
    }

    @Override
    public boolean isStatic() {
        return this.getPhpModifiers().isStatic();
    }

    @Override
    public boolean isPublic() {
        return this.getPhpModifiers().isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.getPhpModifiers().isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.getPhpModifiers().isPrivate();
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    private static class FieldSignatureParser {
        private final Signature signature;

        FieldSignatureParser(Signature signature) {
            this.signature = signature;
        }

        String getFieldName() {
            return this.signature.string(1);
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        int getFlags() {
            return this.signature.integer(3);
        }

        Set<TypeResolver> getTypes() {
            return TypeResolverImpl.parseTypes(this.signature.string(4));
        }
    }
}

